/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDatabaseException;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoer11
extends T4CTTIMsg {
    final int MAXERRBUF = 512;
    long curRowNumber;
    long retCode;
    int arrayElemWError;
    int arrayElemErrno;
    int currCursorID;
    short errorPosition;
    short sqlType;
    byte oerFatal;
    short flags;
    short userCursorOpt;
    short upiParam;
    short warningFlag;
    int osError;
    short stmtNumber;
    short callNumber;
    int pad1;
    long successIters;
    int partitionId;
    int tableId;
    int slotNumber;
    long rba;
    long blockNumber;
    int warnLength = 0;
    int warnFlag = 0;
    int[] errorLength = new int[1];
    byte[] errorMsg;
    byte[] oerepa;
    int startErrorOffset;
    int endErrorOffset;
    int[] batchErrorOffsetArray = null;
    static final int OERFNCF = 32;
    static final int ORA1403 = 1403;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIoer11(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)4);
    }

    void init() {
        this.retCode = 0L;
        this.errorMsg = null;
        this.oerepa = null;
        this.startErrorOffset = 0;
        this.endErrorOffset = 0;
        this.batchErrorOffsetArray = null;
    }

    int unmarshal() throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.retCode != 0L) {
            this.unmarshalErrorMessage();
        }
        return this.currCursorID;
    }

    void unmarshalErrorMessage() throws IOException, SQLException {
        this.errorMsg = this.meg.unmarshalCLR();
        this.errorLength[0] = this.errorMsg.length;
    }

    void unmarshalAttributes() throws IOException, SQLException {
        int n2;
        int n3;
        if (this.connection.getTTCVersion() >= 3) {
            short s2;
            this.connection.endToEndECIDSequenceNumber = s2 = (short)this.meg.unmarshalUB2();
        }
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB1();
        this.userCursorOpt = this.meg.unmarshalSB1();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rba = this.meg.unmarshalUB4();
        this.partitionId = this.meg.unmarshalUB2();
        this.tableId = this.meg.unmarshalUB1();
        this.blockNumber = this.meg.unmarshalUB4();
        this.slotNumber = this.meg.unmarshalUB2();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
        byte[] byArray = this.meg.unmarshalDALC();
        byte[] byArray2 = this.connection.tmpBytes128;
        if (byArray != null && byArray.length > 0 && (n3 = byArray.length * 5) > this.connection.tmpBytes128.length) {
            byArray2 = new byte[n3];
        }
        if ((n3 = this.meg.unmarshalDALC(byArray2, 0)) > 0) {
            if (byArray2 == this.connection.tmpBytes128) {
                this.oerepa = Arrays.copyOf(byArray2, byArray2.length);
            } else {
                this.oerepa = byArray2;
                byArray2 = null;
            }
        } else {
            this.oerepa = null;
        }
        if (this.oerepa != null && byArray.length > 0) {
            this.processBatchedErrors(byArray.length);
        }
        if ((n2 = (int)this.meg.unmarshalUB4()) > 0) {
            this.meg.unmarshalUB1();
            byte[][] byArrayArray = new byte[n2][];
            int[] nArray = new int[n2];
            byte[][] byArrayArray2 = new byte[n2][];
            int[] nArray2 = new int[n2];
            this.meg.unmarshalKPDKV(byArrayArray, nArray, byArrayArray2, nArray2);
        }
    }

    private void processBatchedErrors(int n2) {
        this.batchErrorOffsetArray = new int[n2];
        int n3 = this.getErrorOffset(this.oerepa, 0);
        this.batchErrorOffsetArray[0] = this.startErrorOffset;
        for (int i2 = 1; i2 < n2; ++i2) {
            n3 = this.getErrorOffset(this.oerepa, n3);
            this.batchErrorOffsetArray[i2] = this.endErrorOffset;
        }
    }

    private int getErrorOffset(byte[] byArray, int n2) {
        int n3;
        int n4 = n2;
        int n5 = 0;
        if (n2 < byArray.length && (n3 = byArray[n2++] & 0xFF) + n4 < byArray.length) {
            if (n3 == 0) {
                n5 = 0;
            } else if (n3 == 1) {
                n5 = byArray[n2++] & 0xFF;
            } else if (n3 == 2) {
                n5 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            } else if (n3 == 4) {
                n5 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
        }
        if (n4 == 0) {
            this.startErrorOffset = n5;
        } else {
            this.endErrorOffset = n5;
        }
        return n2;
    }

    void unmarshalWarning() throws IOException, SQLException {
        this.retCode = this.meg.unmarshalUB2();
        this.warnLength = this.meg.unmarshalUB2();
        this.warnFlag = this.meg.unmarshalUB2();
        if (this.retCode != 0L && this.warnLength > 0) {
            this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
            this.errorLength[0] = this.warnLength;
        }
    }

    void print() throws SQLException {
        if (this.retCode != 0L) {
        } else if (this.warnFlag != 0) {
        }
    }

    void processError() throws SQLException {
        this.processError(true);
    }

    void processError(boolean bl) throws SQLException {
        this.processError(bl, null);
    }

    void processError(OracleStatement oracleStatement) throws SQLException {
        this.processError(true, oracleStatement);
    }

    void processError(boolean bl, OracleStatement oracleStatement) throws SQLException {
        int n2;
        long l2;
        if (oracleStatement != null) {
            oracleStatement.numberOfExecutedElementsInBatch = (int)this.successIters;
            oracleStatement.indexOfFailedElementsInBatch = this.batchErrorOffsetArray;
        }
        if ((l2 = this.getRetCode()) != 0L) {
            switch ((int)l2) {
                case 28: 
                case 600: 
                case 1012: 
                case 1041: 
                case 3113: 
                case 3114: {
                    this.connection.internalClose();
                    break;
                }
                case 902: 
                case 21700: {
                    this.connection.removeAllDescriptor();
                    break;
                }
                case 41408: 
                case 41409: {
                    if ((this.flags & 0x10) != 16) break;
                    try {
                        this.connection.abort();
                    }
                    catch (Throwable throwable) {
                    }
                    this.connection.internalClose();
                }
            }
            if (bl) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), (int)l2).fillInStackTrace();
                if (this.errorPosition >= 0 && oracleStatement != null) {
                    sQLException.initCause(new OracleDatabaseException(this.errorPosition, (int)this.retCode, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), oracleStatement.sqlObject.actualSql, oracleStatement.sqlObject.originalSql, oracleStatement.isSqlRewritten()));
                }
                throw sQLException;
            }
            return;
        }
        if (!bl) {
            return;
        }
        if ((this.warningFlag & 1) == 1 && (((n2 = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (n2 & 4) == 4)) {
            throw (SQLException)DatabaseError.createSqlException(110).fillInStackTrace();
        }
        if (this.connection != null && this.connection.plsqlCompilerWarnings && (this.flags & 4) == 4) {
            oracleStatement.foundPlsqlCompilerWarning();
        }
    }

    void processWarning() throws SQLException {
        if (this.retCode != 0L) {
            throw DatabaseError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), (int)this.retCode);
        }
    }

    long getCurRowNumber() throws SQLException {
        return this.curRowNumber;
    }

    long getRetCode() {
        return this.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    long updateChecksum(long l2) throws SQLException {
        l2 = CRC64.updateChecksum(l2, this.retCode);
        l2 = CRC64.updateChecksum(l2, this.curRowNumber);
        l2 = CRC64.updateChecksum(l2, this.errorPosition);
        l2 = CRC64.updateChecksum(l2, this.sqlType);
        l2 = CRC64.updateChecksum(l2, this.oerFatal);
        l2 = CRC64.updateChecksum(l2, this.flags);
        l2 = CRC64.updateChecksum(l2, this.userCursorOpt);
        l2 = CRC64.updateChecksum(l2, this.upiParam);
        l2 = CRC64.updateChecksum(l2, this.warningFlag);
        l2 = CRC64.updateChecksum(l2, this.osError);
        l2 = CRC64.updateChecksum(l2, this.successIters);
        l2 = CRC64.updateChecksum(l2, this.errorMsg, 0, this.errorMsg.length);
        return l2;
    }

    @Log
    protected void debug(Logger logger2, Level level, Executable executable, String string) {
        ClioSupport.log(logger2, level, this.getClass(), executable, string);
    }
}

