/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8TTIuds;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CJsonAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeADT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIdcb
extends T4CTTIMsg {
    static final int DCBRXFR = 1;
    static final int DCBFIOT = 2;
    static final int DCBFHAVECOOKIE = 4;
    static final int DCBFNEWCOOKIE = 8;
    static final int DCBFREM = 16;
    int numuds;
    int colOffset;
    byte[] ignoreBuff = new byte[40];
    OracleStatement statement = null;

    T4CTTIdcb(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)16);
    }

    void init(OracleStatement oracleStatement, int n2) {
        this.statement = oracleStatement;
        this.colOffset = n2;
    }

    Accessor[] receive(Accessor[] accessorArray) throws SQLException, IOException {
        short s2 = this.meg.unmarshalUB1();
        if (this.ignoreBuff.length < s2) {
            this.ignoreBuff = new byte[s2];
        }
        this.meg.unmarshalNBytes(this.ignoreBuff, 0, s2);
        int n2 = (int)this.meg.unmarshalUB4();
        accessorArray = this.receiveCommon(accessorArray, false);
        return accessorArray;
    }

    Accessor[] receiveFromRefCursor(Accessor[] accessorArray) throws SQLException, IOException {
        short s2 = this.meg.unmarshalUB1();
        int n2 = (int)this.meg.unmarshalUB4();
        accessorArray = this.receiveCommon(accessorArray, false);
        return accessorArray;
    }

    Accessor[] receiveCommon(Accessor[] accessorArray, boolean bl) throws SQLException, IOException {
        Accessor[] accessorArray2 = null;
        if (bl) {
            this.numuds = this.meg.unmarshalUB2();
        } else {
            this.numuds = (int)this.meg.unmarshalUB4();
            if (this.numuds > 0) {
                short s2 = this.meg.unmarshalUB1();
            }
        }
        if (!this.statement.needToPrepareDefineBuffer && this.statement.numberOfDefinePositions != this.numuds) {
            this.statement.needToPrepareDefineBuffer = true;
        }
        if (this.statement.currentResultSet != null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1703).fillInStackTrace();
        }
        if (accessorArray != null) {
            accessorArray2 = accessorArray;
        }
        Accessor[] accessorArray3 = new Accessor[this.numuds + this.colOffset];
        if (accessorArray != null && accessorArray.length == this.colOffset) {
            System.arraycopy(accessorArray, 0, accessorArray3, 0, this.colOffset);
        }
        accessorArray = accessorArray3;
        T4C8TTIuds t4C8TTIuds = new T4C8TTIuds((T4CConnection)this.statement.connection);
        long l2 = this.statement.checkSum;
        for (int i2 = 0; i2 < this.numuds; ++i2) {
            t4C8TTIuds.unmarshal();
            String string = this.meg.conv.CharBytesToString(t4C8TTIuds.getColumName(), t4C8TTIuds.getColumNameByteLength());
            l2 = this.fillupAccessors(accessorArray, accessorArray2, i2, this.colOffset + i2, t4C8TTIuds, string, l2);
        }
        accessorArray2 = null;
        this.statement.checkSum = l2;
        if (!bl) {
            byte[] byArray = this.meg.unmarshalDALC();
            if (this.connection.getTTCVersion() >= 3) {
                int n2 = (int)this.meg.unmarshalUB4();
                int n3 = (int)this.meg.unmarshalUB4();
                if (this.connection.getTTCVersion() >= 4) {
                    int n4 = (int)this.meg.unmarshalUB4();
                    int n5 = (int)this.meg.unmarshalUB4();
                    if (this.connection.getTTCVersion() >= 5) {
                        byte[] byArray2 = this.meg.unmarshalDALC();
                        this.statement.setQueryCompileKey(byArray2);
                    }
                }
            }
        }
        if (!bl) {
            this.statement.rowPrefetchInLastFetch = -1;
            this.statement.describedWithNames = true;
            this.statement.described = true;
            this.statement.numberOfDefinePositions = this.numuds;
            this.statement.accessors = accessorArray;
            this.statement.prepareAccessors();
            this.statement.allocateTmpByteArray();
        }
        return accessorArray;
    }

    long fillupAccessors(Accessor[] accessorArray, Accessor[] accessorArray2, int n2, int n3, T4C8TTIuds t4C8TTIuds, String string, long l2) throws SQLException {
        short s2;
        int[] nArray = this.statement.definedColumnType;
        int[] nArray2 = this.statement.definedColumnSize;
        int[] nArray3 = this.statement.definedColumnFormOfUse;
        int n4 = this.statement.isRowidPrepended ? 1 : 0;
        String string2 = null;
        String string3 = null;
        Object object = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n3 >= n4) {
            s2 = n3 - n4;
            if (nArray != null && nArray.length > s2 && nArray[s2] != 0) {
                n5 = nArray[s2];
            }
            if (nArray2 != null && nArray2.length > s2 && nArray2[s2] > 0) {
                n6 = nArray2[s2];
            }
            if (nArray3 != null && nArray3.length > s2 && nArray3[s2] > 0) {
                n7 = nArray3[s2];
            }
        }
        int n8 = t4C8TTIuds.udsoac.oacmxl;
        switch (t4C8TTIuds.udsoac.oacdty) {
            case 96: {
                if (t4C8TTIuds.udsoac.oacmxlc != 0 && t4C8TTIuds.udsoac.oacmxlc < n8) {
                    n8 = 2 * t4C8TTIuds.udsoac.oacmxlc;
                }
                int n9 = n8;
                if ((n5 == 1 || n5 == 12) && n6 > 0 && n6 < n8) {
                    n9 = n6;
                }
                accessorArray[n3] = new T4CCharAccessor(this.statement, n9, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, t4C8TTIuds.udsoac.oacmxlc, n8, n5, n6, this.meg);
                accessorArray[n3].describeMaxLength = t4C8TTIuds.udsoac.oacmxl;
                break;
            }
            case 2: {
                accessorArray[n3] = new T4CNumberAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 1: {
                if (t4C8TTIuds.udsoac.oacmxlc != 0 && t4C8TTIuds.udsoac.oacmxlc < n8) {
                    n8 = 2 * t4C8TTIuds.udsoac.oacmxlc;
                }
                int n10 = n8;
                if ((n5 == 1 || n5 == 12) && n6 > 0 && n6 < n8) {
                    n10 = n6;
                }
                accessorArray[n3] = new T4CVarcharAccessor(this.statement, n10, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, t4C8TTIuds.udsoac.oacmxlc, n8, n5, n6, this.meg);
                accessorArray[n3].describeMaxLength = t4C8TTIuds.udsoac.oacmxl;
                break;
            }
            case 8: {
                if (this.statement.isFetchStreams || (n5 == 1 || n5 == 12) && this.connection.versionNumber >= 9000 && n6 < 4001) {
                    int n11 = n6 > 0 ? n6 : n8;
                    accessorArray[n3] = new T4CVarcharAccessor(this.statement, n11, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, t4C8TTIuds.udsoac.oacmxlc, -1, n5, n6, this.meg);
                    accessorArray[n3].describeType = 8;
                    break;
                }
                n8 = 0;
                accessorArray[n3] = new T4CLongAccessor(this.statement, n3 + 1, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 6: {
                accessorArray[n3] = new T4CVarnumAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 100: {
                accessorArray[n3] = new T4CBinaryFloatAccessor(this.statement, 4, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 101: {
                accessorArray[n3] = new T4CBinaryDoubleAccessor(this.statement, 8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 23: {
                accessorArray[n3] = new T4CRawAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 24: {
                if (this.statement.isFetchStreams || n5 == -2 && n6 < 2001 && this.connection.versionNumber >= 9000) {
                    n8 = -1;
                    accessorArray[n3] = new T4CRawAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                    accessorArray[n3].describeType = 24;
                    break;
                }
                accessorArray[n3] = new T4CLongRawAccessor(this.statement, n3 + 1, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 11: 
            case 104: 
            case 208: {
                accessorArray[n3] = new T4CRowidAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                if (t4C8TTIuds.udsoac.oacdty != 208) break;
                accessorArray[n3].describeType = 208;
                break;
            }
            case 102: {
                accessorArray[n3] = new T4CResultSetAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 12: {
                accessorArray[n3] = new T4CDateAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 113: {
                if (n5 == -4 && this.connection.versionNumber >= 9000) {
                    accessorArray[n3] = new T4CLongRawAccessor(this.statement, n3 + 1, Integer.MAX_VALUE, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                    accessorArray[n3].describeType = 113;
                    break;
                }
                if (n5 == -3 && this.connection.versionNumber >= 9000) {
                    accessorArray[n3] = new T4CRawAccessor(this.statement, 4000, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                    accessorArray[n3].describeType = 113;
                    break;
                }
                accessorArray[n3] = new T4CBlobAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                if (accessorArray2 != null) {
                    accessorArray[n3].setPrefetchLength(accessorArray2[n2].lobPrefetchSizeForThisColumn);
                    break;
                }
                if (this.connection.useLobPrefetch && n5 == 2004) {
                    accessorArray[n3].setPrefetchLength(n6);
                    break;
                }
                accessorArray[n3].setNoPrefetch();
                break;
            }
            case 119: {
                accessorArray[n3] = new T4CJsonAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                if (accessorArray2 != null) {
                    accessorArray[n3].setPrefetchLength(accessorArray2[n2].lobPrefetchSizeForThisColumn);
                    break;
                }
                if (this.connection.useLobPrefetch && n5 == 2016) {
                    accessorArray[n3].setPrefetchLength(n6);
                    break;
                }
                accessorArray[n3].setNoPrefetch();
                break;
            }
            case 112: {
                s2 = 1;
                if (n7 != 0) {
                    s2 = (short)n7;
                }
                if ((n5 == -1 || n5 == -16) && this.connection.versionNumber >= 9000) {
                    n8 = 0;
                    accessorArray[n3] = new T4CLongAccessor(this.statement, n3 + 1, Integer.MAX_VALUE, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, s2, n5, n6, this.meg);
                    accessorArray[n3].describeType = 112;
                    break;
                }
                if ((n5 == 12 || n5 == 1 || n5 == -15 || n5 == -9) && this.connection.versionNumber >= 9000) {
                    int n12 = Short.MAX_VALUE;
                    if (n6 > 0 && n6 < n12) {
                        n12 = n6;
                    }
                    accessorArray[n3] = new T4CVarcharAccessor(this.statement, n12, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, s2, t4C8TTIuds.udsoac.oacmxlc, Short.MAX_VALUE, n5, n6, this.meg);
                    accessorArray[n3].describeType = 112;
                    break;
                }
                accessorArray[n3] = new T4CClobAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                if (accessorArray2 != null) {
                    accessorArray[n3].setPrefetchLength(accessorArray2[n2].lobPrefetchSizeForThisColumn);
                    break;
                }
                if (this.connection.useLobPrefetch && (n5 == 2005 || n5 == 2011)) {
                    accessorArray[n3].setPrefetchLength(n6);
                    break;
                }
                accessorArray[n3].setNoPrefetch();
                break;
            }
            case 114: {
                accessorArray[n3] = new T4CBfileAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                if (accessorArray2 != null) {
                    accessorArray[n3].setPrefetchLength(accessorArray2[n2].lobPrefetchSizeForThisColumn);
                    break;
                }
                if (this.connection.useLobPrefetch && n5 == -13) {
                    accessorArray[n3].setPrefetchLength(n6);
                    break;
                }
                accessorArray[n3].setNoPrefetch();
                break;
            }
            case 109: {
                string2 = this.meg.conv.CharBytesToString(t4C8TTIuds.getTypeName(), t4C8TTIuds.getTypeCharLength());
                string3 = this.meg.conv.CharBytesToString(t4C8TTIuds.getSchemaName(), t4C8TTIuds.getSchemaCharLength());
                object = PhysicalConnection.needToQuoteIdentifier(string3) || PhysicalConnection.needToQuoteIdentifier(string2) ? String.format("\"%s\".\"%s\"", string3, string2) : string3 + "." + string2;
                accessorArray[n3] = new T4CNamedTypeAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, (String)object, n5, n6, this.meg);
                break;
            }
            case 111: {
                string2 = this.meg.conv.CharBytesToString(t4C8TTIuds.getTypeName(), t4C8TTIuds.getTypeCharLength());
                string3 = this.meg.conv.CharBytesToString(t4C8TTIuds.getSchemaName(), t4C8TTIuds.getSchemaCharLength());
                object = string3 + "." + string2;
                accessorArray[n3] = new T4CRefTypeAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, (String)object, n5, n6, this.meg);
                break;
            }
            case 180: {
                accessorArray[n3] = new T4CTimestampAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 181: {
                accessorArray[n3] = new T4CTimestamptzAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 231: {
                accessorArray[n3] = new T4CTimestampltzAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 182: {
                accessorArray[n3] = new T4CIntervalymAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            case 183: {
                accessorArray[n3] = new T4CIntervaldsAccessor(this.statement, n8, t4C8TTIuds.udsnull, t4C8TTIuds.udsoac.oacflg, t4C8TTIuds.udsoac.oacpre, t4C8TTIuds.udsoac.oacscl, t4C8TTIuds.udsoac.oacfl2, t4C8TTIuds.udsoac.oacmal, t4C8TTIuds.udsoac.oaccsfrm, n5, n6, this.meg);
                break;
            }
            default: {
                assert (false) : "ud.udsoac.oacdty: " + t4C8TTIuds.udsoac.oacdty;
                accessorArray[n3] = null;
            }
        }
        accessorArray[n3].internalOtype = t4C8TTIuds.udsoac.oactoid.length > 0 ? new OracleTypeADT(t4C8TTIuds.udsoac.oactoid, t4C8TTIuds.udsoac.oacvsn, t4C8TTIuds.udsoac.oaccsi, t4C8TTIuds.udsoac.oaccsfrm, string3 + "." + string2) : null;
        accessorArray[n3].columnName = string;
        accessorArray[n3].securityAttribute = OracleResultSetMetaData.SecurityAttribute.NONE;
        if ((t4C8TTIuds.udsflg & 1) != 0) {
            accessorArray[n3].securityAttribute = OracleResultSetMetaData.SecurityAttribute.ENABLED;
        } else if ((t4C8TTIuds.udsflg & 2) != 0) {
            accessorArray[n3].securityAttribute = OracleResultSetMetaData.SecurityAttribute.UNKNOWN;
        }
        accessorArray[n3].setColumnInvisible((t4C8TTIuds.udsflg & 8) != 0);
        accessorArray[n3].setColumnJSON((t4C8TTIuds.udsflg & 0x100) != 0);
        if (t4C8TTIuds.udsoac.oacmxl == 0) {
            accessorArray[n3].isNullByDescribe = true;
        }
        accessorArray[n3].udskpos = t4C8TTIuds.getKernelPosition();
        if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
            l2 = CRC64.updateChecksum(l2, t4C8TTIuds.udsoac.oacdty);
            l2 = CRC64.updateChecksum(l2, t4C8TTIuds.udsoac.oacmxl);
            l2 = CRC64.updateChecksum(l2, t4C8TTIuds.udsoac.oacpre);
            l2 = CRC64.updateChecksum(l2, t4C8TTIuds.udsoac.oacscl);
            l2 = CRC64.updateChecksum(l2, t4C8TTIuds.udsoac.oaccsfrm);
            if (string2 != null) {
                l2 = CRC64.updateChecksum(l2, string3 + "." + string2);
            }
            l2 = CRC64.updateChecksum(l2, string);
        }
        return l2;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    @Log
    protected void debug(Logger logger2, Level level, Executable executable, String string) {
        ClioSupport.log(logger2, level, this.getClass(), executable, string);
    }
}

