/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.web.health;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;

public final class Healthcheck {
    private static final String overallHealth = "overall_health";

    private Healthcheck() {
    }

    public static String overallHealthAs(Status status) {
        return Healthcheck.overallHealthAs(status, Collections.emptyMap());
    }

    public static String overallHealthAs(Status status, Map<String, String> details) {
        return Healthcheck.overallHealthAs(status.name(), details);
    }

    public static String overallHealthAs(String status, Map<String, String> details) {
        String string;
        block8: {
            StringWriter out = new StringWriter();
            JsonGenerator json = new JsonFactory().createGenerator(out);
            try {
                json.setPrettyPrinter(new DefaultPrettyPrinter());
                Healthcheck.asJSON(status, details, json).close();
                string = out.getBuffer().toString();
                if (json == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (json != null) {
                        try {
                            json.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return "{\"overall_health\":\"bad\",\"json_generation\":\"failed\"}";
                }
            }
            json.close();
        }
        return string;
    }

    private static JsonGenerator asJSON(String status, Map<String, String> details, JsonGenerator json) throws IOException {
        json.writeStartObject();
        json.writeStringField(overallHealth, status);
        for (Map.Entry<String, String> each : details.entrySet()) {
            json.writeStringField(each.getKey(), each.getValue());
        }
        json.writeEndObject();
        return json;
    }

    public static enum Status {
        good,
        bad;

    }
}

