/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.web.beispielseite;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import luwa.marlin.web.OutputView;

public class Einstiegsseite
implements OutputView {
    private final String beschreibung;
    private final List<BeispielLink> beispielLinks;

    @Override
    public String name() {
        return "Einstiegsseite";
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    public Einstiegsseite(String beschreibung, List<BeispielLink> beispielLinks) {
        this.beschreibung = beschreibung;
        this.beispielLinks = beispielLinks;
    }

    @Override
    public void writeTo(OutputStream stream) throws Exception {
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, StandardCharsets.UTF_8);
        out.println("<!DOCTYPE html>");
        out.println("<html>");
        out.println("<head>");
        out.println("<style>");
        out.println("* { font-family: sans-serif }");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<ul>");
        out.println("<h1>" + this.beschreibung + "</h1>");
        out.println("<h2>Beispiel-Anfragen</h2>");
        for (BeispielLink link : this.beispielLinks) {
            out.println("<li>" + link.toHtml() + "</li>");
        }
        out.println("</ul>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }

    public static class BeispielLink {
        private final String text;
        private final String href;

        public BeispielLink(String text, String href) {
            this.text = text;
            this.href = href;
        }

        public String text() {
            return this.text;
        }

        public String href() {
            return this.href;
        }

        public String toHtml() {
            return "<a href=\"" + this.href() + "\">" + this.text() + "</a>";
        }

        public static BeispielLink link(String text, String href) {
            return new BeispielLink(text, href);
        }
    }
}

