/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.wasserstand.abflussmessung;

import java.util.Objects;
import java.util.Optional;

public abstract class NamedEnumValue {
    private final int id;
    private final Optional<String> name;

    public NamedEnumValue(int id, Optional<String> name) {
        this.id = id;
        this.name = name;
    }

    public NamedEnumValue(int id) {
        this(id, Optional.empty());
    }

    public int id() {
        return this.id;
    }

    public Optional<String> name() {
        return this.name;
    }

    public String nameOrEmpty() {
        return this.name().orElse("");
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        NamedEnumValue namedEnum = (NamedEnumValue)o2;
        return this.id == namedEnum.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" {\n\tid: ");
        builder.append(this.id);
        builder.append("\n\tname: ");
        builder.append(this.name);
        builder.append("\n}");
        return builder.toString();
    }
}

