/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.wasserstand;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import luwa.marlin.wasserstand.PegelnullpunkRepository;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.Pegelnullpunkte;
import luwa.marlin.wasserstand.TranformToNHN;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;

public class NHNTransformation {
    protected final BiFunction<ZonedDateTime, Double, Double> transform;
    protected final Function<ZonedDateTime, Optional<Pegelnullpunkt>> PNP;
    protected final Function<Double, Double> singleTransform;
    protected final boolean shouldDoNothing;
    protected final Optional<Pegelnullpunkt> singlePNP;

    public NHNTransformation(List<Pegelnullpunkt> pegelnullpunkte, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        switch (wasserstandBezugsh\u00f6he) {
            case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                this.shouldDoNothing = true;
                this.transform = (zeitpunkt, wert) -> wert;
                this.PNP = zeitpunkt -> {
                    throw new IllegalArgumentException("Nur im NHN-Modus m\u00f6glich.");
                };
                this.singleTransform = wert -> wert;
                this.singlePNP = Optional.empty();
                break;
            }
            case Meter\u00dcberNHNnachHS170: {
                this.shouldDoNothing = false;
                this.transform = (zeitpunkt, wert) -> TranformToNHN.transformDoubleValueToNHN(zeitpunkt, wert, new Pegelnullpunkte(pegelnullpunkte));
                this.PNP = zeitpunkt -> new Pegelnullpunkte(pegelnullpunkte).amZeitpunkt((ZonedDateTime)zeitpunkt);
                this.singleTransform = wert -> {
                    if (pegelnullpunkte.size() != 1) {
                        throw new IllegalStateException("Werte ohne Zeitangabe k\u00f6nnen nur transformiert werden, wenn genau ein Pegelnullpunkt gegeben ist.");
                    }
                    ZonedDateTime irgendeinG\u00fcltigerZeitpunkt = ((Pegelnullpunkt)pegelnullpunkte.get(0)).g\u00fcltigVon();
                    return this.transform.apply(irgendeinG\u00fcltigerZeitpunkt, (Double)wert);
                };
                this.singlePNP = pegelnullpunkte.size() != 1 ? Optional.empty() : Optional.of(pegelnullpunkte.get(0));
                break;
            }
            default: {
                throw new IllegalArgumentException(wasserstandBezugsh\u00f6he.toString());
            }
        }
    }

    public static NHNTransformation buildNHNTransform(long messstellenNummer, PegelnullpunkRepository pegelnullpunkRepository) throws Exception {
        return NHNTransformation.buildNHNTransform(messstellenNummer, pegelnullpunkRepository, WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170);
    }

    public static NHNTransformation buildNHNTransform(long messstellenNummer, PegelnullpunkRepository pegelnullpunkRepository, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) throws Exception {
        List<Pegelnullpunkt> pegelnullpunkte = pegelnullpunkRepository.pegelnullpunkte(messstellenNummer);
        return new NHNTransformation(pegelnullpunkte, wasserstandBezugsh\u00f6he);
    }

    public static NHNTransformation doNothing() {
        return new NHNTransformation(null, WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt);
    }

    public <T> T forValue(Optional<Double> vielleichtWert, ZonedDateTime amZeitpunkt, BiFunction<ZonedDateTime, Optional<Double>, T> constructor) {
        if (this.shouldDoNothing) {
            return constructor.apply(amZeitpunkt, vielleichtWert);
        }
        return (T)vielleichtWert.map(wert -> {
            Double transformierterWert = this.transform.apply(amZeitpunkt, (Double)wert);
            return constructor.apply(amZeitpunkt, Optional.of(transformierterWert));
        }).orElse(constructor.apply(amZeitpunkt, Optional.empty()));
    }

    public Optional<Pegelnullpunkt> PNP(Optional<ZonedDateTime> zeitpunkt) {
        if (zeitpunkt.isPresent()) {
            return this.PNP.apply(zeitpunkt.get());
        }
        return this.singlePNP;
    }

    public double forValue(double wert, ZonedDateTime amZeitpunkt) {
        if (this.shouldDoNothing) {
            return wert;
        }
        return this.transform.apply(amZeitpunkt, wert);
    }

    public double forValue(double wert, ZonedDateTime start, ZonedDateTime end) {
        if (this.shouldDoNothing) {
            return wert;
        }
        return this.transform.apply(start, wert);
    }

    public double forValue(double value) {
        return this.singleTransform.apply(value);
    }
}

