/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Optional;
import luwa.marlin.time.TimeZone;

public final class SqlHelpers {
    private static Calendar calendar() {
        return Calendar.getInstance(TimeZone.calendarTimeZoneMEZ);
    }

    public static ZonedDateTime getDateTime(ResultSet resultSet, String columnName) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(columnName, SqlHelpers.calendar());
        if (resultSet.wasNull()) {
            return null;
        }
        return timestamp.toInstant().atZone(TimeZone.timeZoneMEZ);
    }

    public static Optional<ZonedDateTime> getNullableDateTime(ResultSet resultSet, String columnName) throws SQLException {
        return Optional.ofNullable(SqlHelpers.getDateTime(resultSet, columnName));
    }

    public static void setDateTime(PreparedStatement statement, int parameterIndex, ZonedDateTime dateTime) throws SQLException {
        statement.setTimestamp(parameterIndex, SqlHelpers.timestamp(dateTime), SqlHelpers.calendar());
    }

    private static Timestamp timestamp(ZonedDateTime dateTime) {
        if (null == dateTime) {
            return null;
        }
        return Timestamp.from(dateTime.toInstant());
    }

    public static String getNullSafeString(ResultSet rs, String columnLabel) throws SQLException {
        return SqlHelpers.getOptionalString(rs, columnLabel).orElse("");
    }

    public static Optional<String> getOptionalString(ResultSet rs, String columnLabel) throws SQLException {
        String value = rs.getString(columnLabel);
        if (value == null || rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Double> getOptionalDouble(ResultSet rs, String columnLabel) throws SQLException {
        double value = rs.getDouble(columnLabel);
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Integer> getOptionalInt(ResultSet rs, String columnLabel) throws SQLException {
        int value = rs.getInt(columnLabel);
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Long> getOptionalLong(ResultSet rs, String columnLabel) throws SQLException {
        long value = rs.getLong(columnLabel);
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static String eventuellFromDual(Connection connection) throws SQLException {
        return SqlHelpers.istOracleDatenbank(connection) ? " FROM dual" : "";
    }

    private static boolean istOracleDatenbank(Connection connection) throws SQLException {
        String treiberName = connection.getMetaData().getDriverName();
        return !treiberName.startsWith("PostgreSQL");
    }
}

