/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text.helpers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import luwa.marlin.ship_library.util.Format;

public class Padding {
    public static final NumberFormat kmFormat = new DecimalFormat("#.0", DecimalFormatSymbols.getInstance(Locale.GERMAN));

    public static String pad(String s2, int n2) {
        String str = Format.nullSafeString(s2);
        int missing = n2 - str.length();
        return Padding.spaces(missing / 2) + str + Padding.spaces(missing / 2);
    }

    public static String leftPad(String s2, int n2) {
        String str = Format.nullSafeString(s2);
        return Padding.spaces(n2 - str.length()) + str;
    }

    public static String leftPadAdaptSpaces(String s2, int n2) {
        String str = Format.nullSafeStringWittHalfedDoubleSpaces(s2);
        return Padding.spaces(n2 - str.length()) + str;
    }

    public static String rightPad(String s2, int n2) {
        String str = Format.nullSafeString(s2);
        return str + Padding.spaces(n2 - str.length());
    }

    public static String spaces(int n2) {
        return IntStream.range(0, n2).mapToObj(i2 -> " ").collect(Collectors.joining());
    }
}

