/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text.helpers;

import java.io.PrintStream;
import java.util.List;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Organisation;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import org.joda.time.DateTime;

public class MetaInformationen {
    private final Benutzer benutzer;
    private final Iterable<Messstelle> messstellen;
    private final Trennzeichen trennzeichen;

    public MetaInformationen(Benutzer benutzer, Messstelle messstelle, Trennzeichen trennzeichen) {
        this(benutzer, List.of(messstelle), trennzeichen);
    }

    public MetaInformationen(Benutzer benutzer, Iterable<Messstelle> messstellen, Trennzeichen trennzeichen) {
        this.benutzer = benutzer;
        this.messstellen = messstellen;
        this.trennzeichen = trennzeichen;
    }

    public void writeTo(PrintStream out) {
        for (Messstelle messstelle : this.messstellen) {
            out.print(messstelle.bezeichnung());
            this.trennzeichen.trennzeichen(out);
            out.print("Pegelbetreiber: " + messstelle.betreiber());
            out.println();
        }
        out.print("Herausgeber: " + this.benutzer.organisationseinheiten().split(",")[0]);
        this.trennzeichen.trennzeichen(out);
        out.print("Quelle: " + Organisation.kurzname());
        this.trennzeichen.trennzeichen(out);
        out.print("Datenstand: ");
        out.print(Format.formatDay(new DateTime()));
        out.println();
    }
}

