/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Messsystem;
import luwa.marlin.ship_library.model.Notizen;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.helpers.MetaInformationen;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Pegelnotizen
implements OutputView {
    private final Model model;
    private final Trennzeichen trennzeichen;
    private static final DateTimeZone zeitzone = DateTimeZone.forOffsetHours(1);
    private static final DateTimeFormatter zeitFormat = DateTimeFormat.forPattern("dd.MM.yyyy HH:mm");

    public Pegelnotizen(Model model, Trennzeichen trennzeichen) {
        this.model = model;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Pegelnotizen";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private void writeTo(PrintStream out) {
        this.schreibe\u00dcberschriften(out, this.model.messstelle(), this.model.benutzer());
        for (Notizen.Pegelnotiz notiz : this.model.notizen().notizen()) {
            this.schreibeNotizZeile(out, notiz);
        }
    }

    private void schreibe\u00dcberschriften(PrintStream out, Messstelle messstelle, Benutzer benutzer) {
        this.schreibeAllgemeine\u00dcberschriften(out, messstelle, benutzer);
        this.schreibeSpalten\u00fcberschriften(out);
    }

    private void schreibeAllgemeine\u00dcberschriften(PrintStream out, Messstelle messstelle, Benutzer benutzer) {
        out.print("Pegelnotizen");
        this.trennzeichen(out);
        out.println("Zeitbezug MEZ");
        new MetaInformationen(benutzer, messstelle, this.trennzeichen).writeTo(out);
    }

    private void schreibeSpalten\u00fcberschriften(PrintStream out) {
        out.print("Datum Uhrzeit");
        this.trennzeichen(out);
        out.print("Hauptsystem");
        this.trennzeichen(out);
        out.print("Redundanzsystem");
        this.trennzeichen(out);
        out.print("Notiznummer");
        this.trennzeichen(out);
        out.print("Notiztext");
        out.println();
    }

    private void schreibeNotizZeile(PrintStream out, Notizen.Pegelnotiz notiz) {
        out.print(Pegelnotizen.minutengenau(notiz.zeitpunkt().withZone(zeitzone)));
        this.trennzeichen(out);
        out.print(notiz.messsystem() == Messsystem.haupt ? notiz.messsystem().abk\u00fcrzung() : "");
        this.trennzeichen(out);
        out.print(notiz.messsystem() == Messsystem.redundanz ? notiz.messsystem().abk\u00fcrzung() : "");
        this.trennzeichen(out);
        out.print(notiz.nummer());
        this.trennzeichen(out);
        out.print(notiz.text());
        out.println();
    }

    private void trennzeichen(PrintStream out) {
        out.print(this.trennzeichen.zeichen());
    }

    public static String minutengenau(DateTime zeitpunkt) {
        return zeitFormat.print(zeitpunkt);
    }

    public static class Model {
        private final Messstelle messstelle;
        private final Benutzer benutzer;
        private final Notizen notizen;

        public Model(Messstelle messstelle, Benutzer benutzer, Notizen notizen) {
            this.messstelle = messstelle;
            this.benutzer = benutzer;
            this.notizen = notizen;
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        public Notizen notizen() {
            return this.notizen;
        }

        public static Model lade(DatenRepository source, long messstellenNummer, Interval zeitraum, long benutzerId) throws Exception {
            Messstelle messstelle = source.messstelle(messstellenNummer);
            Benutzer benutzer = source.benutzer(benutzerId);
            Notizen notizen = source.notizen(messstellenNummer, zeitraum);
            return new Model(messstelle, benutzer, notizen);
        }

        public Benutzer benutzer() {
            return this.benutzer;
        }
    }
}

