/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.IOException;
import java.io.OutputStream;
import luwa.marlin.ship_library.view.pdf.helpers.Rendering;
import luwa.marlin.web.OutputView;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class PDFErrorPage
implements OutputView {
    private final RuntimeException errorToShow;
    private final boolean NHNHinweisZeigen;

    public PDFErrorPage(RuntimeException errorToShow, boolean NHNHinweisZeigen) {
        this.errorToShow = errorToShow;
        this.NHNHinweisZeigen = NHNHinweisZeigen;
    }

    @Override
    public String name() {
        return "Fehler bei der Erstellung eines Ausgabeprodukts.";
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage(PDRectangle.A4);
            try (PDPageContentStream content = new PDPageContentStream(document, page);){
                this.render(content);
            }
            document.addPage(page);
            document.save(out);
        }
    }

    private void render(PDPageContentStream content) throws IOException {
        content.setFont(PDType1Font.HELVETICA, 12.0f);
        if (this.NHNHinweisZeigen) {
            Rendering.textAt(content, 10.0f, 775.0f, "M\u00f6glicherweise fehlen NHN-Daten f\u00fcr einen Pegelnullpunkt im gew\u00e4hlten Zeitraum.");
        }
        Rendering.textAt(content, 10.0f, 755.0f, "FEHLER: " + this.errorToShow.getMessage());
        Throwable cause = this.errorToShow.getCause();
        if (cause != null) {
            Rendering.textAt(content, 10.0f, 735.0f, "Details: " + cause);
        }
    }
}

