/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.Gepr\u00fcfteZeitbereiche;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.DatenRepositoryMitVerkettung;
import luwa.marlin.ship_library.view.pdf.helpers.FestgelegterFormatierer;
import luwa.marlin.ship_library.view.text.helpers.Listenprodukt;
import luwa.marlin.ship_library.view.text.helpers.MetaInformationen;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Liste
implements OutputView {
    private static final String darstellungL\u00fccke = "-999";
    private final DatenRepository source;
    private final Iterable<Long> messstellenNummern;
    private final Interval zeitraum;
    private final Parameter parameter;
    private final AbflussOderWasserstand abflussOderWasserstand;
    private final Listenprodukt listenprodukt;
    private final boolean mitVorg\u00e4ngern;
    private final Trennzeichen trennzeichen;
    private final long benutzerId;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private static final DateTimeFormatter monthFormat = DateTimeFormat.forPattern("MM.yyyy");
    private static final DateTimeFormatter dayFormat = DateTimeFormat.forPattern("dd.MM.yyyy");
    private static final DateTimeFormatter timeFormat = DateTimeFormat.forPattern("HH:mm");

    public Liste(DatenRepository source, List<Long> messstellenNummern, Interval zeitraum, Parameter parameter, long benutzerId, Listenprodukt listenprodukt, boolean mitVorg\u00e4ngern, Trennzeichen trennzeichen, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.source = source;
        this.messstellenNummern = messstellenNummern;
        this.zeitraum = zeitraum;
        this.parameter = parameter;
        this.abflussOderWasserstand = AbflussOderWasserstand.fromParameter(parameter);
        this.listenprodukt = listenprodukt;
        this.mitVorg\u00e4ngern = mitVorg\u00e4ngern;
        this.trennzeichen = trennzeichen;
        this.benutzerId = benutzerId;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
    }

    DatenRepository source() {
        return this.source;
    }

    Interval zeitraum() {
        return this.zeitraum;
    }

    Parameter parameter() {
        return this.parameter;
    }

    @Override
    public String name() {
        return "Exportliste";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        FestgelegterFormatierer formatierer = new FestgelegterFormatierer("-", this.wasserstandBezugsh\u00f6he, this.abflussOderWasserstand, false);
        this.writeTo(printStream, formatierer);
        printStream.flush();
    }

    private void writeTo(PrintStream out, FestgelegterFormatierer formatierer) throws Exception {
        Iterable<Messstelle> messstellen = this.ladeMessstellen(this.messstellenNummern);
        Benutzer benutzer = this.ladeBenutzer(this.benutzerId);
        this.schreibe\u00dcberschriften(out, messstellen, benutzer, this.listenprodukt);
        TreeSet<DateTime> zeiten = new TreeSet<DateTime>();
        HashMap valuesByStation = new HashMap();
        HashMap<Long, Gepr\u00fcfteZeitbereiche> validationsByStation = new HashMap<Long, Gepr\u00fcfteZeitbereiche>();
        for (long messstellenNummer : this.messstellenNummern) {
            List<? extends TimestampedValue> werte = this.werte(messstellenNummer);
            Gepr\u00fcfteZeitbereiche gepr\u00fcfteZeitbereiche = this.ladeGepr\u00fcfteZeitbereiche(messstellenNummer);
            HashMap<DateTime, TimestampedValue> valueMap = new HashMap<DateTime, TimestampedValue>();
            for (TimestampedValue timestampedValue : werte) {
                zeiten.add(timestampedValue.timestamp());
                valueMap.put(timestampedValue.timestamp(), timestampedValue);
            }
            valuesByStation.put(messstellenNummer, valueMap);
            validationsByStation.put(messstellenNummer, gepr\u00fcfteZeitbereiche);
        }
        DateTimeZone zone = DateTimeZone.forOffsetHours(1);
        for (DateTime zeit : zeiten) {
            out.print(Liste.format(zeit.withZone(zone), this.listenprodukt));
            for (long messstellenNummer : this.messstellenNummern) {
                this.trennzeichen.trennzeichen(out);
                Map werte = (Map)valuesByStation.get(messstellenNummer);
                TimestampedValue timestampedValue = (TimestampedValue)werte.get(zeit);
                if (!werte.containsKey(zeit)) {
                    this.trennzeichen.trennzeichen(out);
                    continue;
                }
                if (timestampedValue.istL\u00fccke()) {
                    out.print(darstellungL\u00fccke);
                } else {
                    out.print(formatierer.nurSignifikanteStellenVonTimeStampedValue(timestampedValue));
                }
                this.trennzeichen.trennzeichen(out);
                out.print(Liste.jaNein(this.istGepr\u00fcft(this.listenprodukt, (Gepr\u00fcfteZeitbereiche)validationsByStation.get(messstellenNummer), zeit)));
            }
            out.println();
        }
    }

    private static String jaNein(boolean bedingung) {
        if (bedingung) {
            return "ja";
        }
        return "nein";
    }

    private boolean istGepr\u00fcft(Listenprodukt listenprodukt, Gepr\u00fcfteZeitbereiche gepr\u00fcfteZeitbereiche, DateTime zeit) {
        if (listenprodukt == Listenprodukt.monatsmaxima) {
            return gepr\u00fcfteZeitbereiche.enthalten(new YearMonth(zeit).interval());
        }
        return gepr\u00fcfteZeitbereiche.enthalten(zeit);
    }

    Gepr\u00fcfteZeitbereiche ladeGepr\u00fcfteZeitbereiche(long messstellenNummer) throws Exception {
        if (List.of(Listenprodukt.unbearbeitetHauptsystem, Listenprodukt.unbearbeitetHauptsystem).contains((Object)this.listenprodukt)) {
            return new Gepr\u00fcfteZeitbereiche();
        }
        return this.source.gepr\u00fcfteZeitbereiche(messstellenNummer, this.parameter, this.zeitraum);
    }

    List<? extends TimestampedValue> werte(long messstellenNummer) throws Exception {
        NHNTransformationOfTimestampedValues transformation = NHNTransformationOfTimestampedValues.buildNHNTransform(messstellenNummer, this.source, this.wasserstandBezugsh\u00f6he);
        return new DatenRepositoryMitVerkettung(this.source).concatenatedValues(messstellenNummer, this.parameter, this.mitVorg\u00e4ngern, this.listenprodukt, this.zeitraum, Ausfalljahre.keine, transformation);
    }

    private Iterable<Messstelle> ladeMessstellen(Iterable<Long> messstellenNummern) throws Exception {
        ArrayList<Messstelle> messstellen = new ArrayList<Messstelle>();
        for (long messstellenNummer : messstellenNummern) {
            messstellen.add(this.source.messstelle(messstellenNummer));
        }
        return messstellen;
    }

    private Benutzer ladeBenutzer(long benutzerId) throws Exception {
        return this.source.benutzer(benutzerId);
    }

    String resolution(Listenprodukt product) {
        return product.description();
    }

    private void schreibe\u00dcberschriften(PrintStream out, Iterable<Messstelle> messstellen, Benutzer benutzer, Listenprodukt product) {
        this.writeProduktname(out, product);
        new MetaInformationen(benutzer, messstellen, this.trennzeichen).writeTo(out);
        this.writeSpaltenbeschriftungen(out, this.parameter, product);
    }

    private void writeSpaltenbeschriftungen(PrintStream out, Parameter parameter, Listenprodukt product) {
        out.print(Liste.SpaltenbeschriftungF\u00fcrZeit(product));
        this.trennzeichen.trennzeichen(out);
        out.print(parameter.symbol());
        this.trennzeichen.trennzeichen(out);
        out.print("Gepr\u00fcft (nein=ungepr\u00fcfte Rohdaten)");
        out.println();
    }

    private void writeProduktname(PrintStream out, Listenprodukt product) {
        out.print(this.resolution(product));
        this.trennzeichen.trennzeichen(out);
        out.print("Zeitbezug MEZ");
        this.trennzeichen.trennzeichen(out);
        out.print(this.parameter.nameSingular() + " in " + this.abflussOderWasserstand.einheitLang(this.wasserstandBezugsh\u00f6he));
        out.println();
    }

    public static String format(DateTime timestamp, Listenprodukt product) {
        if (product == Listenprodukt.monatsmittel) {
            return monthFormat.print(timestamp);
        }
        if (product == Listenprodukt.tagesmittel || product == Listenprodukt.tagesmittelRedundanz) {
            return dayFormat.print(timestamp);
        }
        return dayFormat.print(timestamp) + " " + timeFormat.print(timestamp);
    }

    public static String SpaltenbeschriftungF\u00fcrZeit(Listenprodukt product) {
        if (product == Listenprodukt.monatsmittel) {
            return "Monat";
        }
        if (product == Listenprodukt.tagesmittel || product == Listenprodukt.tagesmittelRedundanz) {
            return "Datum";
        }
        return "Datum Uhrzeit";
    }
}

