/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Kurveng\u00fcltigkeit;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.MetaInformationen;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;

public class Kurveng\u00fcltigkeiten
implements OutputView {
    private final Model model;
    private Trennzeichen trennzeichen;

    public Kurveng\u00fcltigkeiten(Model model, Trennzeichen trennzeichen) {
        this.model = model;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Kurveng\u00fcltigkeiten";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private void writeTo(PrintStream out) {
        this.schreibeAllgemeine\u00dcberschriften(out, this.model.messstelle(), this.model.benutzer());
        this.schreibeSpalten\u00fcberschriften(out);
        for (Kurveng\u00fcltigkeit kurveng\u00fcltigkeit : this.model.kurveng\u00fcltigkeiten()) {
            this.schreibeKurveng\u00fcltigkeitZeile(out, kurveng\u00fcltigkeit);
        }
    }

    private void schreibeAllgemeine\u00dcberschriften(PrintStream out, Messstelle messstelle, Benutzer benutzer) {
        out.print("G\u00fcltigkeiten");
        this.trennzeichen(out);
        out.println("Zeitbezug MEZ");
        new MetaInformationen(benutzer, messstelle, this.trennzeichen).writeTo(out);
    }

    private void schreibeSpalten\u00fcberschriften(PrintStream out) {
        out.print("Von");
        this.trennzeichen(out);
        out.print("Bis");
        this.trennzeichen(out);
        out.print("Kurve");
        this.trennzeichen(out);
        out.print("\u00dcbergang");
        out.println();
    }

    private void schreibeKurveng\u00fcltigkeitZeile(PrintStream out, Kurveng\u00fcltigkeit kurveng\u00fcltigkeit) {
        out.print(Format.formatFullDayAndTime(kurveng\u00fcltigkeit.von()));
        this.trennzeichen(out);
        out.print(kurveng\u00fcltigkeit.bis().map(Format::formatFullDayAndTime).orElse(""));
        this.trennzeichen(out);
        out.print(kurveng\u00fcltigkeit.istAusfall() ? "Ausfall" : kurveng\u00fcltigkeit.kurvenname());
        this.trennzeichen(out);
        out.print(kurveng\u00fcltigkeit.ist\u00dcbergang() ? kurveng\u00fcltigkeit.\u00fcbergangZu() : "");
        out.println();
    }

    private void trennzeichen(PrintStream out) {
        out.print(this.trennzeichen.zeichen());
    }

    public static class Model {
        private final Messstelle messstelle;
        private final Benutzer benutzer;
        private final List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeiten;

        public Model(Messstelle messstelle, Benutzer benutzer, List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeiten) {
            this.messstelle = messstelle;
            this.benutzer = benutzer;
            this.kurveng\u00fcltigkeiten = kurveng\u00fcltigkeiten;
        }

        public static Model lade(DatenRepository source, long messstellenNummer, long benutzerId) throws Exception {
            Messstelle messstelle = source.messstelle(messstellenNummer);
            Benutzer benutzer = source.benutzer(benutzerId);
            List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeiten = source.kurveng\u00fcltigkeitenF\u00fcrMessstelle(messstellenNummer);
            return new Model(messstelle, benutzer, kurveng\u00fcltigkeiten);
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        public Benutzer benutzer() {
            return this.benutzer;
        }

        public List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeiten() {
            return this.kurveng\u00fcltigkeiten;
        }
    }
}

