/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.JahrbuchseitenConfiguration;
import luwa.marlin.ship_library.model.J\u00e4hrlichkeit;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.value.WQPaar;
import luwa.marlin.ship_library.model.year.J\u00e4hrlichkeiten;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.web.OutputView;
import org.joda.time.Interval;

public class HochwasserJ\u00e4hrlichkeiten
implements OutputView {
    private final DatenRepository source;
    private final Configuration configuration;
    private static final DecimalFormat annualityFormat = Format.decimalFormatFor("#.###");

    public HochwasserJ\u00e4hrlichkeiten(DatenRepository source, Configuration configuration) {
        this.source = source;
        this.configuration = configuration;
    }

    @Override
    public String name() {
        return "Hochwasser-J\u00e4hrlichkeiten";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private void writeTo(PrintStream out) throws Exception {
        out.println("Messstellen-Nr.;Standort;Gew\u00e4sser;Stadt-/Landkreis;Betreiber;Messnetz;Zeit;Abfluss Q in m\u00b3/s;Wasserstand W in cm;J\u00e4hrlichkeit");
        for (List<String> row : this.createTableData()) {
            out.println(Format.join(row, ";"));
        }
    }

    private List<List<String>> createTableData() throws Exception {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (long messstellenNummer : this.configuration.messstellenNummern()) {
            Messstelle messstelle = this.source.messstelle(messstellenNummer);
            J\u00e4hrlichkeiten j\u00e4hrlichkeiten = this.source.j\u00e4hrlichkeiten(messstellenNummer);
            WQPaar hw_hq = this.source.HW_HQ(messstellenNummer, this.configuration.hwInterval());
            data.add(this.rowFor(messstelle, j\u00e4hrlichkeiten, hw_hq));
            Jahrbuchseite qSeite = new Jahrbuchseite(new JahrbuchseitenConfiguration(messstellenNummer, Optional.empty(), this.configuration.startYear(), this.configuration.endYear(), AbflussOderWasserstand.Q, this.configuration.endYear()), this.source);
            for (Scheitelwert hq : qSeite.extremwerte().globalExtremesHW(this.configuration.additionalTopN())) {
                Scheitelwert hw = qSeite.scheitelAt(hq.timestamp()).get();
                List<String> row = this.rowFor(messstelle, j\u00e4hrlichkeiten, new WQPaar(hq, hw));
                data.add(row);
            }
        }
        return data;
    }

    private List<String> rowFor(Messstelle messstelle, J\u00e4hrlichkeiten j\u00e4hrlichkeiten, WQPaar hw_hq) {
        TimestampedValue hw = hw_hq.W();
        TimestampedValue hq = hw_hq.Q();
        ArrayList<String> row = new ArrayList<String>();
        row.add(String.valueOf(messstelle.nummer()));
        row.add(messstelle.standort());
        row.add(messstelle.gew\u00e4sser());
        row.add(messstelle.landkreis());
        row.add(messstelle.betreiber());
        row.add(messstelle.messnetz());
        row.add(Format.formatDay(hw_hq.timestamp()));
        row.add(HochwasserJ\u00e4hrlichkeiten.formatValue(hq, Parameter.q));
        row.add(HochwasserJ\u00e4hrlichkeiten.formatValue(hw, Parameter.w));
        if (null != j\u00e4hrlichkeiten && null != hq && !hq.istL\u00fccke()) {
            J\u00e4hrlichkeit j\u00e4hrlichkeit = j\u00e4hrlichkeiten.j\u00e4hrlichkeitF\u00fcr(hq);
            row.add(j\u00e4hrlichkeit.text());
            row.add(annualityFormat.format(j\u00e4hrlichkeit.j\u00e4hrlich()));
        } else {
            row.add("");
            row.add("");
        }
        return row;
    }

    private static String formatValue(TimestampedValue value, Parameter parameter) {
        if (null == value || value.istL\u00fccke()) {
            return "";
        }
        return parameter.formatValue(value);
    }

    public static class Configuration {
        private final List<Long> messstellenNummern;
        private final int startYear;
        private final int endYear;
        private final Interval hwInterval;
        private final int additionalTopN;

        public Configuration(List<Long> messstellenNummern, int startYear, int endYear, Interval hwInterval, int additionalTopN) {
            this.messstellenNummern = messstellenNummern;
            this.startYear = startYear;
            this.endYear = endYear;
            this.hwInterval = hwInterval;
            this.additionalTopN = additionalTopN;
        }

        public List<Long> messstellenNummern() {
            return this.messstellenNummern;
        }

        public int startYear() {
            return this.startYear;
        }

        public int endYear() {
            return this.endYear;
        }

        public Interval hwInterval() {
            return this.hwInterval;
        }

        public int additionalTopN() {
            return this.additionalTopN;
        }
    }
}

