/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import luwa.marlin.ship_library.model.HandUndSystemWerte;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.Listenprodukt;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HandUndSystemwerte
implements OutputView {
    private static final String darstellungL\u00fccke = "-999";
    private final DatenRepository source;
    private final Iterable<Long> messstellenNummern;
    private final Interval zeitraum;
    private final Parameter parameter;
    private final Listenprodukt listenprodukt;
    private final Trennzeichen trennzeichen;
    private final long benutzerId;
    private static final DateTimeFormatter dayFormat = DateTimeFormat.forPattern("dd.MM.yyyy");
    private static final DateTimeFormatter timeFormat = DateTimeFormat.forPattern("HH:mm");

    public HandUndSystemwerte(DatenRepository source, List<Long> messstellenNummern, Interval zeitraum, Parameter parameter, long benutzerId, Trennzeichen trennzeichen) {
        this.source = source;
        this.messstellenNummern = messstellenNummern;
        this.zeitraum = zeitraum;
        this.parameter = parameter;
        this.benutzerId = benutzerId;
        this.listenprodukt = Listenprodukt.handUndSystemwerte;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Exportliste";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private void printHandAndSystemValues(PrintStream out, Parameter parameter, HandUndSystemWerte values, DateTime timestamp) {
        this.trennzeichen(out);
        if (!values.hasValuesFor(timestamp)) {
            this.trennzeichen(out);
            return;
        }
        HandUndSystemWerte.ValuePair valuePair = values.valuesFor(timestamp);
        this.printValue(out, timestamp, valuePair.handValue());
        this.trennzeichen(out);
        this.printValue(out, timestamp, valuePair.systemValue());
    }

    private void printValue(PrintStream out, DateTime timestamp, Double value) {
        if (value == null) {
            out.print(darstellungL\u00fccke);
            return;
        }
        out.print(this.parameter.formatValue(new TimestampedValue(timestamp, value)));
    }

    private void writeTo(PrintStream out) throws Exception {
        Iterable<Messstelle> messstellen = this.ladeMessstellen(this.messstellenNummern);
        this.schreibe\u00dcberschriften(out, messstellen, this.parameter, this.listenprodukt);
        TreeSet<DateTime> timestamps = new TreeSet<DateTime>();
        HashMap<Long, HandUndSystemWerte> valuesByStation = new HashMap<Long, HandUndSystemWerte>();
        HashMap<Long, HandUndSystemWerte> redundantValuesByStation = new HashMap<Long, HandUndSystemWerte>();
        for (long messstellenNummer : this.messstellenNummern) {
            HandUndSystemWerte values = this.valuesFor(messstellenNummer);
            timestamps.addAll(values.values().keySet());
            valuesByStation.put(messstellenNummer, values);
            HandUndSystemWerte redundantValues = this.redundantValuesFor(messstellenNummer);
            timestamps.addAll(redundantValues.values().keySet());
            redundantValuesByStation.put(messstellenNummer, redundantValues);
        }
        DateTimeZone zone = DateTimeZone.forOffsetHours(1);
        for (DateTime timestamp : timestamps) {
            out.print(HandUndSystemwerte.format(timestamp.withZone(zone)));
            for (long messstellenNummer : this.messstellenNummern) {
                this.printHandAndSystemValues(out, this.parameter, (HandUndSystemWerte)valuesByStation.get(messstellenNummer), timestamp);
                this.printHandAndSystemValues(out, this.parameter, (HandUndSystemWerte)redundantValuesByStation.get(messstellenNummer), timestamp);
            }
            out.println();
        }
    }

    private HandUndSystemWerte valuesFor(long messstellenNummer) throws Exception {
        return this.source.handUndSystemWerte(messstellenNummer, this.parameter, this.zeitraum);
    }

    private HandUndSystemWerte redundantValuesFor(long messstellenNummer) throws Exception {
        return this.source.handUndSystemWerte_redundanz(messstellenNummer, this.parameter, this.zeitraum);
    }

    private Iterable<Messstelle> ladeMessstellen(Iterable<Long> messstellenNummern) throws Exception {
        ArrayList<Messstelle> messstellen = new ArrayList<Messstelle>();
        for (long messstellenNummer : messstellenNummern) {
            messstellen.add(this.source.messstelle(messstellenNummer));
        }
        return messstellen;
    }

    private String resolution(Listenprodukt product) {
        return product.description();
    }

    private void schreibe\u00dcberschriften(PrintStream out, Iterable<Messstelle> messstellen, Parameter parameter, Listenprodukt listenprodukt) {
        for (Messstelle messstelle : messstellen) {
            out.print(messstelle.bezeichnung());
            this.trennzeichen(out);
            out.print(parameter.nameSingular() + " in " + parameter.unit());
            this.trennzeichen(out);
            out.print(this.resolution(listenprodukt));
            this.trennzeichen(out);
            out.print("Zeitbezug MEZ");
            this.trennzeichen(out);
            out.print("Stand: ");
            out.print(Format.formatDay(new DateTime()));
            out.println();
            out.print("Zeit");
            this.trennzeichen(out);
            out.print("Handwert");
            this.trennzeichen(out);
            out.print("Systemwert");
            this.trennzeichen(out);
            out.print("Handwert Redundanz");
            this.trennzeichen(out);
            out.print("Systemwert Redundanz");
            out.println();
        }
    }

    private void trennzeichen(PrintStream out) {
        out.print(this.trennzeichen.zeichen());
    }

    public static String format(DateTime timestamp) {
        return dayFormat.print(timestamp) + " " + timeFormat.print(timestamp);
    }
}

