/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import luwa.marlin.ship_library.model.AnzahlAbflussmessungen;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.web.OutputView;

public class AbflussmessungenStatistik
implements OutputView {
    private final DatenRepository datenRepository;
    private final List<Long> messstellenNummern;
    private final int jahrVon;
    private final int jahrBis;
    private final Trennzeichen trennzeichen;

    public AbflussmessungenStatistik(DatenRepository datenRepository, List<Long> messstellenNummern, int jahrVon, int jahrBis, Trennzeichen trennzeichen) {
        this.datenRepository = datenRepository;
        this.messstellenNummern = messstellenNummern;
        this.jahrVon = jahrVon;
        this.jahrBis = jahrBis;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Abflussmessungen-Statistik";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        Map<Integer, AnzahlAbflussmessungen> statistiken = this.abflussmessungenStatistiken();
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.schreibeNach(printStream, statistiken);
        printStream.flush();
    }

    private Map<Integer, AnzahlAbflussmessungen> abflussmessungenStatistiken() {
        HashMap<Integer, AnzahlAbflussmessungen> statistiken = new HashMap<Integer, AnzahlAbflussmessungen>();
        for (int jahr = this.jahrVon; jahr <= this.jahrBis; ++jahr) {
            AnzahlAbflussmessungen anzahlAbflussmessungen = this.datenRepository.abflussmessungenStatistik(this.messstellenNummern, jahr);
            statistiken.put(jahr, anzahlAbflussmessungen);
        }
        return statistiken;
    }

    private void schreibeNach(PrintStream out, Map<Integer, AnzahlAbflussmessungen> statistiken) {
        out.println("\u00dcbersicht Anzahl der Messungen");
        this.schreibe\u00dcberschriften(out);
        for (long messstellenNummer : this.messstellenNummern) {
            Optional<AnzahlAbflussmessungen.Eintrag> optionalMessstelle = this.ersterEintrag(statistiken, messstellenNummer);
            if (optionalMessstelle.isEmpty()) continue;
            AnzahlAbflussmessungen.Eintrag messstelle = optionalMessstelle.get();
            out.print(messstelle.messstellenNummer());
            this.trennzeichen.trennzeichen(out);
            out.print(messstelle.standort());
            this.trennzeichen.trennzeichen(out);
            out.print(messstelle.gew\u00e4sser());
            this.trennzeichen.trennzeichen(out);
            out.print(messstelle.messnetz());
            this.trennzeichen.trennzeichen(out);
            out.print(messstelle.eigent\u00fcmer());
            this.trennzeichen.trennzeichen(out);
            out.print(messstelle.betreiber());
            this.trennzeichen.trennzeichen(out);
            out.print(messstelle.pegeltyp());
            this.trennzeichen.trennzeichen(out);
            long gesamt = 0L;
            for (int jahr = this.jahrVon; jahr <= this.jahrBis; ++jahr) {
                AnzahlAbflussmessungen statistik = statistiken.get(jahr);
                Optional<AnzahlAbflussmessungen.Eintrag> eintrag = statistik.f\u00fcr(messstellenNummer);
                Long anzahlMessungen = eintrag.map(AnzahlAbflussmessungen.Eintrag::anzahlMessungen).orElse(0L);
                gesamt += anzahlMessungen.longValue();
                out.print(anzahlMessungen);
                this.trennzeichen.trennzeichen(out);
            }
            out.println(gesamt);
        }
    }

    private Optional<AnzahlAbflussmessungen.Eintrag> ersterEintrag(Map<Integer, AnzahlAbflussmessungen> statistiken, long messstellenNummer) {
        for (int jahr = this.jahrVon; jahr <= this.jahrBis; ++jahr) {
            Optional<AnzahlAbflussmessungen.Eintrag> eintrag;
            if (!statistiken.containsKey(jahr) || !(eintrag = statistiken.get(jahr).f\u00fcr(messstellenNummer)).isPresent()) continue;
            return eintrag;
        }
        return Optional.empty();
    }

    private void schreibe\u00dcberschriften(PrintStream out) {
        out.print("Messstellen-Nr.");
        this.trennzeichen.trennzeichen(out);
        out.print("Standort");
        this.trennzeichen.trennzeichen(out);
        out.print("Gew\u00e4sser");
        this.trennzeichen.trennzeichen(out);
        out.print("Messnetz");
        this.trennzeichen.trennzeichen(out);
        out.print("Eigent\u00fcmer");
        this.trennzeichen.trennzeichen(out);
        out.print("Betreiber");
        this.trennzeichen.trennzeichen(out);
        out.print("Pegeltyp");
        this.trennzeichen.trennzeichen(out);
        for (int jahr = this.jahrVon; jahr <= this.jahrBis; ++jahr) {
            out.print(jahr);
            this.trennzeichen.trennzeichen(out);
        }
        out.printf("Gesamtzeitraum %d-%d", this.jahrVon, this.jahrBis);
        out.println();
    }
}

