/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.text;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.measure.MetricPrefix;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Abflussmessung;
import luwa.marlin.ship_library.model.AbflussmessungErgebnisse;
import luwa.marlin.ship_library.model.Abflussnullpunkt;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.text.helpers.MetaInformationen;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import tech.units.indriya.unit.Units;

public class Abflussmessungen
implements OutputView {
    private final Model model;
    private final Trennzeichen trennzeichen;
    private static final DateTimeZone zeitzone = DateTimeZone.forOffsetHours(1);
    private static final DecimalFormat W_m_format_CM_Pegellatte = Format.decimalFormatFor("#.#");
    private static final DecimalFormat W_m_format_M_NHN = Format.decimalFormatFor("#.###");
    private static final DecimalFormat A_format = Format.decimalFormatFor("#.###");
    private static final DecimalFormat v_m_format = Format.decimalFormatFor("#.###");
    private static final DecimalFormat b_format = Format.decimalFormatFor("#.###");
    private static final DecimalFormat defaultFormat = Format.decimalFormatFor("#.###");
    private static final DateTimeFormatter formatTag = DateTimeFormat.forPattern("dd.MM.yyyy");
    private static final DateTimeFormatter formatUhrzeit = DateTimeFormat.forPattern("HH:mm");

    public Abflussmessungen(Model model, Trennzeichen trennzeichen) {
        this.model = model;
        this.trennzeichen = trennzeichen;
    }

    @Override
    public String name() {
        return "Abflussmessungen";
    }

    @Override
    public String contentType() {
        return "text/plain";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, this.charset());
        this.writeTo(printStream);
        printStream.flush();
    }

    private void writeTo(PrintStream out) {
        this.schreibe\u00dcberschriften(out, this.model.messstelle(), this.model.wasserstandBezugsh\u00f6he());
        for (Abflussmessung abflussmessung : this.model.abflussmessungen()) {
            Optional<Pegelnullpunkt> pegelnullpunkt = this.model.pegelnullpunktG\u00fcltigAm(abflussmessung.messzeitpunkt());
            Optional<Abflussnullpunkt> abflussnullpunkt = this.model.abflussnullpunktG\u00fcltigAm(abflussmessung.messzeitpunkt());
            this.schreibeAbflussmessungsZeile(out, abflussmessung, pegelnullpunkt, abflussnullpunkt, this.model.wasserstandBezugsh\u00f6he(), this.model.transformation());
        }
    }

    private void schreibe\u00dcberschriften(PrintStream out, Messstelle messstelle, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.schreibeAllgemeine\u00dcberschriften(out, wasserstandBezugsh\u00f6he);
        this.schreibeSpalten\u00fcberschriften(out, wasserstandBezugsh\u00f6he);
    }

    private void schreibeAllgemeine\u00dcberschriften(PrintStream out, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        out.print(this.name());
        this.trennzeichen(out);
        out.println("Zeitbezug MEZ");
        new MetaInformationen(this.model.benutzer(), this.model.messstelle(), this.trennzeichen).writeTo(out);
    }

    private void schreibeSpalten\u00fcberschriften(PrintStream out, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        out.print("Datum/Uhrzeit");
        this.trennzeichen(out);
        out.print(Abflussmessungen.spalten\u00fcberschriftF\u00fcrParameter(Parameter.w, wasserstandBezugsh\u00f6he));
        this.trennzeichen(out);
        out.print(Abflussmessungen.spalten\u00fcberschriftF\u00fcrParameter(Parameter.q, wasserstandBezugsh\u00f6he));
        this.trennzeichen(out);
        out.print("A in m\u00b2");
        this.trennzeichen(out);
        out.print("v_m in m/s");
        this.trennzeichen(out);
        out.print("b in m");
        this.trennzeichen(out);
        out.print("PNP");
        this.trennzeichen(out);
        out.print("ANP entspricht W in cm");
        this.trennzeichen(out);
        out.print("Pr\u00fcfstatus");
        this.trennzeichen(out);
        out.print("Qualit\u00e4t");
        this.trennzeichen(out);
        out.print("Messart");
        this.trennzeichen(out);
        out.print("Messquerschnitt");
        this.trennzeichen(out);
        out.print("Bemerkung");
        this.trennzeichen(out);
        out.print("Besondere Sohl- und Ufereigenschaften");
        this.trennzeichen(out);
        out.print("W_min in cm");
        this.trennzeichen(out);
        out.print("W_max in cm");
        this.trennzeichen(out);
        out.print("h_m in cm");
        this.trennzeichen(out);
        out.print("vo_max in m/s");
        this.trennzeichen(out);
        out.print("vo_m in m/s");
        this.trennzeichen(out);
        out.print("v_m/vo_m");
        this.trennzeichen(out);
        out.print("q in l/s km\u00b2");
        this.trennzeichen(out);
        out.print("U in m");
        this.trennzeichen(out);
        out.print("A/U in m");
        this.trennzeichen(out);
        out.print("h_max in cm");
        this.trennzeichen(out);
        out.print("P in m^(8/3)");
        out.println();
    }

    private void schreibeAbflussmessungsZeile(PrintStream out, Abflussmessung abflussmessung, Optional<Pegelnullpunkt> pegelnullpunkt, Optional<Abflussnullpunkt> abflussnullpunkt, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he, NHNTransformationOfTimestampedValues transformation) {
        out.print(Abflussmessungen.format(TimestampedValue.zonedDateTimeToJodaDateTime(abflussmessung.messzeitpunkt()).withZone(zeitzone)));
        this.trennzeichen(out);
        try {
            double wasserstandInCMbezogenAufPegellatte = abflussmessung.mittlererWasserstand().to(MetricPrefix.CENTI(Units.METRE)).getValue().doubleValue();
            if (wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
                out.print(W_m_format_M_NHN.format(transformation.forValue(new TimestampedValue(abflussmessung.messzeitpunkt(), (Double)wasserstandInCMbezogenAufPegellatte)).wert()));
            } else {
                out.print(W_m_format_CM_Pegellatte.format(wasserstandInCMbezogenAufPegellatte));
            }
        }
        catch (Exception e2) {
            out.print("-");
        }
        this.trennzeichen(out);
        out.print(Parameter.q.formatValue(new TimestampedValue(abflussmessung.messzeitpunkt(), (Double)abflussmessung.durchfluss().to(luwa.marlin.ship_library.model.units.Units.CUBIC_METRE_PER_SECOND).getValue().doubleValue())));
        this.trennzeichen(out);
        out.print(A_format.format(abflussmessung.durchflussquerschnitt().to(Units.SQUARE_METRE).getValue().doubleValue()));
        this.trennzeichen(out);
        out.print(v_m_format.format(abflussmessung.mittlereFlie\u00dfgeschwindigkeit().to(Units.METRE_PER_SECOND).getValue().doubleValue()));
        this.trennzeichen(out);
        out.print(b_format.format(abflussmessung.wasserspiegelbreite().to(Units.METRE).getValue().doubleValue()));
        this.trennzeichen(out);
        out.print(pegelnullpunkt.map(Pegelnullpunkt::darstellung).orElse(""));
        this.trennzeichen(out);
        out.print(abflussnullpunkt.map(anp -> Parameter.w.formatValue(new TimestampedValue(anp.g\u00fcltigVon(), (Double)anp.abflussnullpunktEntwprichtW().to(MetricPrefix.CENTI(Units.METRE)).getValue().doubleValue()))).orElse(""));
        this.trennzeichen(out);
        out.print(abflussmessung.pr\u00fcfstatus());
        this.trennzeichen(out);
        out.print(abflussmessung.qualit\u00e4t());
        this.trennzeichen(out);
        out.print(abflussmessung.messart().beschreibung());
        this.trennzeichen(out);
        out.print(abflussmessung.messort());
        this.trennzeichen(out);
        out.print(Abflussmessungen.escapeForCSV(abflussmessung.bemerkung()));
        this.trennzeichen(out);
        out.print(Abflussmessungen.escapeForCSV(abflussmessung.besondereUferSohleigenschaften()));
        if (abflussmessung.ergebnisse().isPresent()) {
            AbflussmessungErgebnisse ergebnisse = abflussmessung.ergebnisse().get();
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.minimalerWasserstand().to(MetricPrefix.CENTI(Units.METRE)).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.maximalerWasserstand().to(MetricPrefix.CENTI(Units.METRE)).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(ergebnisse.mittlereGerinnetiefe().map(h_m -> defaultFormat.format(h_m.to(MetricPrefix.CENTI(Units.METRE)).getValue().doubleValue())).orElse(""));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.maximaleOberfl\u00e4chengeschwindigkeit().to(Units.METRE_PER_SECOND).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.mittlereOberfl\u00e4chengeschwindigkeit().to(Units.METRE_PER_SECOND).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.verh\u00e4ltnisMittlereFlie\u00dfgeschwindigkeitZuMittlereOberfl\u00e4chengeschwindigkeit()));
            this.trennzeichen(out);
            out.print(ergebnisse.abflussspende().map(q2 -> defaultFormat.format(q2.to(luwa.marlin.ship_library.model.units.Units.LITRE_PER_SECOND_TIMES_SQUARE_KILOMETRE).getValue().doubleValue())).orElse(""));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.benetzterUmfang().to(Units.METRE).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.hydraulischerRadius().to(Units.METRE).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.maximaleTiefe().to(MetricPrefix.CENTI(Units.METRE)).getValue().doubleValue()));
            this.trennzeichen(out);
            out.print(defaultFormat.format(ergebnisse.profilwertNachManningStrickler().to(luwa.marlin.ship_library.model.units.Units.METRE_POW_8_DIV_3).getValue().doubleValue()));
        }
        out.println();
    }

    private static String spalten\u00fcberschriftF\u00fcrParameter(Parameter parameter, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        return String.format("%s in %s", parameter.symbol(), AbflussOderWasserstand.fromParameter(parameter).einheitLang(wasserstandBezugsh\u00f6he));
    }

    private void trennzeichen(PrintStream out) {
        out.print(this.trennzeichen.zeichen());
    }

    private static String escapeForCSV(String s2) {
        return s2.replace("\\s", " ").replace("\n", " ").replace("\r", " ").replace("\t", " ").replace(";", "|");
    }

    private static String format(DateTime zeitpunkt) {
        return formatTag.print(zeitpunkt) + " " + formatUhrzeit.print(zeitpunkt);
    }

    public static class Model {
        private final Messstelle messstelle;
        private final Benutzer benutzer;
        private final List<Abflussmessung> abflussmessungen;
        private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
        private final NHNTransformationOfTimestampedValues transformation;
        private final List<Pegelnullpunkt> pegelnullpunkte;
        private final List<Abflussnullpunkt> abflussnullpunkte;

        public WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he() {
            return this.wasserstandBezugsh\u00f6he;
        }

        public NHNTransformationOfTimestampedValues transformation() {
            return this.transformation;
        }

        private Model(Messstelle messstelle, Benutzer benutzer, List<Abflussmessung> abflussmessungen, List<Pegelnullpunkt> pegelnullpunkte, List<Abflussnullpunkt> abflussnullpunkte, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he, NHNTransformationOfTimestampedValues transformation) {
            this.messstelle = messstelle;
            this.benutzer = benutzer;
            this.abflussmessungen = new ArrayList<Abflussmessung>(abflussmessungen);
            this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
            this.transformation = transformation;
            this.abflussmessungen.sort(Comparator.comparing(Abflussmessung::messzeitpunkt));
            this.pegelnullpunkte = pegelnullpunkte;
            this.abflussnullpunkte = abflussnullpunkte;
        }

        public static Model lade(DatenRepository source, long messstellenNummer, long benutzerId, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) throws Exception {
            Messstelle messstelle = source.messstelle(messstellenNummer);
            Benutzer benutzer = source.benutzer(benutzerId);
            List<Abflussmessung> abflussmessungen = source.abflussmessungen(messstellenNummer);
            List<Pegelnullpunkt> pegelnullpunkte = source.pegelnullpunkte(messstellenNummer);
            List<Abflussnullpunkt> abflussnullpunkte = source.abflussnullpunkte(messstellenNummer);
            NHNTransformationOfTimestampedValues transformation = NHNTransformationOfTimestampedValues.buildNHNTransform(messstellenNummer, source, wasserstandBezugsh\u00f6he);
            return new Model(messstelle, benutzer, abflussmessungen, pegelnullpunkte, abflussnullpunkte, wasserstandBezugsh\u00f6he, transformation);
        }

        public Benutzer benutzer() {
            return this.benutzer;
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        List<Abflussmessung> abflussmessungen() {
            return this.abflussmessungen;
        }

        Optional<Pegelnullpunkt> pegelnullpunktG\u00fcltigAm(ZonedDateTime zeitpunkt) {
            return Model.nullpunktG\u00fcltigAm(zeitpunkt, this.pegelnullpunkte, Pegelnullpunkt::g\u00fcltigVon);
        }

        Optional<Abflussnullpunkt> abflussnullpunktG\u00fcltigAm(ZonedDateTime zeitpunkt) {
            return Model.nullpunktG\u00fcltigAm(zeitpunkt, this.abflussnullpunkte, Abflussnullpunkt::g\u00fcltigVon);
        }

        private static <NP> Optional<NP> nullpunktG\u00fcltigAm(ZonedDateTime zeitpunkt, List<NP> nullpunkte, Function<NP, ZonedDateTime> g\u00fcltigVon) {
            for (int i2 = 0; i2 < nullpunkte.size(); ++i2) {
                NP nullpunkt = nullpunkte.get(i2);
                if (g\u00fcltigVon.apply(nullpunkt).isAfter(zeitpunkt) || i2 < nullpunkte.size() - 1 && !g\u00fcltigVon.apply(nullpunkte.get(i2 + 1)).isAfter(zeitpunkt)) continue;
                return Optional.of(nullpunkt);
            }
            return Optional.empty();
        }
    }
}

