/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf.helpers;

import java.io.IOException;
import java.util.List;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.pdf.helpers.Column;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;

public final class Rendering {
    private Rendering() {
    }

    public static void textAt(PDPageContentStream content, float x2, float y2, String text) throws IOException {
        content.beginText();
        content.newLineAtOffset(x2, y2);
        content.showText(Format.nullSafeString(text));
        content.endText();
    }

    public static void textAt(PDPageContentStream content, float x2, float y2, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        Rendering.textAt(content, x2, y2, text);
    }

    public static void multilineTextAt(PDPageContentStream content, float x2, float y2, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        String[] lines = text.split("\n");
        Column column = new Column(font, fontSize);
        for (String line : lines) {
            column.add(line);
        }
        column.draw(content, x2, y2);
    }

    public static void textRightAlignedAt(PDPageContentStream content, int x2, int y2, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        content.beginText();
        content.newLineAtOffset(x2, y2);
        new RightAligned(new Text(text, font, fontSize)).render(content);
        content.endText();
    }

    public static void textCenteredAt(PDPageContentStream content, int x2, int y2, String text, PDFont font, float fontSize) throws IOException {
        content.setFont(font, fontSize);
        content.beginText();
        content.newLineAtOffset(x2, y2);
        Rendering.drawStringCentered(content, text, font, fontSize);
        content.endText();
    }

    public static void drawStringCentered(PDPageContentStream content, String text, PDFont font, float fontSize) throws IOException {
        float textWidth = font.getStringWidth(Format.nullSafeString(text)) / 1000.0f * fontSize;
        float halfTextWidth = textWidth / 2.0f;
        content.newLineAtOffset(-halfTextWidth, 0.0f);
        content.showText(Format.nullSafeString(text));
        content.newLineAtOffset(halfTextWidth, 0.0f);
    }

    public static void drawRectangle(PDPageContentStream content, float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        Rendering.drawLine(content, xStart, yStart, xEnd, yStart);
        Rendering.drawLine(content, xStart, yEnd, xEnd, yEnd);
        Rendering.drawLine(content, xStart, yStart, xStart, yEnd);
        Rendering.drawLine(content, xEnd, yStart, xEnd, yEnd);
    }

    public static void drawLine(PDPageContentStream content, float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        content.moveTo(xStart, yStart);
        content.lineTo(xEnd, yEnd);
        content.stroke();
    }

    public static class RightAligned
    implements TextRenderable {
        private final TextRenderable text;

        public RightAligned(TextRenderable text) {
            this.text = text;
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float textWidth = this.width();
            content.newLineAtOffset(-textWidth, 0.0f);
            this.text.render(content);
            content.newLineAtOffset(textWidth, 0.0f);
        }

        @Override
        public float width() throws IOException {
            return this.text.width();
        }
    }

    public static class Text
    implements TextRenderable {
        private final String text;
        private final PDFont font;
        private final float fontSize;

        public Text(String text, PDFont font, float fontSize) {
            this.text = Format.nullSafeString(text);
            this.font = font;
            this.fontSize = fontSize;
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            content.setFont(this.font, this.fontSize);
            content.showText(this.text);
        }

        @Override
        public float width() throws IOException {
            return this.font.getStringWidth(this.text) / 1000.0f * this.fontSize;
        }
    }

    public static interface TextRenderable {
        public void render(PDPageContentStream var1) throws IOException;

        public float width() throws IOException;
    }

    public static class SubscriptText
    implements TextRenderable {
        private final Text text;

        public SubscriptText(String text, PDFont font, float fontSize) {
            this.text = new Text(text, font, fontSize);
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float yOffset = 2.0f;
            content.newLineAtOffset(0.0f, -2.0f);
            this.text.render(content);
            content.newLineAtOffset(0.0f, 2.0f);
        }

        @Override
        public float width() throws IOException {
            return this.text.width();
        }
    }

    public static class Texts
    implements TextRenderable {
        private final Iterable<TextRenderable> texts;

        public Texts(List<TextRenderable> texts) {
            this.texts = texts;
        }

        @Override
        public void render(PDPageContentStream content) throws IOException {
            float xOffset = 0.0f;
            for (TextRenderable text : this.texts) {
                content.newLineAtOffset(xOffset, 0.0f);
                text.render(content);
                content.newLineAtOffset(-xOffset, 0.0f);
                xOffset += text.width();
            }
        }

        @Override
        public float width() throws IOException {
            float width = 0.0f;
            for (TextRenderable text : this.texts) {
                width += text.width();
            }
            return width;
        }
    }
}

