/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf.helpers;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import luwa.marlin.ship_library.util.Benchmark;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.jfree.chart.JFreeChart;

public final class Chart {
    private Chart() {
    }

    public static void writeAsPDF(OutputStream out, JFreeChart chart) throws Exception {
        float width = PDRectangle.A4.getHeight();
        float height = PDRectangle.A4.getWidth();
        PDDocument document = new PDDocument();
        PDPage page = new PDPage(new PDRectangle(0.0f, 0.0f, width, height));
        document.addPage(page);
        PdfBoxGraphics2D g2 = new PdfBoxGraphics2D(document, width, height);
        Benchmark.benchmark("Zeichnen der Grafik", () -> chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, width, height)));
        g2.dispose();
        Benchmark.benchmark("Schreiben der Grafik als PDF", () -> {
            PDFormXObject xform = g2.getXFormObject();
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            contentStream.drawForm(xform);
            contentStream.close();
            document.save(out);
        });
    }
}

