/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import luwa.marlin.component.Component;
import luwa.marlin.configuration.ConfiguredNetwork;
import luwa.marlin.ship_library.model.SteckbriefTyp;
import luwa.marlin.web.OutputView;

public class Steckbrief
implements OutputView {
    private final long messstellenNummer;
    private final SteckbriefTyp typ;
    private final String authToken;

    public Steckbrief(long messstellenNummer, SteckbriefTyp typ, String authToken) {
        this.messstellenNummer = messstellenNummer;
        this.typ = typ;
        this.authToken = authToken;
    }

    @Override
    public String name() {
        return this.typ.bezeichnung();
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        ConfiguredNetwork stammdatenDienst = ConfiguredNetwork.forService(Component.stammdaten);
        String stammdatenBaseURL = "https://" + stammdatenDienst.host() + ":" + stammdatenDienst.port() + "/pegelstammdaten";
        String requestPath = stammdatenBaseURL + "/" + this.typ.urlPath(this.messstellenNummer);
        try {
            CookieManager cookieManager = new CookieManager();
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> hostname.equals("localhost") || hostname.equals(stammdatenDienst.host()));
            HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).cookieHandler(cookieManager).build();
            HttpRequest cookieRequest = HttpRequest.newBuilder().uri(URI.create(requestPath + "?auth_token=" + this.authToken)).GET().build();
            HttpResponse<String> cookieResponse = httpClient.send(cookieRequest, HttpResponse.BodyHandlers.ofString());
            URI uri = URI.create(requestPath);
            String sessionCookieHeader = cookieResponse.headers().firstValue("set-cookie").orElse("");
            List<HttpCookie> sessionCookie = HttpCookie.parse(sessionCookieHeader);
            for (HttpCookie cookie : sessionCookie) {
                cookieManager.getCookieStore().add(uri, cookie);
            }
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            out.write(response.body());
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Steckbrief-Anfrage nicht beantworten", e2);
        }
    }
}

