/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import luwa.marlin.ship_library.AbflusskurventafelModel;
import luwa.marlin.ship_library.model.Abflusskurve;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.WQWert;
import luwa.marlin.ship_library.util.math.IntegerArithmetic;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.pdf.helpers.Rendering;
import luwa.marlin.ship_library.view.text.Abflusskurvenliste;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class Abflusskurventafel
implements OutputView {
    private static final PDFont font = PDType1Font.HELVETICA;
    private static final PDFont boldFont = PDType1Font.HELVETICA_BOLD;
    private static final PDFont fixedFont = PDType1Font.COURIER;
    private static final int leftBound = 62;
    private final AbflusskurventafelModel model;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;

    public Abflusskurventafel(AbflusskurventafelModel model, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.model = model;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
    }

    @Override
    public String name() {
        return "Abflusskurventafel";
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        try (PDDocument document = new PDDocument();){
            PDPage page = Abflusskurventafel.newPage();
            document.addPage(page);
            try (PDPageContentStream firstPageContent = new PDPageContentStream(document, page);){
                PDPageContentStream lastPageContent = this.render(document, firstPageContent);
                if (lastPageContent != null) {
                    lastPageContent.close();
                }
            }
            document.save(out);
        }
    }

    private static PDPage newPage() {
        return new PDPage(new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth()));
    }

    private PDPageContentStream render(PDDocument document, PDPageContentStream content) throws IOException {
        this.\u00fcberschrift(content);
        this.kopfinformationen(content);
        Abflusskurve abflusskurve = this.model.abflusskurve();
        if (this.wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Centimeter\u00dcberAktuellemPegelnullpunkt) {
            return this.writeTable(document, content, abflusskurve);
        }
        if (this.wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
            return this.writeTableNHN(content, abflusskurve, this.model.nhnTransformation());
        }
        return content;
    }

    private void \u00fcberschrift(PDPageContentStream content) throws IOException {
        Abflusskurve abflusskurve = this.model.abflusskurve();
        content.setFont(boldFont, 9.0f);
        Object g\u00fcltigkeitshinweis = Abflusskurvenliste.textZuKurveng\u00fcltigkeit(this.model.letzteG\u00fcltigkeit());
        if (((String)g\u00fcltigkeitshinweis).length() > 0) {
            g\u00fcltigkeitshinweis = "(" + (String)g\u00fcltigkeitshinweis + ")";
        }
        String text = "Abflusskurventafel zu " + abflusskurve.name() + " in m\u00b3/s" + (String)g\u00fcltigkeitshinweis;
        Rendering.textAt(content, 62.0f, 570.0f, text);
    }

    private void kopfinformationen(PDPageContentStream content) throws IOException {
        TabellenHeaderRenderModel header = this.model.header();
        float fontSize = 8.0f;
        content.setFont(font, 8.0f);
        int labelRow1Y = 553;
        int labelRow2Y = 539;
        int labelRow3Y = 525;
        int labelRow4Y = 511;
        int labelColumn1X = 62;
        int colonColumn1X = 82;
        Rendering.textAt(content, 62.0f, 553.0f, "A");
        content.setFont(font, 6.0f);
        Rendering.textAt(content, 68.0f, 551.0f, "Eo");
        content.setFont(font, 8.0f);
        Rendering.textAt(content, 82.0f, 553.0f, ":");
        int xOffsetValue = 29;
        int xOffsetUnit = 65;
        float valueFontSize = 7.0f;
        Rendering.textAt(content, 82 + (header.istSeepegel() ? 6 : 29), 553.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.einzugsgebiet), font, 7.0f);
        Rendering.textAt(content, 147.0f, 553.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.einzugsgebiet_einheit), font, 8.0f);
        Rendering.textAt(content, 62.0f, 539.0f, "PNP");
        Rendering.textAt(content, 82.0f, 539.0f, ":  NN +");
        Rendering.textAt(content, 111.0f, 539.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nullpunkt), font, 7.0f);
        Rendering.textAt(content, 147.0f, 539.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nullpunkt_einheit), font, 8.0f);
        Rendering.textAt(content, 62.0f, 525.0f, "Lage");
        Rendering.textAt(content, 82.0f, 525.0f, ":");
        if (header.istSeepegel()) {
            Rendering.textAt(content, 88.0f, 525.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage), font, 7.0f);
        } else {
            Rendering.textAt(content, 111.0f, 525.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage), font, 7.0f);
            Rendering.textAt(content, 147.0f, 525.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage_einheit), font, 8.0f);
            content.setFont(font, 6.0f);
            Rendering.textAt(content, 162.0f, 525.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.lage_bezugspunkt));
        }
        Rendering.textAt(content, 62.0f, 511.0f, "Pegelinhaber:", font, 8.0f);
        Rendering.textAt(content, 147.0f, 511.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegelbetreiber), font, 7.0f);
        content.setFont(font, 8.0f);
        int labelColumn2X = 355;
        int colonColumn2X = 392;
        int xOffset = 5;
        Rendering.textAt(content, 355.0f, 553.0f, "Standort");
        Rendering.textAt(content, 392.0f, 553.0f, ":");
        Rendering.textAt(content, 397.0f, 553.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.pegel), font, 7.0f);
        Rendering.textAt(content, 355.0f, 539.0f, "Gew\u00e4sser", font, 8.0f);
        Rendering.textAt(content, 392.0f, 539.0f, ":");
        Rendering.textAt(content, 397.0f, 539.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.gew\u00e4sser), font, 7.0f);
        Rendering.textAt(content, 355.0f, 525.0f, "Teilgebiet", font, 8.0f);
        Rendering.textAt(content, 392.0f, 525.0f, ":");
        Rendering.textAt(content, 397.0f, 525.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.teilgebiet), font, 7.0f);
        Rendering.textAt(content, 345.0f, 511.0f, "Herausgeber", font, 8.0f);
        Rendering.textAt(content, 392.0f, 511.0f, ":");
        Rendering.textAt(content, 397.0f, 511.0f, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.herausgeber), font, 7.0f);
        int labelColumn3X = 550;
        int colonColumn3X = 592;
        Rendering.textAt(content, 550.0f, 553.0f, "Nr.", font, 8.0f);
        Rendering.textAt(content, 592.0f, 553.0f, ":");
        Rendering.textRightAlignedAt(content, 633, 553, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.nr), font, 8.0f);
        Rendering.textAt(content, 550.0f, 539.0f, "Zeitbezug", font, 8.0f);
        Rendering.textAt(content, 592.0f, 539.0f, ":");
        Rendering.textRightAlignedAt(content, 633, 539, "MEZ", font, 8.0f);
        Rendering.textAt(content, 550.0f, 525.0f, "Datenstand", font, 8.0f);
        Rendering.textAt(content, 592.0f, 525.0f, ":");
        Rendering.textRightAlignedAt(content, 633, 525, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.datenstand), font, 7.0f);
        Rendering.textAt(content, 550.0f, 511.0f, "Quelle", font, 8.0f);
        Rendering.textAt(content, 592.0f, 511.0f, ":");
        Rendering.textRightAlignedAt(content, 633, 511, header.wertF\u00fcr(TabellenHeaderRenderModel.felder.quelle), font, 7.0f);
    }

    private PDPageContentStream writeTable(PDDocument document, PDPageContentStream content, Abflusskurve abflusskurve) throws IOException {
        int tableY = 480;
        this.writeColumnHeaders(content, 480.0f);
        int lineY = 472;
        Rendering.drawLine(content, 63.0f, 472.0f, 762.0f, 472.0f);
        HashMap<Integer, WQWert> buckets = new HashMap<Integer, WQWert>();
        for (WQWert value : abflusskurve.werte()) {
            buckets.put((int)value.W().wert(), value);
        }
        List<Integer> lineNumbers = this.lineNumbersFromBucket(buckets);
        Optional<Integer> minLine = IntegerArithmetic.Minimum(lineNumbers);
        Optional<Integer> maxLine = IntegerArithmetic.Maximum(lineNumbers);
        PDPageContentStream currentPageContent = content;
        if (minLine.isPresent() && maxLine.isPresent()) {
            Integer min = minLine.get();
            Integer max = maxLine.get();
            int x2 = 110;
            int y2 = 460;
            if (min < 0 && max >= 0) {
                currentPageContent = this.writeLines(document, currentPageContent, buckets, 110.0f, y2, min, -1);
                currentPageContent = this.writeLines(document, currentPageContent, buckets, 110.0f, y2 -= 14 * Math.abs(min), 0, max);
            } else {
                currentPageContent = this.writeLines(document, currentPageContent, buckets, 110.0f, y2, min, max);
            }
        }
        return currentPageContent;
    }

    private PDPageContentStream writeTableNHN(PDPageContentStream content, Abflusskurve abflusskurve, NHNTransformationOfTimestampedValues transformation) throws IOException {
        int tableY = 480;
        this.writeColumnHeadersNHN(content, 480.0f);
        int lineY = 472;
        Rendering.drawLine(content, 40.0f, 472.0f, 762.0f, 472.0f);
        try {
            HashMap<BigDecimal, WQWert> buckets = new HashMap<BigDecimal, WQWert>();
            for (WQWert value : abflusskurve.werte()) {
                buckets.put(this.nhnWasserstandF\u00fcr(transformation, value), value);
            }
            List<Integer> lineNumbers = this.lineNumbersFromBucketNHN(buckets);
            Optional<Integer> minLine = IntegerArithmetic.Minimum(lineNumbers);
            Optional<Integer> maxLine = IntegerArithmetic.Maximum(lineNumbers);
            if (minLine.isPresent() && maxLine.isPresent()) {
                Integer min = minLine.get();
                Integer max = maxLine.get();
                int x2 = 110;
                int y2 = 460;
                if (min < 0 && max >= 0) {
                    this.writeLinesNHN(content, buckets, 110.0f, y2, min, -100);
                    this.writeLinesNHN(content, buckets, 110.0f, y2 -= 14 * Math.abs(min), 0, max);
                } else {
                    this.writeLinesNHN(content, buckets, 110.0f, y2, min, max);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Rendering.textAt(content, 62.0f, 440.0f, "FEHLER: Evtl. fehlen NHN-Daten.", font, 10.0f);
        }
        return content;
    }

    private BigDecimal nhnWasserstandF\u00fcr(NHNTransformationOfTimestampedValues transformation, WQWert value) {
        return BigDecimal.valueOf(transformation.forValue(value.W().wert())).setScale(3, RoundingMode.HALF_UP);
    }

    private List<Integer> lineNumbersFromBucket(Map<Integer, WQWert> buckets) {
        return buckets.keySet().stream().map(wert -> IntegerArithmetic.largestIntegerDivisibleBy10AndSmallerOrEqualTo(wert.intValue()) / 10).collect(Collectors.toList());
    }

    private List<Integer> lineNumbersFromBucketNHN(Map<BigDecimal, WQWert> buckets) {
        return buckets.keySet().stream().map(wert -> wert.multiply(new BigDecimal("1000")).setScale(0, RoundingMode.DOWN).intValue()).collect(Collectors.toList());
    }

    private PDPageContentStream writeLines(PDDocument document, PDPageContentStream content, Map<Integer, WQWert> buckets, float x2, float y2, Integer minLine, Integer maxLine) throws IOException {
        PDPageContentStream currentPageContent = content;
        Integer line = minLine;
        while (line <= maxLine) {
            float curX = x2;
            if (line % 5 == 0) {
                y2 -= 10.0f;
            }
            Rendering.textRightAlignedAt(currentPageContent, (int)curX, (int)y2, String.valueOf(line * 10), boldFont, 8.0f);
            for (int i2 = 0; i2 < 10; ++i2) {
                WQWert value = buckets.get(i2 + line * 10);
                curX += 65.0f;
                if (value == null) continue;
                String formattedValue = Parameter.q.formatValuePadded(value.Q()).replace("  ", " ").replace(" ", " ");
                Rendering.textRightAlignedAt(currentPageContent, (int)curX, (int)y2, formattedValue, fixedFont, 8.0f);
            }
            if (Abflusskurventafel.isEndOfPage(y2 -= 14.0f)) {
                currentPageContent.close();
                PDPage nextPage = Abflusskurventafel.newPage();
                document.addPage(nextPage);
                currentPageContent = new PDPageContentStream(document, nextPage);
                y2 = 570.0f;
            }
            Integer n2 = line;
            line = line + 1;
        }
        return currentPageContent;
    }

    private static boolean isEndOfPage(float y2) {
        return y2 <= 30.0f;
    }

    private void writeLinesNHN(PDPageContentStream content, Map<BigDecimal, WQWert> buckets, float x2, float y2, Integer minLine, Integer maxLine) throws IOException {
        Integer line = minLine;
        while (line <= maxLine) {
            float curX = x2;
            if (line % 500 == 0) {
                y2 -= 10.0f;
            }
            BigDecimal nhnValueForLine = new BigDecimal(line).multiply(new BigDecimal("0.001")).setScale(3, RoundingMode.HALF_UP);
            Rendering.textRightAlignedAt(content, (int)curX, (int)y2, nhnValueForLine.toString().replace('.', ','), boldFont, 8.0f);
            for (int i2 = 0; i2 < 10; ++i2) {
                WQWert value = buckets.get(nhnValueForLine.add(new BigDecimal(i2).multiply(new BigDecimal("0.01")).setScale(2, RoundingMode.HALF_UP)));
                curX += 65.0f;
                if (value == null) continue;
                String formattedValue = Parameter.q.formatValuePadded(value.Q()).replace("  ", " ").replace(" ", "&nbsp;");
                Rendering.textRightAlignedAt(content, (int)curX, (int)y2, formattedValue, fixedFont, 8.0f);
            }
            line = line + 100;
        }
    }

    private void writeColumnHeaders(PDPageContentStream out, float y2) throws IOException {
        int x2 = 110;
        this.writeHeader(out, 110.0f, y2, "cm");
        for (int i2 = 0; i2 < 10; ++i2) {
            this.writeHeader(out, 110 + (i2 + 1) * 65, y2, String.valueOf(i2));
        }
    }

    private void writeColumnHeadersNHN(PDPageContentStream out, float y2) throws IOException {
        int x2 = 110;
        this.writeHeader(out, 110.0f, y2, "NHN+m (HS170)");
        for (int i2 = 0; i2 < 10; ++i2) {
            this.writeHeader(out, 110 + (i2 + 1) * 65, y2, "+0,0" + i2);
        }
    }

    private void writeHeader(PDPageContentStream out, float x2, float y2, String text) throws IOException {
        Rendering.textRightAlignedAt(out, (int)x2, (int)y2, text, boldFont, 9.0f);
    }
}

