/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.pdf;

import java.awt.Color;
import java.awt.Font;
import java.io.OutputStream;
import luwa.marlin.ship_library.model.Abflusskurve;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.value.WQWert;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.pdf.helpers.Chart;
import luwa.marlin.web.OutputView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.joda.time.DateTime;

public class Abflusskurvengrafik
implements OutputView {
    private final Model model;

    public Abflusskurvengrafik(Model model) {
        this.model = model;
    }

    @Override
    public String name() {
        return "Abflusskurvengrafik";
    }

    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        Chart.writeAsPDF(out, this.chart());
    }

    private XYSeries data(Abflusskurve abflusskurve) {
        XYSeries series = new XYSeries((Comparable)((Object)abflusskurve.name()));
        for (WQWert value : abflusskurve.werte()) {
            series.add(value.Q().wert(), value.W().wert());
        }
        return series;
    }

    private JFreeChart chart() {
        Abflusskurve abflusskurve = this.model.abflusskurve();
        XYSeries series = this.data(abflusskurve);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart(abflusskurve.name(), "Q in " + Parameter.q.unit(), "W in " + Parameter.w.unit(), dataset);
        chart.setBackgroundPaint(Color.white);
        chart.setBackgroundImageAlpha(0.0f);
        Font arial = new Font("Arial", 0, 14);
        chart.getTitle().setFont(arial);
        chart.getTitle().setPadding(10.0, 1.0, 1.0, 1.0);
        chart.getLegend().setItemFont(arial);
        chart.getLegend().setMargin(0.0, 0.0, 20.0, 0.0);
        TextTitle dataStatus = new TextTitle("Stand: " + Format.formatDay(new DateTime()));
        dataStatus.setFont(arial.deriveFont(12.0f));
        dataStatus.setPosition(RectangleEdge.TOP);
        dataStatus.setTextAlignment(HorizontalAlignment.RIGHT);
        dataStatus.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        dataStatus.setPadding(1.0, 1.0, 1.0, 12.0);
        dataStatus.setMargin(-16.0, 0.0, 0.0, 0.0);
        chart.addSubtitle(dataStatus);
        TextTitle type = new TextTitle(this.model.messstelle().bezeichnung());
        type.setFont(arial.deriveFont(12.0f));
        type.setPosition(RectangleEdge.TOP);
        type.setTextAlignment(HorizontalAlignment.LEFT);
        type.setHorizontalAlignment(HorizontalAlignment.LEFT);
        type.setPadding(1.0, 1.0, 1.0, 1.0);
        type.setMargin(-16.0, 50.0, 0.0, 0.0);
        chart.addSubtitle(type);
        XYPlot plot = chart.getXYPlot();
        ValueAxis x2 = plot.getDomainAxis();
        x2.setLabelFont(arial);
        x2.setTickLabelFont(arial.deriveFont(12.0f));
        plot.setDomainAxis(x2);
        plot.getRangeAxis().setLabelFont(arial);
        plot.getRangeAxis().setTickLabelFont(arial.deriveFont(12.0f));
        plot.setBackgroundPaint(Color.white);
        plot.setBackgroundImageAlpha(0.0f);
        plot.setDomainGridlinePaint(Color.gray);
        plot.setRangeGridlinePaint(Color.gray);
        plot.getRenderer().setSeriesPaint(0, Color.blue);
        return chart;
    }

    public static class Model {
        private final Messstelle messstelle;
        private final Abflusskurve abflusskurve;

        public Model(Messstelle messstelle, Abflusskurve abflusskurve) {
            this.messstelle = messstelle;
            this.abflusskurve = abflusskurve;
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        public Abflusskurve abflusskurve() {
            return this.abflusskurve;
        }

        public static Model lade(DatenRepository datenRepository, long abflusskurvenId) throws Exception {
            Abflusskurve abflusskurve = datenRepository.abflusskurve(abflusskurvenId);
            Messstelle messstelle = datenRepository.messstelle(abflusskurve.messstellenNummer());
            return new Model(messstelle, abflusskurve);
        }
    }
}

