/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html.uebersicht;

import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import luwa.marlin.component.Component;
import luwa.marlin.configuration.ConfiguredNetwork;
import luwa.marlin.web.OutputView;

public class Sonstige\u00dcbersicht
implements OutputView {
    private final String titel;
    private final String path;
    private final String authToken;

    public Sonstige\u00dcbersicht(String titel, String path, String authToken) {
        this.titel = titel;
        this.path = path;
        this.authToken = authToken;
    }

    @Override
    public String name() {
        return this.titel;
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        ConfiguredNetwork stammdatenDienst = ConfiguredNetwork.forService(Component.stammdaten);
        String stammdatenBaseURL = "https://" + stammdatenDienst.host() + ":" + stammdatenDienst.port() + "/pegelstammdaten";
        String requestPath = stammdatenBaseURL + "/" + this.path;
        try {
            CookieManager cookieManager = new CookieManager();
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> hostname.equals("localhost") || hostname.equals(stammdatenDienst.host()));
            HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).cookieHandler(cookieManager).build();
            HttpRequest cookieRequest = HttpRequest.newBuilder().uri(URI.create(requestPath + "?auth_token=" + this.authToken)).GET().build();
            HttpResponse<String> cookieResponse = httpClient.send(cookieRequest, HttpResponse.BodyHandlers.ofString());
            URI uri = URI.create(requestPath + "?datenausgabe=true");
            String sessionCookieHeader = cookieResponse.headers().firstValue("set-cookie").orElse("");
            List<HttpCookie> sessionCookie = HttpCookie.parse(sessionCookieHeader);
            for (HttpCookie cookie : sessionCookie) {
                cookieManager.getCookieStore().add(uri, cookie);
            }
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            out.write(response.body());
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte \u00dcbersicht-Anfrage nicht beantworten", e2);
        }
    }
}

