/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html.uebersicht;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import luwa.marlin.ship_library.model.uebersicht.PegelMitUng\u00fcltigerWQBeziehungModel;
import luwa.marlin.ship_library.view.html.HTMLHelper;
import luwa.marlin.ship_library.view.html.uebersicht.\u00dcbersichtHTML;
import luwa.marlin.web.OutputView;

public class PegelMitUng\u00fcltigerWQBeziehung
implements OutputView {
    private final PegelMitUng\u00fcltigerWQBeziehungModel model;

    public PegelMitUng\u00fcltigerWQBeziehung(PegelMitUng\u00fcltigerWQBeziehungModel model) {
        this.model = model;
    }

    @Override
    public String name() {
        return this.model.\u00fcberschrift();
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream stream) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(stream), false, StandardCharsets.UTF_8);
        this.writeHTML(printStream);
        printStream.flush();
    }

    private void writeHTML(PrintStream out) {
        out.println("<!DOCTYPE html>");
        out.println("<html lang=\"de\">");
        out.println("<head>");
        out.println("<meta charset=\"" + this.charset().toLowerCase() + "\">");
        out.println("<title>" + HTMLHelper.html(this.model.\u00fcberschrift()) + "</title>");
        out.println("<style>");
        \u00dcbersichtHTML.writeStylesheet(out);
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        this.writeBody(out);
        out.println("</body>");
        out.println("</html>");
    }

    private void writeBody(PrintStream out) {
        out.println("<div class=\"container main-no-station\">");
        out.println("<h2><span>" + HTMLHelper.html(this.model.\u00fcberschrift()) + "</span></h2>");
        out.println("<div class=\"row\">");
        for (PegelMitUng\u00fcltigerWQBeziehungModel.Eigent\u00fcmerAbschnitt eigent\u00fcmerAbschnitt : this.model.eigent\u00fcmerAbschnitte()) {
            out.println("<h3>" + HTMLHelper.html(eigent\u00fcmerAbschnitt.eigent\u00fcmer()) + "</h3>");
            for (PegelMitUng\u00fcltigerWQBeziehungModel.BetreiberAbschnitt betreiberAbschnitt : eigent\u00fcmerAbschnitt.betreiberAbschnitte()) {
                this.writeBetreiberAbschnitt(out, betreiberAbschnitt);
            }
        }
        out.println("</div>");
        out.println("</div>");
    }

    private void writeBetreiberAbschnitt(PrintStream out, PegelMitUng\u00fcltigerWQBeziehungModel.BetreiberAbschnitt betreiberAbschnitt) {
        out.println("<table class=\"table\">");
        out.println("<thead>");
        out.println("<tr>");
        out.println("<th class=\"success\" style=\"width: 40%\">" + HTMLHelper.html(betreiberAbschnitt.betreiber()) + "</th>");
        out.println("<th class=\"success\" style=\"width: 10%\">W</th>");
        out.println("<th class=\"success\" style=\"width: 10%\">Q</th>");
        out.println("<th class=\"success\" style=\"width: 40%\" colspan=\"2\">Letzter Eintrag in den G\u00fcltigkeiten</th>");
        out.println("</tr>");
        out.println("</thead>");
        out.println("<tbody>");
        for (PegelMitUng\u00fcltigerWQBeziehungModel.Zeile zeile : betreiberAbschnitt.zeilen()) {
            this.writeZeile(out, zeile);
        }
        out.println("</tbody>");
        out.println("</table>");
    }

    private void writeZeile(PrintStream out, PegelMitUng\u00fcltigerWQBeziehungModel.Zeile zeile) {
        out.println("<tr>");
        out.println("<td>");
        out.println("<a href=\"" + \u00dcbersichtHTML.messstellenStammdatenURL(zeile.messstelle().nummer()) + "\">" + HTMLHelper.html(zeile.messstelle().darstellung()) + "</a>");
        out.println("</td>");
        out.println("<td><b>" + HTMLHelper.html(zeile.darstellungW_au\u00dferBetrieb()) + "</b></td>");
        out.println("<td><b>" + HTMLHelper.html(zeile.darstellungQ_au\u00dferBetrieb()) + "</b></td>");
        if (zeile.g\u00fcltigeAbflusskurve().isPresent()) {
            PegelMitUng\u00fcltigerWQBeziehungModel.G\u00fcltigeAbflusskurve abflusskurve = zeile.g\u00fcltigeAbflusskurve().get();
            out.println("<td style=\"width: 10%\">" + abflusskurve.darstellungG\u00fcltigSeit() + "</td>");
            out.println("<td>" + abflusskurve.name() + "</td>");
        } else {
            out.println("<td></td>");
            out.println("<td>" + HTMLHelper.html(zeile.darstellungLetzterEintragInDenG\u00fcltigkeiten()) + "</td>");
        }
        out.println("</tr>");
    }
}

