/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view.html;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Stundenmittelwerte;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Stundenmittelwert;
import luwa.marlin.ship_library.model.value.Tagesh\u00f6chstwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.util.UnzureichendeDatenlage;
import luwa.marlin.ship_library.view.MonatsHauptwerteRenderModel;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.ViewHelper;
import luwa.marlin.ship_library.view.html.ListPageHelpers;
import luwa.marlin.ship_library.view.pdf.helpers.FestgelegterFormatierer;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;

public class Monatstabelle
implements OutputView {
    private final long messstellenNummer;
    private final AbflussOderWasserstand abflussOderWasserstand;
    private final YearMonth month;
    private final DatenRepository datenRepository;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final FestgelegterFormatierer wertFormatierer;
    private final long benutzerId;
    private NHNTransformationOfTimestampedValues nhntransform;

    public Monatstabelle(long messstellenNummer, long benutzerId, AbflussOderWasserstand abflussOderWasserstand, YearMonth month, DatenRepository datenRepository, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.messstellenNummer = messstellenNummer;
        this.benutzerId = benutzerId;
        this.abflussOderWasserstand = abflussOderWasserstand;
        this.month = month;
        this.datenRepository = datenRepository;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
        this.wertFormatierer = new FestgelegterFormatierer("-", wasserstandBezugsh\u00f6he, abflussOderWasserstand);
    }

    @Override
    public String name() {
        return "Monatstabelle";
    }

    @Override
    public String contentType() {
        return "text/html";
    }

    @Override
    public String charset() {
        return "UTF-8";
    }

    @Override
    public void writeTo(OutputStream out) throws Exception {
        PrintStream printStream = new PrintStream((OutputStream)new BufferedOutputStream(out), false, StandardCharsets.UTF_8);
        this.writeTo(printStream);
        printStream.flush();
    }

    private void writeTo(PrintStream out) throws Exception {
        Messstelle messstelle = this.datenRepository.messstelle(this.messstellenNummer);
        Benutzer benutzer = this.datenRepository.benutzer(this.benutzerId);
        this.nhntransform = NHNTransformationOfTimestampedValues.buildNHNTransform(this.messstellenNummer, this.datenRepository, this.wasserstandBezugsh\u00f6he);
        Optional<Pegelnullpunkt> pegelnullpunkt = ViewHelper.pegelnullpunkt(this.datenRepository, this.messstellenNummer);
        TabellenHeaderRenderModel header = new TabellenHeaderRenderModel(messstelle, pegelnullpunkt, benutzer, this.wasserstandBezugsh\u00f6he);
        ListPageHelpers.writeHead(out, "Monatstabelle " + this.month + " von " + this.messstellenNummer, "thead tr th {", "  width: 3%;", "}", ".wide {", "  width: 5%", "}", ".wide2x {", "  width: 10%", "}");
        out.println("<body>");
        ListPageHelpers.writeHeader(out, "Monatstabelle " + this.month.month() + "/" + this.month.year(), this.abflussOderWasserstand.symbol(), this.abflussOderWasserstand.einheitLang(this.wasserstandBezugsh\u00f6he) + "<br>Stundenmittel", header);
        this.writeTable(out);
        out.println("</body>");
        out.println("</html>");
        out.println();
    }

    private void writeTable(PrintStream out) throws Exception {
        int h2;
        out.println("<table>");
        out.println("<thead>");
        out.println("<tr>");
        out.println("<th colspan='2' class='centered'>Zeit</th>");
        out.println("<th colspan='2' class='centered wide2x'>H" + this.abflussOderWasserstand.symbol() + "</th>");
        out.println("<th class='wide'>0</th>");
        for (h2 = 1; h2 < 24; ++h2) {
            out.println("<th>" + h2 + "</th>");
        }
        out.println("</tr>");
        out.println("<tr>");
        out.println("<th colspan='2' class='centered'>Tag</th>");
        out.println("<th class='wide'>" + this.abflussOderWasserstand.einheitKurz(this.wasserstandBezugsh\u00f6he) + "</th>");
        out.println("<th>hh:mm</th>");
        for (h2 = 0; h2 < 24; ++h2) {
            out.println("<th></th>");
        }
        out.println("</tr>");
        out.println("</thead>");
        try {
            this.writeTableBody(out);
        }
        catch (UnzureichendeDatenlage unzureichendeDatenlage) {
            ViewHelper.writeErrorMessageAsTableBody(out, unzureichendeDatenlage, this.wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170);
        }
        out.println("</table>");
        out.println("<div>");
        out.println("</div>");
    }

    private void writeTableBody(PrintStream out) throws Exception {
        out.println("<tbody>");
        Stundenmittelwerte values = this.datenRepository.stundenmittelwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.month.interval(), Ausfalljahre.keine, 1.0, this.nhntransform);
        Tagesh\u00f6chstwerte maxs = this.datenRepository.tagesh\u00f6chstwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.month.interval(), Ausfalljahre.keine, 1.0, this.nhntransform);
        for (Day day : this.month.days()) {
            out.println("<tr>");
            out.println("<td>" + Format.formatShortDay(day.dateTime()) + "</td>");
            out.println("<td>" + Format.formatWeekday(day.dateTime()) + "</td>");
            Optional<Tagesh\u00f6chstwert> max = maxs.desTages(day);
            out.println("<td>" + (max.isEmpty() ? "" : this.wertFormatierer.nurSignifikanteStellenVonTimeStampedValue(max)) + "</td>");
            out.println("<td>" + (max.isEmpty() ? "" : this.wertFormatierer.uhrzeit(max.get())) + "</td>");
            for (int h2 = 0; h2 < 24; ++h2) {
                Stundenmittelwert value = values.ofHour(day, h2);
                out.println("<td>" + (value == null || value.istL\u00fccke() ? "" : this.wertFormatierer.nurSignifikanteStellenVonTimeStampedValue(value)) + "</td>");
            }
            out.println("</tr>");
        }
        out.println("<tr>");
        out.println("<th colspan='28'></th>");
        out.println("</tr>");
        this.writeHauptwerte(out);
        out.println("</tbody>");
    }

    private void writeHauptwerte(PrintStream out) throws Exception {
        Tagesmittelwerte tagesmittelwerte = this.datenRepository.tagesmittelwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.month.interval(), Ausfalljahre.keine, 1.0, this.nhntransform, TimestampedValue::compareTo);
        Hauptwerte hauptwerte = new Hauptwerte(tagesmittelwerte, this.datenRepository.tagesh\u00f6chstwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.month.interval(), Ausfalljahre.keine, 1.0, this.nhntransform), this.datenRepository.scheitelwerte(this.messstellenNummer, this.abflussOderWasserstand.toParameter(), this.month.interval(), Ausfalljahre.keine, 1.0, this.nhntransform), null, new Ausfalljahre());
        MonatsHauptwerteRenderModel model = new MonatsHauptwerteRenderModel(hauptwerte, List.of(this.month), this.abflussOderWasserstand, false, this.wertFormatierer);
        out.println("<tr>");
        out.println("<td colspan='2'>N" + this.abflussOderWasserstand.symbol() + "(TM)</td>");
        out.println("<td>" + model.wert(this.month, MonatsHauptwerteRenderModel.ZeilenMonatswerte.N) + " " + this.abflussOderWasserstand.einheitKurz(this.wasserstandBezugsh\u00f6he) + "</td>");
        out.println("<td colspan='25' class='left'>am " + model.wert(this.month, MonatsHauptwerteRenderModel.ZeilenMonatswerte.Datum_N) + "</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td colspan='2'>M" + this.abflussOderWasserstand.symbol() + "</td>");
        out.println("<td>" + model.wert(this.month, MonatsHauptwerteRenderModel.ZeilenMonatswerte.M) + " " + this.abflussOderWasserstand.einheitKurz(this.wasserstandBezugsh\u00f6he) + "</td>");
        out.println("<td colspan='25' class='left'></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td colspan='2'>H" + this.abflussOderWasserstand.symbol() + "</td>");
        out.println("<td>" + model.wert(this.month, MonatsHauptwerteRenderModel.ZeilenMonatswerte.H) + " " + this.abflussOderWasserstand.einheitKurz(this.wasserstandBezugsh\u00f6he) + "</td>");
        out.println("<td colspan='25' class='left'>am " + model.wert(this.month, MonatsHauptwerteRenderModel.ZeilenMonatswerte.Datum_H) + " " + model.wert(this.month, MonatsHauptwerteRenderModel.ZeilenMonatswerte.Uhrzeit_H) + " Uhr</td>");
        out.println("</tr>");
    }
}

