/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Abflusshalbjahr;
import luwa.marlin.ship_library.model.Hauptwerte;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.CalendarYearsRange;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Kalenderjahr;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearsRange;
import luwa.marlin.ship_library.util.OptionalMitMarkierung;
import luwa.marlin.ship_library.view.MonatsHauptwerteRenderModel;
import luwa.marlin.ship_library.view.SpaltenHauptwerteDerZeitreihe;
import luwa.marlin.ship_library.view.ZeilenHauptwerteDerZeitreihe;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import org.joda.time.DateTime;

public class HauptwerteRenderModel {
    private final Hauptwerte hauptwerte;
    private final Iterable<YearMonth> monate;
    private final int startJahr;
    private final int endJahr;
    private final int jahr;
    private final WertFormatierer formatierteWerte;
    private final Optional<Tagesh\u00f6chstwerte> tagesh\u00f6chstwerteW;
    private final Optional<Tagesmittelwerte> tagesmittelwerteW;
    private final Double einzugsgebietInQuadratkilometer;
    private final boolean abflussspendeBerechnen;
    private final Hauptwerte.mehrj\u00e4hrigeHauptwerte mehrj\u00e4hrigeHauptwerte;
    private final MonatsHauptwerteRenderModel monatsHauptwerte;
    private final AbflussOderWasserstand QoderW;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;

    public HauptwerteRenderModel(Jahrbuchseite data) {
        this(data, new WertFormatierer("-", false));
    }

    public HauptwerteRenderModel(Jahrbuchseite data, WertFormatierer wertFormatierer) {
        this.formatierteWerte = wertFormatierer;
        this.hauptwerte = data.hauptwerte();
        this.monate = data.configuration().erweitertesJahr();
        this.jahr = data.configuration().jahr();
        this.startJahr = data.configuration().anfangsjahrZeitreihe();
        this.endJahr = data.configuration().endjahrZeitreihe();
        this.QoderW = data.configuration().abflussOderWasserstand();
        this.wasserstandBezugsh\u00f6he = data.configuration().wasserstandBezugsh\u00f6he();
        this.tagesmittelwerteW = data.tagesmittelwerteW();
        this.tagesh\u00f6chstwerteW = data.tagesh\u00f6chstwerteW();
        this.einzugsgebietInQuadratkilometer = data.messstelle().fl\u00e4cheEinzugsgebietInQuadratkilometer();
        this.mehrj\u00e4hrigeHauptwerte = this.hauptwerte.yearsRangeMainValues(this.startJahr, this.endJahr);
        this.abflussspendeBerechnen = data.abflussspendeBerechnen();
        this.monatsHauptwerte = new MonatsHauptwerteRenderModel(this.hauptwerte, this.monate, this.QoderW, this.formatierteWerte);
    }

    public Map<YearMonth, ? extends Map<MonatsHauptwerteRenderModel.ZeilenMonatswerte, String>> monatswerte() {
        return this.monatsHauptwerte.werte();
    }

    public Map<MonatsHauptwerteRenderModel.ZeilenMonatswerte, String> monatswerte(YearMonth monat) {
        return this.monatsHauptwerte.werte().get(monat);
    }

    public Map<YearMonth, ? extends Map<ZeilenMehrj\u00e4hrigeMonatswerte, String>> mehrj\u00e4hrigeMonatswerte() {
        HashMap model = new HashMap();
        for (YearMonth monat : this.monate) {
            OptionalMitMarkierung<? extends TimestampedValue> N = this.hauptwerte.mehrj\u00e4hrigerMonatswert(this.zeitbereichF\u00fcrMonat(monat), monat.month(), Hauptwerte.Art.N);
            OptionalMitMarkierung<? extends TimestampedValue> MN = this.hauptwerte.mehrj\u00e4hrigerMonatswert(this.zeitbereichF\u00fcrMonat(monat), monat.month(), Hauptwerte.Art.MN);
            OptionalMitMarkierung<? extends TimestampedValue> M = this.hauptwerte.mehrj\u00e4hrigerMonatswert(this.zeitbereichF\u00fcrMonat(monat), monat.month(), Hauptwerte.Art.M);
            OptionalMitMarkierung<? extends TimestampedValue> MH = this.hauptwerte.mehrj\u00e4hrigerMonatswert(this.zeitbereichF\u00fcrMonat(monat), monat.month(), Hauptwerte.Art.MH);
            OptionalMitMarkierung<? extends TimestampedValue> H = this.hauptwerte.mehrj\u00e4hrigerMonatswert(this.zeitbereichF\u00fcrMonat(monat), monat.month(), Hauptwerte.Art.H);
            model.put(monat, Map.ofEntries(Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.Jahr_N, this.formatierteWerte.jahrMitMehrfachMarkierung(N)), Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.N, this.formatierteWerte.nurSignifikanteStellen(N.value(), this.QoderW)), Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.MN, this.formatierteWerte.nurSignifikanteStellen(MN.value(), this.QoderW)), Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.M, this.formatierteWerte.nurSignifikanteStellen(M.value(), this.QoderW)), Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.MH, this.formatierteWerte.nurSignifikanteStellen(MH.value(), this.QoderW)), Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.H, this.formatierteWerte.nurSignifikanteStellen(H.value(), this.QoderW)), Map.entry(ZeilenMehrj\u00e4hrigeMonatswerte.Jahr_H, this.formatierteWerte.jahrMitMehrfachMarkierung(H))));
        }
        return model;
    }

    public Map<ZeilenJahreshauptwerte, ? extends Map<SpaltenJahreshauptwerte, String>> jahreswerte() {
        if (this.QoderW == AbflussOderWasserstand.Q) {
            return Map.ofEntries(Map.entry(ZeilenJahreshauptwerte.N, this.zeileJahreshauptwerteQ(Hauptwerte.Art.N)), Map.entry(ZeilenJahreshauptwerte.M, this.zeileJahreshauptwerteQ(Hauptwerte.Art.M)), Map.entry(ZeilenJahreshauptwerte.H, this.zeileJahreshauptwerteQ(Hauptwerte.Art.H)), Map.entry(ZeilenJahreshauptwerte.N_spende, this.jahresSpendeVon(Hauptwerte.Art.N)), Map.entry(ZeilenJahreshauptwerte.M_spende, this.jahresSpendeVon(Hauptwerte.Art.M)), Map.entry(ZeilenJahreshauptwerte.H_spende, this.jahresSpendeVon(Hauptwerte.Art.H)));
        }
        if (this.QoderW == AbflussOderWasserstand.W) {
            return Map.ofEntries(Map.entry(ZeilenJahreshauptwerte.N, this.zeileJahreshauptwerteW(Hauptwerte.Art.N)), Map.entry(ZeilenJahreshauptwerte.M, this.zeileJahreshauptwerteW(Hauptwerte.Art.M)), Map.entry(ZeilenJahreshauptwerte.H, this.zeileJahreshauptwerteW(Hauptwerte.Art.H)), Map.entry(ZeilenJahreshauptwerte.N_spende, this.leereZeileJahreshauptwerte()), Map.entry(ZeilenJahreshauptwerte.M_spende, this.leereZeileJahreshauptwerte()), Map.entry(ZeilenJahreshauptwerte.H_spende, this.leereZeileJahreshauptwerte()));
        }
        throw new IllegalArgumentException("Unknown value " + this.QoderW + " of enum " + AbflussOderWasserstand.class);
    }

    private Map<SpaltenJahreshauptwerte, String> zeileJahreshauptwerteW(Hauptwerte.Art art) {
        Abflussjahr abflussjahr = new Abflussjahr(this.jahr);
        Kalenderjahr kalenderjahr = new Kalenderjahr(this.jahr);
        OptionalMitMarkierung<? extends TimestampedValue> wertF\u00fcrAbflussjahr = this.hauptwerte.jahreswert(abflussjahr, art);
        Optional<Double> winter = this.hauptwerte.jahresHalbjahrwert(abflussjahr, art, Abflusshalbjahr.winter).map(TimestampedValue::wert);
        Optional<Double> sommer = this.hauptwerte.jahresHalbjahrwert(abflussjahr, art, Abflusshalbjahr.sommer).map(TimestampedValue::wert);
        OptionalMitMarkierung<? extends TimestampedValue> wertF\u00fcrKalenderjahr = this.hauptwerte.jahreswert(kalenderjahr, art);
        return Map.ofEntries(Map.entry(SpaltenJahreshauptwerte.WertAbflussjahr, this.formatierteWerte.nurSignifikanteStellen(wertF\u00fcrAbflussjahr.value(), this.QoderW)), Map.entry(SpaltenJahreshauptwerte.Wasserstand, ""), Map.entry(SpaltenJahreshauptwerte.DatumAbflussjahr, this.formatierteWerte.datumMitMehrfachMarkierung(wertF\u00fcrAbflussjahr)), Map.entry(SpaltenJahreshauptwerte.Winter, this.formatierteWerte.nurSignifikanteStellen(winter, this.QoderW)), Map.entry(SpaltenJahreshauptwerte.Sommer, this.formatierteWerte.nurSignifikanteStellen(sommer, this.QoderW)), Map.entry(SpaltenJahreshauptwerte.WertKalenderjahr, this.formatierteWerte.nurSignifikanteStellen(wertF\u00fcrKalenderjahr.value(), this.QoderW)), Map.entry(SpaltenJahreshauptwerte.DatumKalenderjahr, this.formatierteWerte.datumMitMehrfachMarkierung(wertF\u00fcrKalenderjahr)));
    }

    private Map<SpaltenJahreshauptwerte, String> zeileJahreshauptwerteQ(Hauptwerte.Art art) {
        Abflussjahr abflussjahr = new Abflussjahr(this.jahr);
        Kalenderjahr kalenderjahr = new Kalenderjahr(this.jahr);
        OptionalMitMarkierung<? extends TimestampedValue> wertF\u00fcrAbflussjahr = this.hauptwerte.jahreswert(abflussjahr, art);
        Optional<Double> wasserstand = this.wasserstand(wertF\u00fcrAbflussjahr, art);
        Optional<Double> winter = this.hauptwerte.jahresHalbjahrwert(abflussjahr, art, Abflusshalbjahr.winter).map(TimestampedValue::wert);
        Optional<Double> sommer = this.hauptwerte.jahresHalbjahrwert(abflussjahr, art, Abflusshalbjahr.sommer).map(TimestampedValue::wert);
        OptionalMitMarkierung<? extends TimestampedValue> wertF\u00fcrKalenderjahr = this.hauptwerte.jahreswert(kalenderjahr, art);
        if (art.equals((Object)Hauptwerte.Art.M)) {
            return Map.ofEntries(Map.entry(SpaltenJahreshauptwerte.WertAbflussjahr, this.formatierteWerte.nurSignifikanteStellen(wertF\u00fcrAbflussjahr.value(), this.QoderW)), Map.entry(SpaltenJahreshauptwerte.Wasserstand, ""), Map.entry(SpaltenJahreshauptwerte.DatumAbflussjahr, ""), Map.entry(SpaltenJahreshauptwerte.Winter, this.formatierteWerte.nurSignifikanteStellen(winter, this.QoderW)), Map.entry(SpaltenJahreshauptwerte.Sommer, this.formatierteWerte.nurSignifikanteStellen(sommer, this.QoderW)), Map.entry(SpaltenJahreshauptwerte.WertKalenderjahr, this.formatierteWerte.nurSignifikanteStellen(wertF\u00fcrKalenderjahr.value(), this.QoderW)), Map.entry(SpaltenJahreshauptwerte.DatumKalenderjahr, ""));
        }
        return Map.ofEntries(Map.entry(SpaltenJahreshauptwerte.WertAbflussjahr, this.formatierteWerte.nurSignifikanteStellen(wertF\u00fcrAbflussjahr.value(), this.QoderW)), Map.entry(SpaltenJahreshauptwerte.Wasserstand, this.formatierteWerte.nurSignifikanteStellen(wasserstand, AbflussOderWasserstand.W)), Map.entry(SpaltenJahreshauptwerte.DatumAbflussjahr, this.formatierteWerte.datumMitMehrfachMarkierung(wertF\u00fcrAbflussjahr)), Map.entry(SpaltenJahreshauptwerte.Winter, this.formatierteWerte.nurSignifikanteStellen(winter, this.QoderW)), Map.entry(SpaltenJahreshauptwerte.Sommer, this.formatierteWerte.nurSignifikanteStellen(sommer, this.QoderW)), Map.entry(SpaltenJahreshauptwerte.WertKalenderjahr, this.formatierteWerte.nurSignifikanteStellen(wertF\u00fcrKalenderjahr.value(), this.QoderW)), Map.entry(SpaltenJahreshauptwerte.DatumKalenderjahr, this.formatierteWerte.datumMitMehrfachMarkierung(wertF\u00fcrKalenderjahr)));
    }

    public Map<ZeilenHauptwerteDerZeitreihe, ? extends Map<SpaltenHauptwerteDerZeitreihe, String>> hauptwerteDerZeitreihe() {
        return Map.ofEntries(Map.entry(ZeilenHauptwerteDerZeitreihe.N, this.zeileHauptwerteDerZeitreihe(Hauptwerte.Art.N)), Map.entry(ZeilenHauptwerteDerZeitreihe.MN, this.zeileHauptwerteDerZeitreihe(Hauptwerte.Art.MN)), Map.entry(ZeilenHauptwerteDerZeitreihe.M, this.zeileHauptwerteDerZeitreihe(Hauptwerte.Art.M)), Map.entry(ZeilenHauptwerteDerZeitreihe.MH, this.zeileHauptwerteDerZeitreihe(Hauptwerte.Art.MH)), Map.entry(ZeilenHauptwerteDerZeitreihe.H, this.zeileHauptwerteDerZeitreihe(Hauptwerte.Art.H)), Map.entry(ZeilenHauptwerteDerZeitreihe.MNq, this.zeileMehrj\u00e4hrigeJahreswerteSpende(Hauptwerte.Art.MN)), Map.entry(ZeilenHauptwerteDerZeitreihe.Mq, this.zeileMehrj\u00e4hrigeJahreswerteSpende(Hauptwerte.Art.M)), Map.entry(ZeilenHauptwerteDerZeitreihe.MHq, this.zeileMehrj\u00e4hrigeJahreswerteSpende(Hauptwerte.Art.MH)));
    }

    private Map<SpaltenHauptwerteDerZeitreihe, String> hauptwerteDerZeitreiheLeereZeile() {
        return Map.ofEntries(Map.entry(SpaltenHauptwerteDerZeitreihe.Jahr, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.W, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Datum, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Winter, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Sommer, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Datum_Kalenderjahr, ""));
    }

    private Map<SpaltenHauptwerteDerZeitreihe, String> zeileMehrj\u00e4hrigeJahreswerteSpende(Hauptwerte.Art art) {
        if (this.QoderW == AbflussOderWasserstand.W) {
            return this.hauptwerteDerZeitreiheLeereZeile();
        }
        Optional<Double> jahreswert = this.calculateRate(this.mehrj\u00e4hrigeHauptwerte.jahreswert(art).value());
        Optional<Double> winter = this.calculateRate(this.mehrj\u00e4hrigeHauptwerte.abflusshalbjahr(art, Abflusshalbjahr.winter).map(TimestampedValue::wert));
        Optional<Double> sommer = this.calculateRate(this.mehrj\u00e4hrigeHauptwerte.abflusshalbjahr(art, Abflusshalbjahr.sommer).map(TimestampedValue::wert));
        Optional<Double> kalenderjahr = this.calculateRate(this.mehrj\u00e4hrigeHauptwerte.kalenderjahr(art).value());
        return Map.ofEntries(Map.entry(SpaltenHauptwerteDerZeitreihe.Jahr, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(jahreswert)), Map.entry(SpaltenHauptwerteDerZeitreihe.W, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Datum, ""), Map.entry(SpaltenHauptwerteDerZeitreihe.Winter, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(winter)), Map.entry(SpaltenHauptwerteDerZeitreihe.Sommer, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(sommer)), Map.entry(SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(kalenderjahr)), Map.entry(SpaltenHauptwerteDerZeitreihe.Datum_Kalenderjahr, ""));
    }

    private Map<SpaltenHauptwerteDerZeitreihe, String> zeileHauptwerteDerZeitreihe(Hauptwerte.Art art) {
        OptionalMitMarkierung<? extends TimestampedValue> jahreswert = this.mehrj\u00e4hrigeHauptwerte.jahreswert(art);
        String wasserstand = this.HauptwerteDerZeitreiheWasserstand(art, jahreswert);
        Optional<? extends TimestampedValue> winter = this.mehrj\u00e4hrigeHauptwerte.abflusshalbjahr(art, Abflusshalbjahr.winter);
        Optional<? extends TimestampedValue> sommer = this.mehrj\u00e4hrigeHauptwerte.abflusshalbjahr(art, Abflusshalbjahr.sommer);
        OptionalMitMarkierung<? extends TimestampedValue> kalenderjahr = this.mehrj\u00e4hrigeHauptwerte.kalenderjahr(art);
        return Map.ofEntries(Map.entry(SpaltenHauptwerteDerZeitreihe.Jahr, this.formatierteWerte.nurSignifikanteStellen(jahreswert.value(), this.QoderW)), Map.entry(SpaltenHauptwerteDerZeitreihe.W, wasserstand), Map.entry(SpaltenHauptwerteDerZeitreihe.Datum, this.formatierteWerte.datumMitMehrfachMarkierung(jahreswert)), Map.entry(SpaltenHauptwerteDerZeitreihe.Winter, this.formatierteWerte.nurSignifikanteStellen(winter.map(TimestampedValue::wert), this.QoderW)), Map.entry(SpaltenHauptwerteDerZeitreihe.Sommer, this.formatierteWerte.nurSignifikanteStellen(sommer.map(TimestampedValue::wert), this.QoderW)), Map.entry(SpaltenHauptwerteDerZeitreihe.Jahr_Kalenderjahr, this.formatierteWerte.nurSignifikanteStellen(kalenderjahr.value(), this.QoderW)), Map.entry(SpaltenHauptwerteDerZeitreihe.Datum_Kalenderjahr, this.formatierteWerte.datumMitMehrfachMarkierung(kalenderjahr)));
    }

    private String HauptwerteDerZeitreiheWasserstand(Hauptwerte.Art art, OptionalMitMarkierung<? extends TimestampedValue> jahreswert) {
        if (this.QoderW == AbflussOderWasserstand.W) {
            return "";
        }
        Optional<Day> day = jahreswert.tagDesAuftretens();
        if (art == Hauptwerte.Art.H) {
            return this.formatierterWasserstandsh\u00f6chstwert(day);
        }
        if (art == Hauptwerte.Art.N) {
            return this.formatierterWasserstandsniedrigwert(day);
        }
        return "";
    }

    private String formatierterWasserstandsniedrigwert(Optional<Day> day) {
        return this.formatierteWerte.nurSignifikanteStellenVonTimeStampedValue(this.tagesmittelwerteW.flatMap(tagesmittelwerteW -> day.flatMap(tagesmittelwerteW::desTages)), AbflussOderWasserstand.W);
    }

    private String formatierterWasserstandsh\u00f6chstwert(Optional<Day> day) {
        return this.formatierteWerte.nurSignifikanteStellenVonTimeStampedValue(this.tagesh\u00f6chstwerteW.flatMap(tagesh\u00f6chstwerteW -> day.flatMap(tagesh\u00f6chstwerteW::desTages)), AbflussOderWasserstand.W);
    }

    private Optional<Double> wasserstand(OptionalMitMarkierung<? extends TimestampedValue> wert, Hauptwerte.Art art) {
        switch (art) {
            case N: {
                return this.tagesmittelW(wert);
            }
            case M: {
                return Optional.empty();
            }
            case H: {
                return this.tagesh\u00f6chstwertW(wert);
            }
        }
        throw new IllegalStateException("Unexpected value: " + art);
    }

    private Map<SpaltenJahreshauptwerte, String> leereZeileJahreshauptwerte() {
        return Map.ofEntries(Map.entry(SpaltenJahreshauptwerte.WertAbflussjahr, ""), Map.entry(SpaltenJahreshauptwerte.Wasserstand, ""), Map.entry(SpaltenJahreshauptwerte.DatumAbflussjahr, ""), Map.entry(SpaltenJahreshauptwerte.Winter, ""), Map.entry(SpaltenJahreshauptwerte.Sommer, ""), Map.entry(SpaltenJahreshauptwerte.WertKalenderjahr, ""), Map.entry(SpaltenJahreshauptwerte.DatumKalenderjahr, ""));
    }

    private Map<SpaltenJahreshauptwerte, String> jahresSpendeVon(Hauptwerte.Art art) {
        Abflussjahr abflussjahr = new Abflussjahr(this.jahr);
        Kalenderjahr kalenderjahr = new Kalenderjahr(this.jahr);
        OptionalMitMarkierung<? extends TimestampedValue> wertF\u00fcrAbflussjahr = this.hauptwerte.jahreswert(abflussjahr, art);
        Optional<Double> winter = this.hauptwerte.jahresHalbjahrwert(abflussjahr, art, Abflusshalbjahr.winter).map(TimestampedValue::wert);
        Optional<Double> sommer = this.hauptwerte.jahresHalbjahrwert(abflussjahr, art, Abflusshalbjahr.sommer).map(TimestampedValue::wert);
        OptionalMitMarkierung<? extends TimestampedValue> wertF\u00fcrKalenderjahr = this.hauptwerte.jahreswert(kalenderjahr, art);
        Optional<Double> spende = this.calculateRate(wertF\u00fcrAbflussjahr.value());
        Optional<Double> winterSpende = this.calculateRate(winter);
        Optional<Double> sommerSpende = this.calculateRate(sommer);
        Optional<Double> spendeKalenderjahr = this.calculateRate(wertF\u00fcrKalenderjahr.value());
        return Map.ofEntries(Map.entry(SpaltenJahreshauptwerte.WertAbflussjahr, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(spende)), Map.entry(SpaltenJahreshauptwerte.Winter, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(winterSpende)), Map.entry(SpaltenJahreshauptwerte.Sommer, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(sommerSpende)), Map.entry(SpaltenJahreshauptwerte.WertKalenderjahr, this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(spendeKalenderjahr)));
    }

    public String HH() {
        OptionalMitMarkierung<Scheitelwert> HH = this.hauptwerte.HH();
        return "HH" + this.QoderW + " am " + this.formatierteWerte.datumMitMehrfachMarkierung(HH) + ": " + this.formatierteWerte.mitEinheitNoPadding(HH.value(), this.QoderW);
    }

    public String NN() {
        OptionalMitMarkierung<Tagesmittelwert> NN = this.hauptwerte.NN();
        return "NN" + this.QoderW + " am " + this.formatierteWerte.datumMitMehrfachMarkierung(NN) + ": " + this.formatierteWerte.mitEinheitNoPadding(NN.value(), this.QoderW);
    }

    private Optional<Double> calculateRate(Optional<Double> wert) {
        if (this.abflussspendeBerechnen && wert.isPresent()) {
            return this.hauptwerte.calculateRate(new TimestampedValue((ZonedDateTime)null, wert.get()), this.einzugsgebietInQuadratkilometer).map(TimestampedValue::wert);
        }
        return Optional.empty();
    }

    private Optional<Double> tagesmittelW(OptionalMitMarkierung<? extends TimestampedValue> wert) {
        if (wert.timestampedValue().isPresent()) {
            DateTime time = wert.timestampedValue().get().timestamp();
            return this.tagesmittelwerteW.flatMap(tagesmittelwerte -> tagesmittelwerte.ofDay(new Day(time))).map(TimestampedValue::wert);
        }
        return Optional.empty();
    }

    private Optional<Double> tagesh\u00f6chstwertW(OptionalMitMarkierung<? extends TimestampedValue> wert) {
        if (wert.timestampedValue().isPresent()) {
            DateTime time = wert.timestampedValue().get().timestamp();
            return this.tagesh\u00f6chstwerteW.flatMap(tagesh\u00f6chstwerte -> tagesh\u00f6chstwerte.desTages(new Day(time)).map(TimestampedValue::wert));
        }
        return Optional.empty();
    }

    private YearsRange<? extends Year> zeitbereichF\u00fcrMonat(YearMonth monat) {
        if (monat.year() == this.jahr) {
            return new CalendarYearsRange(this.startJahr, this.endJahr);
        }
        return new CalendarYearsRange(this.startJahr - 1, this.endJahr - 1);
    }

    public static enum ZeilenMehrj\u00e4hrigeMonatswerte {
        Jahr_N,
        N,
        MN,
        M,
        MH,
        H,
        Jahr_H;

    }

    public static enum ZeilenJahreshauptwerte {
        N,
        M,
        H,
        N_spende,
        M_spende,
        H_spende;

    }

    public static enum SpaltenJahreshauptwerte {
        WertAbflussjahr,
        Wasserstand,
        DatumAbflussjahr,
        Winter,
        Sommer,
        WertKalenderjahr,
        DatumKalenderjahr;

    }
}

