/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Extremwert;
import luwa.marlin.ship_library.model.Jahrbuchseite;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.ship_library.view.pdf.helpers.WertFormatierer;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;

public class ExtremwerteRenderModel {
    private final List<Optional<Extremwert>> hochwasser;
    private final List<Optional<Extremwert>> niedrigwasser;
    private final AbflussOderWasserstand QoderW;
    private final WertFormatierer formatierteWerte;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final int anfangsjahr;
    private final int endjahr;

    public ExtremwerteRenderModel(Jahrbuchseite data) {
        this(data, new WertFormatierer("-"));
    }

    public ExtremwerteRenderModel(Jahrbuchseite data, WertFormatierer wertFormatierer) {
        this.formatierteWerte = wertFormatierer;
        this.wasserstandBezugsh\u00f6he = data.configuration().wasserstandBezugsh\u00f6he();
        this.hochwasser = ExtremwerteRenderModel.extendListToLength(data.extremwerteH().collect(Collectors.toList()), 10);
        this.niedrigwasser = ExtremwerteRenderModel.extendListToLength(data.extremwerteN().collect(Collectors.toList()), 10);
        this.anfangsjahr = data.configuration().anfangsjahrZeitreihe();
        this.endjahr = data.configuration().endjahrZeitreihe();
        this.QoderW = data.configuration().abflussOderWasserstand();
    }

    public String header(Spalte spalte) {
        return spalte.header(this.QoderW, this.wasserstandBezugsh\u00f6he);
    }

    public List<HochOderNiedrigwasser> seiten() {
        return List.of(HochOderNiedrigwasser.values());
    }

    public List<Spalte> spalten() {
        if (this.QoderW.equals((Object)AbflussOderWasserstand.Q)) {
            return List.of(Spalte.values());
        }
        return List.of(Spalte.Wasserstand, Spalte.Datum);
    }

    public String jahreszahlen() {
        return this.anfangsjahr + " / " + this.endjahr;
    }

    public String anzahlJahre() {
        return this.endjahr - this.anfangsjahr + 1 + " Jahre";
    }

    public Map<Integer, String> model(HochOderNiedrigwasser hochOderNiedrigwasser, Spalte spalte) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        List<Optional<Extremwert>> werte = this.werteF\u00fcr(hochOderNiedrigwasser);
        IntStream.rangeClosed(1, 10).forEach(rank -> {
            Optional maybeExtremwert = (Optional)werte.get(rank - 1);
            if (maybeExtremwert.isPresent()) {
                Extremwert extremwert = (Extremwert)maybeExtremwert.get();
                result.put(rank, this.textFor(spalte, extremwert));
            } else {
                result.put(rank, this.formatierteWerte.zeichenF\u00fcrFehlendeWerte());
            }
        });
        return result;
    }

    private String textFor(Spalte spalte, Extremwert extremwert) {
        switch (spalte) {
            case Datum: {
                return Format.formatDay(extremwert.datum());
            }
            case Spende: {
                return this.formatierteWerte.nurSignifikanteStellenF\u00fcrSpende(extremwert.SpendeInLiterProQuadratkilometer());
            }
            case Wert: {
                return this.formatierteWerte.nurSignifikanteStellen(extremwert.wert(), extremwert.QoderW());
            }
            case Wasserstand: {
                if (this.QoderW.equals((Object)AbflussOderWasserstand.Q)) {
                    return this.formatierteWerte.nurSignifikanteStellen(extremwert.WasserstandInCm(), AbflussOderWasserstand.W);
                }
                return this.formatierteWerte.nurSignifikanteStellen(extremwert.wert(), this.QoderW);
            }
        }
        throw new IllegalStateException("Unexpected value: " + spalte);
    }

    private List<Optional<Extremwert>> werteF\u00fcr(HochOderNiedrigwasser hochOderNiedrigwasser) {
        switch (hochOderNiedrigwasser) {
            case Hochwasser: {
                return this.hochwasser;
            }
            case Niedrigwasser: {
                return this.niedrigwasser;
            }
        }
        throw new IllegalStateException("Unexpected value: " + hochOderNiedrigwasser);
    }

    private static List<Optional<Extremwert>> extendListToLength(List<Optional<Extremwert>> l2, int n2) {
        ArrayList<Optional<Extremwert>> result = new ArrayList<Optional<Extremwert>>();
        IntStream.range(0, n2).forEach(k2 -> {
            if (k2 < l2.size()) {
                result.add((Optional)l2.get(k2));
            } else {
                result.add(Optional.empty());
            }
        });
        return result;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Spalte {
        Wert{

            @Override
            String header(AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
                return QoderW.equals((Object)AbflussOderWasserstand.Q) ? "m\u00b3/s" : "cm";
            }
        }
        ,
        Spende{

            @Override
            String header(AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
                return "l/s km\u00b2";
            }
        }
        ,
        Wasserstand{

            @Override
            String header(AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
                return WasserstandBezugsh\u00f6he.einheitKurz(wasserstandBezugsh\u00f6he);
            }
        }
        ,
        Datum{

            @Override
            String header(AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
                return "Datum";
            }
        };


        abstract String header(AbflussOderWasserstand var1, WasserstandBezugsh\u00f6he var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HochOderNiedrigwasser {
        Hochwasser{

            @Override
            String header() {
                return "Hochwasser";
            }
        }
        ,
        Niedrigwasser{

            @Override
            String header() {
                return "Niedrigwasser";
            }
        };


        abstract String header();
    }
}

