/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.util.math;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.util.math.MaxFinder;

public class MinFinder<V extends TimestampedValue> {
    private final MaxFinder<V> finder = new MaxFinder((x2, y2) -> -comparator.compare(x2, y2));

    public MinFinder() {
        this(TimestampedValue::compareTo);
    }

    public MinFinder(Comparator<V> comparator) {
    }

    public MinFinder(Stream<V> values) {
        this();
        values.forEach(this::add);
    }

    public MinFinder<V> add(V value) {
        this.finder.add(value);
        return this;
    }

    public MinFinder<V> add(MinFinder<V> minFinder) {
        return this.addAll(minFinder.minima());
    }

    public MinFinder<V> addAll(Iterable<V> values) {
        this.finder.addAll(values);
        return this;
    }

    public List<V> minima() {
        return this.finder.maxima();
    }

    public Optional<V> min() {
        return this.finder.max();
    }
}

