/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.util.math;

import java.util.stream.Stream;
import luwa.marlin.ship_library.model.value.TimestampedValue;

public class Meaner<V extends TimestampedValue> {
    private double sum = 0.0;
    private int n = 0;

    public Meaner() {
    }

    public Meaner(Stream<V> values) {
        this();
        values.forEach(this::add);
    }

    public Meaner<V> add(V value) {
        if (null == value || ((TimestampedValue)value).istL\u00fccke()) {
            return this;
        }
        this.sum += ((TimestampedValue)value).wert();
        ++this.n;
        return this;
    }

    public Meaner<V> add(Meaner<V> meaner) {
        this.sum += meaner.sum;
        this.n += meaner.n;
        return this;
    }

    public Meaner<V> addAll(Iterable<V> values) {
        for (TimestampedValue value : values) {
            this.add(value);
        }
        return this;
    }

    public TimestampedValue mean() {
        return new TimestampedValue(null, this.sum / (double)this.n);
    }
}

