/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Locale;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import org.joda.time.DateTime;

public final class Format {
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMAN);
    private static final DateTimeFormatter dayFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter fullDayAndTimeFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
    private static final DateTimeFormatter shortDayFormat = DateTimeFormatter.ofPattern("d.");
    private static final DateTimeFormatter dayMonthFormat = DateTimeFormatter.ofPattern("d.MM.");
    private static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter hourFormat = DateTimeFormatter.ofPattern("H:mm");
    private static final DateTimeFormatter weekDayFormat = DateTimeFormatter.ofPattern("E").withLocale(Locale.GERMAN);

    public static String repeat(String string, int times) {
        if (null == string) {
            return null;
        }
        if (times < 0) {
            return "";
        }
        return string.repeat(times);
    }

    public static String formatNumber(double number) {
        return numberFormat.format(number);
    }

    public static DecimalFormat decimalFormatFor(String pattern) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.GERMANY);
        format.applyPattern(pattern);
        return format;
    }

    public static String formatDay(DateTime day) {
        return Format.formatDay(TimestampedValue.jodaDateTimeToZonedDateTime(day));
    }

    public static String formatDay(ZonedDateTime day) {
        if (null == day) {
            return "";
        }
        return dayFormat.format(day);
    }

    public static String formatFullDayAndTime(DateTime day) {
        return Format.formatFullDayAndTime(TimestampedValue.jodaDateTimeToZonedDateTime(day));
    }

    public static String formatFullDayAndTime(ZonedDateTime day) {
        return fullDayAndTimeFormat.format(day);
    }

    public static String formatShortDay(DateTime day) {
        return Format.formatShortDay(TimestampedValue.jodaDateTimeToZonedDateTime(day));
    }

    public static String formatShortDay(ZonedDateTime day) {
        return shortDayFormat.format(day);
    }

    public static String formatDayMonth(DateTime day) {
        return Format.formatDayMonth(TimestampedValue.jodaDateTimeToZonedDateTime(day));
    }

    public static String formatDayMonth(ZonedDateTime day) {
        return dayMonthFormat.format(day);
    }

    public static String formatTime(DateTime time) {
        return Format.formatTime(TimestampedValue.jodaDateTimeToZonedDateTime(time));
    }

    public static String formatTime(ZonedDateTime time) {
        return timeFormat.format(time);
    }

    public static String formatHour(DateTime time) {
        return Format.formatHour(TimestampedValue.jodaDateTimeToZonedDateTime(time));
    }

    public static String formatHour(ZonedDateTime time) {
        return hourFormat.format(time);
    }

    public static String formatWeekday(DateTime time) {
        return Format.formatWeekday(TimestampedValue.jodaDateTimeToZonedDateTime(time));
    }

    public static String formatWeekday(ZonedDateTime time) {
        return weekDayFormat.format(time);
    }

    public static String formatDrainageBasinSize(double drainageBasinSize) {
        if (drainageBasinSize >= 100.0) {
            return numberFormat.format(Math.round(drainageBasinSize));
        }
        if (drainageBasinSize >= 10.0) {
            return new DecimalFormat("#.0", DecimalFormatSymbols.getInstance(Locale.GERMAN)).format(drainageBasinSize);
        }
        return new DecimalFormat("#.00", DecimalFormatSymbols.getInstance(Locale.GERMAN)).format(drainageBasinSize);
    }

    public static String formatZeroPoint(double zeroPoint) {
        return new DecimalFormat("#.000", DecimalFormatSymbols.getInstance(Locale.GERMAN)).format(zeroPoint);
    }

    public static <T> String join(Iterable<T> objects, String separator) {
        StringBuilder b2 = new StringBuilder();
        Iterator<T> iter = objects.iterator();
        while (iter.hasNext()) {
            b2.append(iter.next());
            if (!iter.hasNext()) continue;
            b2.append(separator);
        }
        return b2.toString();
    }

    public static String nullSafeString(String s2) {
        if (null == s2) {
            return "";
        }
        return s2;
    }

    public static String nullSafeStringWittHalfedDoubleSpaces(String s2) {
        if (null == s2) {
            return "";
        }
        return s2.replace("  ", " ");
    }
}

