/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.repository.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import javax.measure.quantity.Speed;
import luwa.marlin.configuration.stammdaten.Stammdaten;
import luwa.marlin.configuration.stammdaten.StammdatenKonfiguration;
import luwa.marlin.ship_library.model.Abflusskurve;
import luwa.marlin.ship_library.model.Abflussmessung;
import luwa.marlin.ship_library.model.AbflussmessungErgebnisse;
import luwa.marlin.ship_library.model.Abflussnullpunkt;
import luwa.marlin.ship_library.model.AnzahlAbflussmessungen;
import luwa.marlin.ship_library.model.Aufl\u00f6sungsZeitbereich;
import luwa.marlin.ship_library.model.BearbeiteterZeitbereich;
import luwa.marlin.ship_library.model.Bearbeitungstyp;
import luwa.marlin.ship_library.model.Bemerkungstext;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Datenpr\u00fcfung;
import luwa.marlin.ship_library.model.Datenpr\u00fcfungTyp;
import luwa.marlin.ship_library.model.HandUndSystemWerte;
import luwa.marlin.ship_library.model.Kurveng\u00fcltigkeit;
import luwa.marlin.ship_library.model.Messart;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Messsystem;
import luwa.marlin.ship_library.model.Notizen;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Stundenmittelwerte;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.Verkettung;
import luwa.marlin.ship_library.model.ZeitbereicheMitErg\u00e4nztenWerten;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.Gepr\u00fcfteZeitbereiche;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.Gepr\u00fcfterZeitbereich;
import luwa.marlin.ship_library.model.units.Abfluss;
import luwa.marlin.ship_library.model.units.Abflussspende;
import luwa.marlin.ship_library.model.units.ProfilwertNachManningStrickler;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.Stundenmittelwert;
import luwa.marlin.ship_library.model.value.Tagesh\u00f6chstwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.value.WQPaar;
import luwa.marlin.ship_library.model.value.WQWert;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.HydrologicalHalfYear;
import luwa.marlin.ship_library.model.year.J\u00e4hrlichkeiten;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.sql.SQL\u00dcbersichtsRepository;
import luwa.marlin.ship_library.repository.\u00dcbersichtsRepository;
import luwa.marlin.ship_library.util.Benchmark;
import luwa.marlin.sql.SqlHelpers;
import luwa.marlin.time.Interval;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.Units;

public class SQLDatenRepository
implements DatenRepository {
    private static final TimeZone calendarTimeZone = TimeZone.getTimeZone("GMT+1:00");
    private static final DateTimeZone timeZone = DateTimeZone.forOffsetHours(1);
    private static final Stammdaten stammdaten = StammdatenKonfiguration.stammdaten();
    private final Connection connection;

    public SQLDatenRepository(Connection connection) {
        this.connection = connection;
    }

    @Override
    public Messstelle messstelle(long messstellenNummer) throws Exception {
        String sql = "SELECT   p.messtellen_nr,   gwd.gwd_langname AS betreiber,   gwb.gwb_langname AS dienstsitz,   p.standort,   p.gewaesser,   p.bearbeitungsgebiet,   p.flussgebiet,   p.lage_gewaesser,   " + stammdaten.lageName() + ",   p.entfernung_muendung,   p.einzugsgebiet_oberirdisch,   pnp.messtellen_nullpunkt,   p.pegeltyp, p.pegeltyp_nr,   p.messnetz,   p.betrieb_von_datum AS von,   p.betrieb_bis_datum AS bis,   " + stammdaten.landkreisName() + " FROM " + stammdaten.pegeldatenView() + " p   LEFT OUTER JOIN " + stammdaten.pegelnullpunktView() + " pnp ON p.messtellen_nr=pnp.messtellen_nr   LEFT OUTER JOIN sl_eigentuemer gwd ON p.gwd_nr=gwd.gwd_nr   LEFT OUTER JOIN v_pegeldaten_betreiber gwb ON p.gwb_nr=gwb.gwb_nr   " + stammdaten.joinLandkreis() + "  " + stammdaten.joinLage() + "WHERE p.messtellen_nr=? ORDER BY pnp.gueltig_von_datum DESC";
        try (PreparedStatement query = this.connection.prepareStatement(sql);){
            query.setLong(1, messstellenNummer);
            try (ResultSet rs = query.executeQuery();){
                if (rs.next()) {
                    Messstelle messstelle = SQLDatenRepository.messtelleAus(rs);
                    return messstelle;
                }
            }
        }
        return new Messstelle();
    }

    private static Messstelle messtelleAus(ResultSet rs) throws SQLException {
        Messstelle messstelle = new Messstelle();
        messstelle.setNummer(rs.getLong("messtellen_nr"));
        messstelle.setStandort(rs.getString("standort"));
        messstelle.setGew\u00e4sser(rs.getString("gewaesser"));
        messstelle.setBearbeitungsgebiet(rs.getString("bearbeitungsgebiet"));
        messstelle.setLageAmGew\u00e4sser(rs.getString("lage_gewaesser"));
        messstelle.setEntfernungZurM\u00fcndung(rs.getDouble("entfernung_muendung"));
        messstelle.setEinzugsgebiet(rs.getDouble("einzugsgebiet_oberirdisch"));
        messstelle.setPegelnullpunkt(rs.getDouble("messtellen_nullpunkt"));
        messstelle.setPegeltyp(rs.getString("pegeltyp"));
        messstelle.setPegeltypId(rs.getInt("pegeltyp_nr"));
        messstelle.setFlussgebiet(rs.getString("flussgebiet"));
        messstelle.setBetreiber(rs.getString("betreiber"));
        messstelle.setDienstsitz(rs.getString("dienstsitz"));
        messstelle.setLandkreis(rs.getString("landkreis"));
        messstelle.setMessnetz(rs.getString("messnetz"));
        messstelle.setErbautAm(new DateTime((Object)rs.getTimestamp("von", SQLDatenRepository.calendar()), timeZone));
        messstelle.setAufgehobenAm(rs.getTimestamp("bis", SQLDatenRepository.calendar()) == null ? null : new DateTime((Object)rs.getTimestamp("bis", SQLDatenRepository.calendar()), timeZone));
        return messstelle;
    }

    public List<Long> aktiveLandespegel() {
        return this.messstellenNummernF\u00fcr("messnetz_nr=1 AND status IN (1, 4, 5, 6)", "aktive Landespegel");
    }

    public List<Long> alleAktivenUndTeilaktivenPegel() {
        return this.messstellenNummernF\u00fcr("status IN (1, 4, 5, 6)", "alle Pegel");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Long> messstellenNummernF\u00fcr(String whereClause, String bezeichnungF\u00fcrLogausgabe) {
        try {
            String sql = "SELECT messtellen_nr FROM " + stammdaten.pegeldatenView() + " WHERE (" + whereClause + ") ORDER BY messtellen_nr";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                ArrayList<Long> arrayList;
                block15: {
                    ResultSet rs = query.executeQuery();
                    try {
                        ArrayList<Long> messtellennummern = new ArrayList<Long>();
                        while (rs.next()) {
                            messtellennummern.add(rs.getLong("messtellen_nr"));
                        }
                        arrayList = messtellennummern;
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte " + bezeichnungF\u00fcrLogausgabe + " nicht aus der Datenbank laden", e2);
        }
    }

    @Override
    public Ausfalljahre ausfalljahre(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval) throws Exception {
        Ausfalljahre ausfalljahre = new Ausfalljahre();
        Benchmark.benchmark("Laden der Ausfalljahre f\u00fcr " + parameter.symbol(), () -> {
            String sql = "SELECT DISTINCT    to_number(to_char(zeit, 'MM'), '99999999999999') AS month,    to_number(to_char(zeit, 'YYYY'), '99999999999999') AS year  FROM " + parameter.table_tagesmittel() + " WHERE    zeit>=? AND zeit<? AND    messtellen_nr=? AND    " + parameter.valueColumnName() + " IS NULL";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                query.setTimestamp(1, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                query.setTimestamp(2, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                query.setLong(3, messstellenNummer);
                try (ResultSet resultSet = query.executeQuery();){
                    while (resultSet.next()) {
                        YearMonth ausfallmonat = new YearMonth(resultSet.getInt("year"), resultSet.getInt("month"));
                        ausfalljahre.add(ausfallmonat.abflussjahr());
                    }
                }
            }
            Optional<org.joda.time.Interval> datenVorhanden = this.zeitraumDatenVorhanden(messstellenNummer, parameter);
            datenVorhanden.ifPresent(zeitraum -> {
                if (zeitraum.getStart().isAfter(interval.getStart())) {
                    ausfalljahre.add(new Abflussjahr(zeitraum.getStart().getYear()));
                }
                if (zeitraum.getEnd().isBefore(interval.getEnd())) {
                    YearMonth ausfallmonat = new YearMonth(zeitraum.getEnd().getYear(), zeitraum.getEnd().getMonthOfYear());
                    ausfalljahre.add(ausfallmonat.abflussjahr());
                }
            });
        });
        return ausfalljahre;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<org.joda.time.Interval> zeitraumDatenVorhanden(long messstellenNummer, Parameter parameter) {
        try {
            String sql = "SELECT min(zeit) AS beginn, max(zeit) AS ende  FROM " + parameter.table_tagesmittel() + " WHERE messtellen_nr=?";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                query.setLong(1, messstellenNummer);
                try (ResultSet resultSet = query.executeQuery();){
                    if (!resultSet.next()) return Optional.empty();
                    DateTime beginn = new DateTime((Object)resultSet.getTimestamp("beginn", SQLDatenRepository.calendar()), timeZone);
                    DateTime ende = new DateTime((Object)resultSet.getTimestamp("ende", SQLDatenRepository.calendar()), timeZone).withTime(23, 59, 59, 999);
                    Optional<org.joda.time.Interval> optional = Optional.of(new org.joda.time.Interval((ReadableInstant)beginn, (ReadableInstant)ende));
                    return optional;
                }
            }
        }
        catch (SQLException e2) {
            throw new RuntimeException("Konnte Zeitraum vorhandener " + parameter.symbol() + "-Daten f\u00fcr Messstelle " + messstellenNummer + " nicht laden", e2);
        }
    }

    @Override
    public List<TimestampedValue> l\u00fccken(long messstellenNummer, Parameter parameter) throws Exception {
        ArrayList<TimestampedValue> fehlwerte = new ArrayList<TimestampedValue>();
        Benchmark.benchmark("Laden der L\u00fccken " + parameter.symbol(), () -> {
            String sql = "SELECT zeit FROM " + parameter.table() + " WHERE messtellen_nr=? AND " + parameter.valueColumnName() + " IS NULL ORDER BY zeit ASC";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                query.setLong(1, messstellenNummer);
                try (ResultSet rs = query.executeQuery();){
                    while (rs.next()) {
                        DateTime zeit = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        fehlwerte.add(new TimestampedValue(zeit));
                    }
                }
            }
        });
        return fehlwerte;
    }

    @Override
    public List<Aufl\u00f6sungsZeitbereich> aufl\u00f6sungen(long messstellenNummer) throws Exception {
        ArrayList<Aufl\u00f6sungsZeitbereich> aufl\u00f6sungen = new ArrayList<Aufl\u00f6sungsZeitbereich>();
        Benchmark.benchmark("Laden der Aufl\u00f6sungen", () -> {
            String sql = "SELECT von, bis, raster_minuten FROM aufloesungen WHERE messtellen_nr=? ORDER BY bis ASC";
            try (PreparedStatement query = this.connection.prepareStatement("SELECT von, bis, raster_minuten FROM aufloesungen WHERE messtellen_nr=? ORDER BY bis ASC");){
                query.setLong(1, messstellenNummer);
                try (ResultSet rs = query.executeQuery();){
                    while (rs.next()) {
                        DateTime from = rs.getTimestamp("von", SQLDatenRepository.calendar()) != null ? new DateTime((Object)rs.getTimestamp("von", SQLDatenRepository.calendar()), timeZone) : null;
                        DateTime to = rs.getTimestamp("bis", SQLDatenRepository.calendar()) != null ? new DateTime((Object)rs.getTimestamp("bis", SQLDatenRepository.calendar()), timeZone) : null;
                        int minutes = rs.getInt("raster_minuten");
                        aufl\u00f6sungen.add(new Aufl\u00f6sungsZeitbereich(from, to, minutes));
                    }
                }
            }
        });
        return aufl\u00f6sungen;
    }

    @Override
    public org.joda.time.Interval datenbestand(long messstellenNummer, Parameter parameter) throws Exception {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT min(zeit) as von, max(zeit) as bis from " + parameter.table_tagesmittel() + " where messtellen_nr=?");){
            stmt.setLong(1, messstellenNummer);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    DateTime from = new DateTime((Object)rs.getTimestamp("von", SQLDatenRepository.calendar()), timeZone);
                    DateTime to = new DateTime((Object)rs.getTimestamp("bis", SQLDatenRepository.calendar()), timeZone);
                    org.joda.time.Interval interval = new org.joda.time.Interval((ReadableInstant)from, (ReadableInstant)to);
                    return interval;
                }
            }
        }
        return null;
    }

    @Override
    public Stundenmittelwerte stundenmittelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        Stundenmittelwerte werte = new Stundenmittelwerte(nhnTransformation);
        String spalteWert = parameter.valueColumnName();
        String sql = "SELECT zeit, ? * " + spalteWert + " AS " + spalteWert + "  FROM " + parameter.table_stundenmittel() + "  WHERE zeit>=? AND zeit<? AND messtellen_nr=?   ORDER BY zeit ASC";
        Benchmark.benchmark("Laden der Stundenmittelwerte f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                query.setFetchSize(1000);
                query.setDouble(1, factor);
                query.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                query.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                query.setLong(4, messstellenNummer);
                try (ResultSet rs = query.executeQuery();){
                    while (rs.next()) {
                        DateTime zeit = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double wert = rs.getDouble(spalteWert);
                        if (!rs.wasNull()) {
                            Stundenmittelwert stundenmittelwert = new Stundenmittelwert(zeit, wert);
                            if (ausfalljahre.contain(stundenmittelwert)) continue;
                            werte.add(stundenmittelwert);
                            continue;
                        }
                        Stundenmittelwert l\u00fccke = new Stundenmittelwert(zeit, Double.NaN);
                        if (ausfalljahre.contain(l\u00fccke)) continue;
                        werte.add(l\u00fccke);
                    }
                }
            }
        });
        return werte;
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor, Comparator<Tagesmittelwert> comparator) throws Exception {
        return this.tagesmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, parameter.table_tagesmittel(), factor, comparator, NHNTransformationOfTimestampedValues.doNothing());
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues maybeNHNTransform, Comparator<Tagesmittelwert> comparator) throws Exception {
        return this.tagesmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, parameter.table_tagesmittel(), factor, comparator, maybeNHNTransform);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor) throws Exception {
        return this.tagesmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, NHNTransformationOfTimestampedValues.doNothing(), TimestampedValue::compareTo);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Ausfalljahre ausfalljahre) throws Exception {
        return this.tagesmittelwerte(messstellenNummer, parameter, ausfalljahre, TimestampedValue::compareTo);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Ausfalljahre ausfalljahre, Comparator<Tagesmittelwert> comparator) throws Exception {
        Tagesmittelwerte values = new Tagesmittelwerte(comparator);
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der Tagesmittelwerte f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, " + valueColumnName + " from " + parameter.table_tagesmittel() + " where messtellen_nr=? order by zeit asc");){
                stmt.setFetchSize(40000);
                stmt.setLong(1, messstellenNummer);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double stage = rs.getDouble(valueColumnName);
                        if (!rs.wasNull()) {
                            Tagesmittelwert value1 = new Tagesmittelwert(timestamp, stage);
                            if (ausfalljahre.contain(value1)) continue;
                            values.add(value1);
                            continue;
                        }
                        Tagesmittelwert value2 = new Tagesmittelwert(timestamp, Double.NaN);
                        if (ausfalljahre.contain(value2)) continue;
                        values.add(value2);
                    }
                }
            }
        });
        return values;
    }

    @Override
    public List<TimestampedValue> stunden15MinutenMittelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.hour15minMeanValues(messstellenNummer, parameter, interval, parameter.table(), factor, transformation);
    }

    private List<TimestampedValue> hour15minMeanValues(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, String tableName, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        ArrayList<TimestampedValue> values = new ArrayList<TimestampedValue>();
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der Stunden/15min-Werte f\u00fcr  " + parameter.symbol(), () -> {
            String sql = "SELECT zeit, ? * " + valueColumnName + " AS " + valueColumnName + " FROM " + tableName + " WHERE zeit BETWEEN ? AND ? AND messtellen_nr=? ORDER BY zeit ASC";
            try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
                stmt.setFetchSize(40000);
                stmt.setDouble(1, factor);
                stmt.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                stmt.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                stmt.setLong(4, messstellenNummer);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double stage = rs.getDouble(valueColumnName);
                        if (!rs.wasNull()) {
                            values.add(transformation.forValue(new TimestampedValue(timestamp, stage)));
                            continue;
                        }
                        values.add(transformation.forValue(new TimestampedValue(timestamp)));
                    }
                }
            }
        });
        return values;
    }

    private Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, String tableName, double factor, Comparator<Tagesmittelwert> comparator, NHNTransformationOfTimestampedValues transformation) throws Exception {
        Tagesmittelwerte values = new Tagesmittelwerte(comparator, transformation);
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der Tagesmittelwerte f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, ? * " + valueColumnName + " as " + valueColumnName + " from " + tableName + " where zeit >= ? and zeit < ? and messtellen_nr=? order by zeit asc");){
                stmt.setFetchSize(40000);
                stmt.setDouble(1, factor);
                stmt.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                if (interval.getEnd().isBefore(new DateTime(timeZone).withTimeAtStartOfDay())) {
                    stmt.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                } else {
                    stmt.setTimestamp(3, this.timestamp(new DateTime(timeZone).withTimeAtStartOfDay()), SQLDatenRepository.calendar());
                }
                stmt.setLong(4, messstellenNummer);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double stage = rs.getDouble(valueColumnName);
                        if (!rs.wasNull()) {
                            Tagesmittelwert value1 = new Tagesmittelwert(timestamp, stage);
                            if (ausfalljahre.contain(value1)) continue;
                            values.add(value1);
                            continue;
                        }
                        Tagesmittelwert value2 = new Tagesmittelwert(timestamp, Double.NaN);
                        if (ausfalljahre.contain(value2)) continue;
                        values.add(value2);
                    }
                }
            }
        });
        return values;
    }

    @Override
    public Tagesh\u00f6chstwerte tagesh\u00f6chstwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        return this.tagesh\u00f6chstwerte(messstellenNummer, parameter, interval, ausfalljahre, parameter.table_max(), factor, nhnTransformation);
    }

    private Tagesh\u00f6chstwerte tagesh\u00f6chstwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, String tableName, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        Tagesh\u00f6chstwerte values = new Tagesh\u00f6chstwerte(nhnTransformation);
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der Tagesmaxima f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, ? * " + valueColumnName + " as " + valueColumnName + " from " + tableName + " where zeit >= ? and zeit < ? and messtellen_nr=? order by zeit asc");){
                stmt.setDouble(1, factor);
                stmt.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                stmt.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                stmt.setLong(4, messstellenNummer);
                stmt.setFetchSize(40000);
                try (ResultSet rs = stmt.executeQuery();){
                    Day lastValueDay = null;
                    while (rs.next()) {
                        Tagesh\u00f6chstwert value;
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double stage = rs.getDouble(valueColumnName);
                        if (rs.wasNull() || ausfalljahre.contain(value = new Tagesh\u00f6chstwert(timestamp, stage))) continue;
                        Day currentValueDay = new Day(timestamp);
                        this.fillDayMaxGapsBetween(values, lastValueDay, currentValueDay);
                        values.add(value);
                        lastValueDay = currentValueDay;
                    }
                }
            }
        });
        return values;
    }

    private void fillDayMaxGapsBetween(Tagesh\u00f6chstwerte values, Day start, Day end) {
        if (null == start) {
            return;
        }
        Day day = start.successor();
        while (day.isBefore(end)) {
            values.add(new Tagesh\u00f6chstwert(day.dateTime(), null));
            day = day.successor();
        }
    }

    private void fillPeakGapsBetween(Scheitelwerte values, HydrologicalHalfYear start, HydrologicalHalfYear end) {
        if (null == start) {
            return;
        }
        HydrologicalHalfYear day = start.successor();
        while (day.isBefore(end)) {
            values.add(new Scheitelwert(day.dateTime(), Optional.empty()));
            day = day.successor();
        }
    }

    @Override
    public Scheitelwerte scheitelwerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        Scheitelwerte values = new Scheitelwerte(nhnTransformation);
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der Scheitelwerte f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, ? * " + valueColumnName + " as " + valueColumnName + " from " + parameter.table_scheitel() + " where zeit >= ? and zeit < ? and messtellen_nr=? order by zeit asc");){
                stmt.setDouble(1, factor);
                stmt.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                stmt.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                stmt.setLong(4, messstellenNummer);
                stmt.setFetchSize(1000);
                try (ResultSet rs = stmt.executeQuery();){
                    HydrologicalHalfYear lastHalfYear = null;
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        Optional<Double> value = SQLDatenRepository.getNullableDouble(rs, valueColumnName);
                        Scheitelwert scheitelwert = new Scheitelwert(timestamp, value);
                        HydrologicalHalfYear currentHalfYear = new HydrologicalHalfYear(timestamp);
                        if (ausfalljahre.contain(timestamp)) continue;
                        this.fillPeakGapsBetween(values, lastHalfYear, currentHalfYear);
                        values.add(scheitelwert);
                        lastHalfYear = currentHalfYear;
                    }
                    this.fillPeakGapsBetween(values, lastHalfYear, new HydrologicalHalfYear(interval.getEnd()));
                }
            }
        });
        return values;
    }

    @Override
    public Scheitelwerte scheitelwertL\u00fccken(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        List<Scheitelwert> peaks = this.scheitelwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation).values();
        return new Scheitelwerte(peaks.stream().filter(TimestampedValue::istL\u00fccke).collect(Collectors.toList()));
    }

    @Override
    public Scheitelwerte scheitelwerte(long messstellenNummer, Parameter parameter, Ausfalljahre ausfalljahre) throws Exception {
        Scheitelwerte values = new Scheitelwerte();
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der Scheitelwerte f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, " + valueColumnName + " from " + parameter.table_scheitel() + " where messtellen_nr=? order by zeit asc");){
                stmt.setLong(1, messstellenNummer);
                stmt.setFetchSize(1000);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        Scheitelwert value;
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double stage = rs.getDouble(valueColumnName);
                        if (rs.wasNull() || ausfalljahre.contain(value = new Scheitelwert(timestamp, (Double)stage))) continue;
                        values.add(value);
                    }
                }
            }
        });
        return values;
    }

    @Override
    public List<TimestampedValue> stunden15MinutenMittelwerte_redundanz(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.hour15minMeanValues(messstellenNummer, parameter, interval, parameter.table_redundanz(), 1.0, transformation);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte_redundanz(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.tagesmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, parameter.table_tagesmittel_redundanz(), 1.0, TimestampedValue::compareTo, transformation);
    }

    @Override
    public Tagesh\u00f6chstwerte tagesh\u00f6chstwerte_redundanz(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.tagesh\u00f6chstwerte(messstellenNummer, parameter, interval, ausfalljahre, parameter.table_max_redundanz(), 1.0, transformation);
    }

    @Override
    public List<TimestampedValue> werteUnbearbeitetHauptsystem(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.hour15minMeanValues(messstellenNummer, parameter, interval, parameter.table_haupt(), factor, transformation);
    }

    @Override
    public List<TimestampedValue> werteUnbearbeitetRedundanzsystem(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.hour15minMeanValues(messstellenNummer, parameter, interval, parameter.table_redundanz(), factor, transformation);
    }

    @Override
    public List<TimestampedValue> werteFehlendeAbfl\u00fcsse(long messstellenNummer, org.joda.time.Interval interval) {
        try {
            ArrayList<TimestampedValue> werte = new ArrayList<TimestampedValue>();
            String sql = "SELECT w.messtellen_nr, w.zeit, w.w, q.q FROM q LEFT OUTER JOIN w ON w.messtellen_nr=q.messtellen_nr AND w.zeit=q.zeit WHERE   w.messtellen_nr=? AND   w.zeit BETWEEN ? AND ? AND   w.w IS NOT NULL AND   q.q IS NULL  ORDER BY w.zeit ASC";
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT w.messtellen_nr, w.zeit, w.w, q.q FROM q LEFT OUTER JOIN w ON w.messtellen_nr=q.messtellen_nr AND w.zeit=q.zeit WHERE   w.messtellen_nr=? AND   w.zeit BETWEEN ? AND ? AND   w.w IS NOT NULL AND   q.q IS NULL  ORDER BY w.zeit ASC");){
                stmt.setFetchSize(40000);
                stmt.setLong(1, messstellenNummer);
                stmt.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                stmt.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double W = rs.getDouble("w");
                        if (!rs.wasNull()) {
                            werte.add(new TimestampedValue(timestamp, W));
                            continue;
                        }
                        werte.add(new TimestampedValue(timestamp));
                    }
                }
            }
            return werte;
        }
        catch (SQLException e2) {
            throw new RuntimeException("Konnte fehlende Abfl\u00fcsse f\u00fcr " + messstellenNummer + " nicht aus SQL-Datenbank laden");
        }
    }

    @Override
    public HandUndSystemWerte handUndSystemWerte(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval) throws Exception {
        List<TimestampedValue> handValues = this.handOrSystemValues(messstellenNummer, parameter, parameter.table_hand(), interval);
        List<TimestampedValue> systemValues = this.handOrSystemValues(messstellenNummer, parameter, parameter.table_system(), interval);
        return this.combineHandAndSystemValues(handValues, systemValues);
    }

    @Override
    public HandUndSystemWerte handUndSystemWerte_redundanz(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval) throws Exception {
        List<TimestampedValue> handValues = this.handOrSystemValues(messstellenNummer, parameter, parameter.table_hand_redundanz(), interval);
        List<TimestampedValue> systemValues = this.handOrSystemValues(messstellenNummer, parameter, parameter.table_system_redundanz(), interval);
        return this.combineHandAndSystemValues(handValues, systemValues);
    }

    private HandUndSystemWerte combineHandAndSystemValues(List<TimestampedValue> handValues, List<TimestampedValue> systemValues) {
        HandUndSystemWerte result = new HandUndSystemWerte();
        for (TimestampedValue value : handValues) {
            result.addHandValue(value.timestamp(), value.wert());
        }
        for (TimestampedValue value : systemValues) {
            result.addSystemValue(value.timestamp(), value.wert());
        }
        return result;
    }

    private List<TimestampedValue> handOrSystemValues(long messstellenNummer, Parameter parameter, String tableName, org.joda.time.Interval interval) throws Exception {
        ArrayList<TimestampedValue> values = new ArrayList<TimestampedValue>();
        String valueColumnName = parameter.valueColumnName();
        Benchmark.benchmark("Laden der " + tableName + " Werte f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, " + valueColumnName + " from " + tableName + " where zeit >= ? and zeit < ? and messtellen_nr=? order by zeit asc");){
                stmt.setTimestamp(1, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                stmt.setTimestamp(2, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                stmt.setLong(3, messstellenNummer);
                stmt.setFetchSize(1000);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone).withSecondOfMinute(0).withMillisOfSecond(0);
                        double value = rs.getDouble(valueColumnName);
                        if (rs.wasNull()) continue;
                        values.add(new TimestampedValue(timestamp, value));
                    }
                }
            }
        });
        return values;
    }

    @Override
    public Notizen notizen(long messstellenNummer, org.joda.time.Interval zeitbereich) throws Exception {
        Notizen notizen = new Notizen();
        notizen.addAll(this.notizenF\u00fcrMesssystem(messstellenNummer, zeitbereich, Messsystem.haupt));
        notizen.addAll(this.notizenF\u00fcrMesssystem(messstellenNummer, zeitbereich, Messsystem.redundanz));
        return notizen;
    }

    private Notizen notizenF\u00fcrMesssystem(long messstellenNummer, org.joda.time.Interval zeitbereich, Messsystem messsystem) throws Exception {
        Notizen notizen = new Notizen();
        try (PreparedStatement query = this.connection.prepareStatement("SELECT zeit, notiz, notiztext from " + messsystem.pegelnotizTabellenname() + " where zeit >= ? and zeit < ? and messtellen_nr=? order by zeit asc");){
            query.setTimestamp(1, this.timestamp(zeitbereich.getStart()), SQLDatenRepository.calendar());
            query.setTimestamp(2, this.timestamp(zeitbereich.getEnd()), SQLDatenRepository.calendar());
            query.setLong(3, messstellenNummer);
            try (ResultSet rs = query.executeQuery();){
                while (rs.next()) {
                    DateTime zeit = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                    int nummer = rs.getInt("notiz");
                    String text = rs.getString("notiztext");
                    notizen.addNotiz(zeit, nummer, text, messsystem);
                }
            }
        }
        return notizen;
    }

    @Override
    public Gepr\u00fcfteZeitbereiche gepr\u00fcfteZeitbereiche(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval) throws Exception {
        Timestamp start = this.timestamp(interval.getStart());
        Timestamp end = this.timestamp(interval.getEnd());
        ArrayList<Gepr\u00fcfterZeitbereich> ranges = new ArrayList<Gepr\u00fcfterZeitbereich>();
        Benchmark.benchmark("Laden der gepr\u00fcften Zeitbereiche f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("select von, bis from " + parameter.table_pruefung() + " where messtellen_nr=? and ((von >= ? and von < ?) or (bis >= ? and bis < ?) or (von <= ? and bis >=?)) order by von asc");){
                stmt.setLong(1, messstellenNummer);
                stmt.setTimestamp(2, start, SQLDatenRepository.calendar());
                stmt.setTimestamp(3, end, SQLDatenRepository.calendar());
                stmt.setTimestamp(4, start, SQLDatenRepository.calendar());
                stmt.setTimestamp(5, end, SQLDatenRepository.calendar());
                stmt.setTimestamp(6, start, SQLDatenRepository.calendar());
                stmt.setTimestamp(7, end, SQLDatenRepository.calendar());
                stmt.setFetchSize(100);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime von = new DateTime((Object)rs.getTimestamp("von", SQLDatenRepository.calendar()), timeZone);
                        DateTime bis = new DateTime((Object)rs.getTimestamp("bis", SQLDatenRepository.calendar()), timeZone);
                        ranges.add(new Gepr\u00fcfterZeitbereich(von, bis));
                    }
                }
            }
        });
        return new Gepr\u00fcfteZeitbereiche(ranges);
    }

    @Override
    public List<Pegelnullpunkt> pegelnullpunkte(long messstellenNummer) throws Exception {
        ArrayList<Pegelnullpunkt> points = new ArrayList<Pegelnullpunkt>();
        Benchmark.benchmark("Laden der Pegelnullpunkte", () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("select gueltig_von_datum, messtellen_nullpunkt, vermessungssystem, dimension, nullpunkt_nhn_hs170 from " + stammdaten.pegelnullpunktView() + " where messtellen_nr=? order by gueltig_von_datum asc");){
                stmt.setLong(1, messstellenNummer);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        ZonedDateTime validFrom = SqlHelpers.getDateTime(rs, "gueltig_von_datum");
                        double \u00fcberNN = rs.getDouble("messtellen_nullpunkt");
                        String einheit = rs.getString("dimension");
                        String h\u00f6hensystem = rs.getString("vermessungssystem");
                        double \u00fcberNHNinHS170 = rs.getDouble("nullpunkt_nhn_hs170");
                        if (rs.wasNull()) {
                            points.add(new Pegelnullpunkt(validFrom, \u00fcberNN, einheit, h\u00f6hensystem));
                            continue;
                        }
                        points.add(new Pegelnullpunkt(validFrom, \u00fcberNN, einheit, h\u00f6hensystem, \u00fcberNHNinHS170));
                    }
                }
            }
        });
        return points;
    }

    @Override
    public List<Abflussnullpunkt> abflussnullpunkte(long messstellenNummer) throws Exception {
        ArrayList<Abflussnullpunkt> points = new ArrayList<Abflussnullpunkt>();
        Benchmark.benchmark("Laden der Abflussnullpunkte", () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT gueltig_von_datum, abflussnull_entspricht_w from " + stammdaten.abflussnullpunktView() + " where MESSTELLEN_NR=? order by gueltig_von_datum asc");){
                stmt.setLong(1, messstellenNummer);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        ZonedDateTime validFrom = SqlHelpers.getDateTime(rs, "gueltig_von_datum");
                        ComparableQuantity<Length> zeroCorrespondsToW = Quantities.getQuantity(rs.getDouble("abflussnull_entspricht_w"), MetricPrefix.CENTI(Units.METRE));
                        points.add(new Abflussnullpunkt(validFrom, zeroCorrespondsToW));
                    }
                }
            }
        });
        return points;
    }

    @Override
    public ZeitbereicheMitErg\u00e4nztenWerten bearbeiteteZeitbereiche(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval) throws Exception {
        if (parameter == Parameter.q) {
            ZeitbereicheMitErg\u00e4nztenWerten wEdits = this.editedRangesOnlyForParameter(messstellenNummer, Parameter.w, interval);
            ZeitbereicheMitErg\u00e4nztenWerten qEdits = this.editedRangesOnlyForParameter(messstellenNummer, Parameter.q, interval);
            return wEdits.combinedWith(qEdits);
        }
        return this.editedRangesOnlyForParameter(messstellenNummer, parameter, interval);
    }

    private ZeitbereicheMitErg\u00e4nztenWerten editedRangesOnlyForParameter(long messstellenNummer, Parameter parameter, org.joda.time.Interval interval) throws Exception {
        ArrayList<BearbeiteterZeitbereich> bearbeiteteZeitbereiche = new ArrayList<BearbeiteterZeitbereich>();
        Timestamp start = this.timestamp(interval.getStart());
        Timestamp end = this.timestamp(interval.getEnd());
        Benchmark.benchmark("Laden der bearbeiteten Zeitbereiche f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT beginn, ende, angelegt_am, typ, zusatz_parameter from " + parameter.table_updates() + " where messtellen_nr=? and reihe=? and ((beginn >= ? and beginn < ?) or (ende >= ? and ende < ?) or (beginn <= ? and ende >=?)) order by angelegt_am desc");){
                stmt.setLong(1, messstellenNummer);
                stmt.setString(2, parameter.updates_reihe());
                stmt.setTimestamp(3, start, SQLDatenRepository.calendar());
                stmt.setTimestamp(4, end, SQLDatenRepository.calendar());
                stmt.setTimestamp(5, start, SQLDatenRepository.calendar());
                stmt.setTimestamp(6, end, SQLDatenRepository.calendar());
                stmt.setTimestamp(7, start, SQLDatenRepository.calendar());
                stmt.setTimestamp(8, end, SQLDatenRepository.calendar());
                stmt.setFetchSize(100);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime from = new DateTime((Object)rs.getTimestamp("beginn", SQLDatenRepository.calendar()), timeZone);
                        DateTime to = new DateTime((Object)rs.getTimestamp("ende", SQLDatenRepository.calendar()), timeZone);
                        DateTime editDate = new DateTime((Object)rs.getTimestamp("angelegt_am", SQLDatenRepository.calendar()), timeZone);
                        String typeKey = rs.getString("typ");
                        String additionalParameter = rs.getString("zusatz_parameter");
                        Bearbeitungstyp type = SQLDatenRepository.editedRangeTypeFrom(typeKey, additionalParameter);
                        bearbeiteteZeitbereiche.add(new BearbeiteterZeitbereich(new org.joda.time.Interval((ReadableInstant)from, (ReadableInstant)to), editDate, type));
                    }
                }
            }
        });
        return new ZeitbereicheMitErg\u00e4nztenWerten(bearbeiteteZeitbereiche);
    }

    @Override
    public List<Verkettung> verkettungen(long messstellenNummer) throws Exception {
        ArrayList<Verkettung> result = new ArrayList<Verkettung>();
        String sql = "select von, bis, formel, faktor, scheitel  from q_verkettung  where messtellen_nr=?  order by von asc";
        try (PreparedStatement query = this.connection.prepareStatement("select von, bis, formel, faktor, scheitel  from q_verkettung  where messtellen_nr=?  order by von asc");){
            query.setLong(1, messstellenNummer);
            try (ResultSet rs = query.executeQuery();){
                while (rs.next()) {
                    long messstellenNummerF\u00fcrScheitelwerte = rs.getLong("scheitel");
                    if (rs.wasNull()) {
                        messstellenNummerF\u00fcrScheitelwerte = messstellenNummer;
                    }
                    result.add(new Verkettung(new DateTime((Object)rs.getTimestamp("von", SQLDatenRepository.calendar()), timeZone), new DateTime((Object)rs.getTimestamp("bis", SQLDatenRepository.calendar()), timeZone), rs.getString("formel"), rs.getDouble("faktor"), messstellenNummerF\u00fcrScheitelwerte));
                }
            }
        }
        return result;
    }

    @Override
    public Abflusskurve abflusskurve(long abflusskurvenId) throws Exception {
        ArrayList<WQWert> values = new ArrayList<WQWert>();
        int station = -1;
        String name = "";
        try (PreparedStatement s2 = this.connection.prepareStatement("select k.messtellen_nr, k.kurve as name, w.w, w.q from ak k left outer join ak_wert w on k.id=w.kurve where k.id=? order by w.w asc");){
            s2.setLong(1, abflusskurvenId);
            try (ResultSet rs = s2.executeQuery();){
                while (rs.next()) {
                    station = rs.getInt("messtellen_nr");
                    name = rs.getString("name");
                    ComparableQuantity<Length> W = Quantities.getQuantity(rs.getDouble("w"), MetricPrefix.CENTI(Units.METRE));
                    ComparableQuantity<Abfluss> Q = Quantities.getQuantity(rs.getDouble("q"), luwa.marlin.ship_library.model.units.Units.CUBIC_METRE_PER_SECOND);
                    values.add(new WQWert(W, Q));
                }
            }
        }
        return new Abflusskurve(station, name, values);
    }

    @Override
    public List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeitenF\u00fcrMessstelle(long messstellenNummer) throws Exception {
        try (PreparedStatement query = this.connection.prepareStatement("select k1.kurve as kurve, k2.kurve as zu_kurve, g.von, g.bis, g.bemerkung from ak_gueltigkeit g left outer join ak k1 on g.kurve=k1.id left outer join ak k2 on g.zu_kurve=k2.id where g.messtellen_nr=? order by g.von desc");){
            ArrayList<Kurveng\u00fcltigkeit> arrayList;
            block13: {
                query.setLong(1, messstellenNummer);
                ResultSet rs = query.executeQuery();
                try {
                    ArrayList<Kurveng\u00fcltigkeit> g\u00fcltigkeiten = new ArrayList<Kurveng\u00fcltigkeit>();
                    while (rs.next()) {
                        g\u00fcltigkeiten.add(SQLDatenRepository.kurveng\u00fcltigkeitAus(rs));
                    }
                    arrayList = g\u00fcltigkeiten;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeitenF\u00fcrAbflusskurve(long abflusskurvenId) throws Exception {
        try (PreparedStatement query = this.connection.prepareStatement("select k1.kurve as kurve, k2.kurve as zu_kurve, g.von, g.bis, g.bemerkung from ak_gueltigkeit g left outer join ak k1 on g.kurve=k1.id left outer join ak k2 on g.zu_kurve=k2.id where g.kurve=? or g.zu_kurve=? order by g.von desc");){
            ArrayList<Kurveng\u00fcltigkeit> arrayList;
            block13: {
                query.setLong(1, abflusskurvenId);
                query.setLong(2, abflusskurvenId);
                ResultSet rs = query.executeQuery();
                try {
                    ArrayList<Kurveng\u00fcltigkeit> g\u00fcltigkeiten = new ArrayList<Kurveng\u00fcltigkeit>();
                    while (rs.next()) {
                        g\u00fcltigkeiten.add(SQLDatenRepository.kurveng\u00fcltigkeitAus(rs));
                    }
                    arrayList = g\u00fcltigkeiten;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    @Override
    public Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeitVon(long abflusskurvenId) throws Exception {
        return this.letzteG\u00fcltigkeit(this.kurveng\u00fcltigkeitenF\u00fcrAbflusskurve(abflusskurvenId));
    }

    private static Kurveng\u00fcltigkeit kurveng\u00fcltigkeitAus(ResultSet resultSet) throws SQLException {
        DateTime von = new DateTime((Object)resultSet.getTimestamp("von", SQLDatenRepository.calendar()), timeZone);
        Optional<DateTime> bis = SQLDatenRepository.getNullableDateTime(resultSet, "bis");
        String kurvenname = resultSet.getString("kurve");
        String \u00fcbergangZu = resultSet.getString("zu_kurve");
        return new Kurveng\u00fcltigkeit(von, bis, kurvenname, \u00fcbergangZu);
    }

    private Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeit(List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeiten) {
        Kurveng\u00fcltigkeit letzte;
        if (kurveng\u00fcltigkeiten.isEmpty()) {
            return Optional.empty();
        }
        kurveng\u00fcltigkeiten.sort((o1, o2) -> -1 * o1.von().compareTo(o2.von()));
        Kurveng\u00fcltigkeit kurveng\u00fcltigkeitStart = letzte = kurveng\u00fcltigkeiten.get(0);
        for (Kurveng\u00fcltigkeit kurveng\u00fcltigkeit : kurveng\u00fcltigkeiten) {
            if (kurveng\u00fcltigkeit.istAusfall() || !kurveng\u00fcltigkeit.kurvenname().equals(letzte.kurvenname()) && (kurveng\u00fcltigkeit.\u00fcbergangZu() == null || !kurveng\u00fcltigkeit.\u00fcbergangZu().equals(letzte.kurvenname()))) break;
            kurveng\u00fcltigkeitStart = kurveng\u00fcltigkeit;
        }
        return Optional.of(new Kurveng\u00fcltigkeit(kurveng\u00fcltigkeitStart.von(), letzte.bis(), letzte.kurvenname(), letzte.\u00fcbergangZu()));
    }

    @Override
    public DateTime anfangDerAufzeichnungen(long messstellenNummer, Parameter parameter) throws Exception {
        try (PreparedStatement s2 = this.connection.prepareStatement("select max(beginn) as zeit from ((select min(zeit) as beginn from " + parameter.table_tagesmittel() + " where messtellen_nr=?) union (select ausgabe_von_datum as beginn from datenausgabe_sperrung where messtellen_nr=? and komponente=?))");){
            s2.setLong(1, messstellenNummer);
            s2.setLong(2, messstellenNummer);
            s2.setString(3, parameter.name());
            try (ResultSet rs = s2.executeQuery();){
                if (rs.next()) {
                    DateTime dateTime = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                    return dateTime;
                }
            }
        }
        return null;
    }

    @Override
    public Benutzer benutzer(long userId) throws Exception {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT organisationseinheiten from v_pegeldaten_users where id=?");){
            stmt.setLong(1, userId);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    String organisationseinheiten = rs.getString("organisationseinheiten");
                    Benutzer benutzer = new Benutzer(userId, organisationseinheiten);
                    return benutzer;
                }
            }
        }
        throw new NoSuchElementException("Could not find user with ID " + userId);
    }

    @Override
    public boolean abflussspendeRechnen(long messstellenNummer) throws Exception {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT abflussspende_rechnen from konfiguration where messtellen_nr=?");){
            boolean bl;
            block16: {
                ResultSet rs;
                block14: {
                    boolean bl2;
                    block15: {
                        stmt.setLong(1, messstellenNummer);
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            bl2 = rs.getBoolean("abflussspende_rechnen");
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = true;
                if (rs == null) break block16;
                rs.close();
            }
            return bl;
        }
    }

    @Override
    public List<Abflussmessung> abflussmessungen(long messstellenNummer) throws Exception {
        ArrayList<Abflussmessung> result = new ArrayList<Abflussmessung>();
        String sql = "SELECT am.*, p.*,    ps.name AS pruefstatus_name,     q.name AS qualitaet_name,     CASE WHEN st.id=5 AND p.andere_stelle IS NOT NULL THEN p.andere_stelle ELSE st.name END AS stelle_name   FROM am_abflussmessung am   LEFT OUTER JOIN am_protokoll p ON p.abflussmessung_id=am.id   LEFT OUTER JOIN sl_am_pruefstatus ps ON ps.id=am.pruefstatus   LEFT OUTER JOIN sl_am_qualitaet q ON q.id=am.qualitaet   LEFT OUTER JOIN sl_am_stelle st ON st.id=p.stelle   WHERE am.messtellen_nr=?   ORDER BY am.datum ASC";
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT am.*, p.*,    ps.name AS pruefstatus_name,     q.name AS qualitaet_name,     CASE WHEN st.id=5 AND p.andere_stelle IS NOT NULL THEN p.andere_stelle ELSE st.name END AS stelle_name   FROM am_abflussmessung am   LEFT OUTER JOIN am_protokoll p ON p.abflussmessung_id=am.id   LEFT OUTER JOIN sl_am_pruefstatus ps ON ps.id=am.pruefstatus   LEFT OUTER JOIN sl_am_qualitaet q ON q.id=am.qualitaet   LEFT OUTER JOIN sl_am_stelle st ON st.id=p.stelle   WHERE am.messtellen_nr=?   ORDER BY am.datum ASC");){
            stmt.setFetchSize(20);
            stmt.setLong(1, messstellenNummer);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    DateTime at = new DateTime((Object)rs.getTimestamp("datum", SQLDatenRepository.calendar()), timeZone);
                    ComparableQuantity<Length> W_m = Quantities.getQuantity(rs.getDouble("w_m"), MetricPrefix.CENTI(Units.METRE));
                    ComparableQuantity<Abfluss> Q = Quantities.getQuantity(rs.getDouble("q"), luwa.marlin.ship_library.model.units.Units.CUBIC_METRE_PER_SECOND);
                    ComparableQuantity<Area> A = Quantities.getQuantity(rs.getDouble("a"), Units.SQUARE_METRE);
                    ComparableQuantity<Length> b2 = Quantities.getQuantity(rs.getDouble("b"), Units.METRE);
                    ComparableQuantity<Speed> v_m = Quantities.getQuantity(rs.getDouble("v_m"), Units.METRE_PER_SECOND);
                    String checkStatus = SQLDatenRepository.getNullSafeString(rs, "pruefstatus_name");
                    String quality = SQLDatenRepository.getNullSafeString(rs, "qualitaet_name");
                    Messart messart = Messart.fromDb(rs.getInt("messart"));
                    String placeOfMeasurement = SQLDatenRepository.getNullSafeString(rs, "stelle_name");
                    String comment = SQLDatenRepository.getNullSafeString(rs, "bemerkung");
                    String specifics = SQLDatenRepository.getNullSafeString(rs, "ufer_sohl_eigenschaften");
                    ZonedDateTime dateCalculated = SqlHelpers.getDateTime(rs, "datum_berechnet");
                    Optional<AbflussmessungErgebnisse> ergebnisse = dateCalculated != null ? Optional.of(this.abflussmessungsErgebnisseAus(rs, dateCalculated)) : Optional.empty();
                    result.add(new Abflussmessung(at, W_m, Q, A, b2, v_m, checkStatus, quality, messart, placeOfMeasurement, comment, specifics, ergebnisse));
                }
            }
        }
        return result;
    }

    private AbflussmessungErgebnisse abflussmessungsErgebnisseAus(ResultSet rs, ZonedDateTime berechnungszeitpunkt) throws SQLException {
        ComparableQuantity<Abfluss> Q = Quantities.getQuantity(rs.getDouble("q"), luwa.marlin.ship_library.model.units.Units.CUBIC_METRE_PER_SECOND);
        ComparableQuantity<Area> A = Quantities.getQuantity(rs.getDouble("a"), Units.SQUARE_METRE);
        ComparableQuantity<Speed> v_m = Quantities.getQuantity(rs.getDouble("v_m"), Units.METRE_PER_SECOND);
        ComparableQuantity<Speed> vo_max = Quantities.getQuantity(rs.getDouble("vo_max"), Units.METRE_PER_SECOND);
        ComparableQuantity<Speed> vo_m = Quantities.getQuantity(rs.getDouble("vo_m"), Units.METRE_PER_SECOND);
        ComparableQuantity<Length> b2 = Quantities.getQuantity(rs.getDouble("b"), Units.METRE);
        ComparableQuantity<Length> W_m = Quantities.getQuantity(rs.getDouble("w_m"), MetricPrefix.CENTI(Units.METRE));
        ComparableQuantity<Length> W_min = Quantities.getQuantity(rs.getDouble("w_min"), MetricPrefix.CENTI(Units.METRE));
        ComparableQuantity<Length> W_max = Quantities.getQuantity(rs.getDouble("w_max"), MetricPrefix.CENTI(Units.METRE));
        Optional<Quantity<Abflussspende>> q2 = SQLDatenRepository.getNullableAmount(rs, "q_spende", luwa.marlin.ship_library.model.units.Units.LITRE_PER_SECOND_TIMES_SQUARE_KILOMETRE);
        ComparableQuantity<Length> U = Quantities.getQuantity(rs.getDouble("u"), Units.METRE);
        ComparableQuantity<Length> hydraulischerRadius = Quantities.getQuantity(rs.getDouble("hydraulischer_radius"), Units.METRE);
        ComparableQuantity<Length> h_max = Quantities.getQuantity(rs.getDouble("h_max"), MetricPrefix.CENTI(Units.METRE));
        ComparableQuantity<ProfilwertNachManningStrickler> P_ManningStrickler = Quantities.getQuantity(rs.getDouble("p_manning_strickler"), luwa.marlin.ship_library.model.units.Units.METRE_POW_8_DIV_3);
        Optional<Double> anteilFl\u00e4cheErfasst = Optional.of(rs.getDouble("anteil_flaeche_erfasst"));
        if (rs.wasNull()) {
            anteilFl\u00e4cheErfasst = Optional.empty();
        }
        Optional<Double> anteil\u00dcberSohleNichtErfasst = Optional.of(rs.getDouble("nicht_erfasst_ueber_sohle"));
        if (rs.wasNull()) {
            anteil\u00dcberSohleNichtErfasst = Optional.empty();
        }
        String berechnungsverfahren = SQLDatenRepository.getNullSafeString(rs, "berechnungsverfahren");
        String methodeF\u00fcrEinpunktmessungen = SQLDatenRepository.getNullSafeString(rs, "methode_einpunktmessung");
        String methodeF\u00fcrZweipunktmessungen = SQLDatenRepository.getNullSafeString(rs, "methode_zweipunktmessung");
        boolean importiert = rs.getBoolean("ergebnisse_importiert");
        return new AbflussmessungErgebnisse(Q, A, v_m, vo_max, vo_m, b2, W_m, W_min, W_max, q2, U, hydraulischerRadius, h_max, P_ManningStrickler, berechnungsverfahren, methodeF\u00fcrEinpunktmessungen, methodeF\u00fcrZweipunktmessungen, importiert, berechnungszeitpunkt, anteilFl\u00e4cheErfasst, anteil\u00dcberSohleNichtErfasst);
    }

    public static <Q extends Quantity<Q>> Optional<Quantity<Q>> getNullableAmount(ResultSet rs, String columnLabel, Unit<Q> unit) throws SQLException {
        double d2 = rs.getDouble(columnLabel);
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(Quantities.getQuantity(d2, unit));
    }

    @Override
    public J\u00e4hrlichkeiten j\u00e4hrlichkeiten(long messstellenNummer) throws Exception {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT hq2, hq5, hq10, hq20, hq50, hq100, hq200ber from v_pegeldaten_regionalisierung where MESSTELLEN_NR=?");){
            stmt.setLong(1, messstellenNummer);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    double hq2 = rs.getDouble("hq2");
                    double hq5 = rs.getDouble("hq5");
                    double hq10 = rs.getDouble("hq10");
                    double hq20 = rs.getDouble("hq20");
                    double hq50 = rs.getDouble("hq50");
                    double hq100 = rs.getDouble("hq100");
                    double hq200ber = rs.getDouble("hq200ber");
                    J\u00e4hrlichkeiten j\u00e4hrlichkeiten = new J\u00e4hrlichkeiten(messstellenNummer, hq2, hq5, hq10, hq20, hq50, hq100, hq200ber);
                    return j\u00e4hrlichkeiten;
                }
            }
        }
        return null;
    }

    @Override
    public Optional<Long> aktuelleAbflusskurveId(long messstellenNummer) throws Exception {
        block16: {
            try (PreparedStatement s2 = this.connection.prepareStatement("select g.kurve as kurve from ak_gueltigkeit g where g.messtellen_nr=? and g.bis is null order by g.von desc");){
                s2.setLong(1, messstellenNummer);
                ResultSet rs = s2.executeQuery();
                if (!rs.next()) break block16;
                long curveId = rs.getLong("kurve");
                if (rs.wasNull()) {
                    Optional<Long> optional = Optional.empty();
                    return optional;
                }
                Optional<Long> optional = Optional.of(curveId);
                return optional;
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public WQPaar HW_HQ(long messstellenNummer, org.joda.time.Interval interval) throws Exception {
        TimestampedValue hq = this.maxFromTable(messstellenNummer, interval, "q", "q_scheitel");
        if (null != hq) {
            TimestampedValue wq = this.valueAtTimestamp(messstellenNummer, hq.timestamp(), "w", "w_scheitel");
            return new WQPaar(wq, hq);
        }
        hq = this.maxFromTable(messstellenNummer, interval, "q", "q_max");
        if (null != hq) {
            TimestampedValue wq = this.valueAtTimestamp(messstellenNummer, hq.timestamp(), "w", "w_max");
            return new WQPaar(wq, hq);
        }
        hq = this.maxFromTable(messstellenNummer, interval, "q", "q");
        if (null != hq) {
            TimestampedValue wq = this.valueAtTimestamp(messstellenNummer, hq.timestamp(), "w", "w");
            return new WQPaar(wq, hq);
        }
        TimestampedValue hw = this.maxFromTable(messstellenNummer, interval, "w", "w_scheitel");
        if (null == hw) {
            hw = this.maxFromTable(messstellenNummer, interval, "w", "w_max");
        }
        if (null == hw) {
            hw = this.maxFromTable(messstellenNummer, interval, "w", "w");
        }
        return new WQPaar(hw, null);
    }

    private TimestampedValue valueAtTimestamp(long messstellenNummer, DateTime timestamp, String valueColumnName, String tableName) throws Exception {
        try (PreparedStatement stmt = this.connection.prepareStatement("select " + valueColumnName + " from " + tableName + " where messtellen_nr=? and zeit=?");){
            stmt.setLong(1, messstellenNummer);
            stmt.setTimestamp(2, this.timestamp(timestamp), SQLDatenRepository.calendar());
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    double value = rs.getDouble(valueColumnName);
                    if (!rs.wasNull()) {
                        TimestampedValue timestampedValue = new TimestampedValue(timestamp, value);
                        return timestampedValue;
                    }
                }
            }
        }
        return null;
    }

    private TimestampedValue maxFromTable(long messstellenNummer, org.joda.time.Interval interval, String valueColumnName, String tableName) throws Exception {
        try (PreparedStatement stmt = this.connection.prepareStatement("select " + valueColumnName + ", zeit from (select * from " + tableName + " where " + valueColumnName + " is not null and messtellen_nr=? and zeit >= ? and zeit < ? order by " + valueColumnName + " desc) where rownum <= 1");){
            stmt.setLong(1, messstellenNummer);
            stmt.setTimestamp(2, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
            stmt.setTimestamp(3, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                    double value = rs.getDouble(valueColumnName);
                    if (!rs.wasNull()) {
                        TimestampedValue timestampedValue = new TimestampedValue(timestamp, value);
                        return timestampedValue;
                    }
                }
            }
        }
        return null;
    }

    private static Bearbeitungstyp editedRangeTypeFrom(String typeKey, String additionalParameter) {
        if (SQLDatenRepository.isDelete(typeKey)) {
            return Bearbeitungstyp.gel\u00f6scht;
        }
        if (SQLDatenRepository.indicatesRedundancyOrigin(additionalParameter)) {
            return Bearbeitungstyp.\u00fcbernommenAusRedundanz;
        }
        return Bearbeitungstyp.echteBearbeitunug;
    }

    private static boolean indicatesRedundancyOrigin(String additionalParameter) {
        return null != additionalParameter && additionalParameter.contains("\"origin_series\":\"Redundanz\"");
    }

    private static boolean isDelete(String editTypeKey) {
        return "delete".equals(editTypeKey);
    }

    private Timestamp timestamp(DateTime dateTime) {
        return new Timestamp(dateTime.getMillis());
    }

    private static Calendar calendar() {
        return Calendar.getInstance(calendarTimeZone);
    }

    @Override
    public List<TimestampedValue> weitereGanglinie(long messstellenNummer, Parameter parameter, String ganglinienName, org.joda.time.Interval interval, NHNTransformationOfTimestampedValues transformation) throws Exception {
        ArrayList<TimestampedValue> values = new ArrayList<TimestampedValue>();
        String valueColumnName = parameter.valueColumnName();
        String tableName = parameter.table_temp();
        String definitionTableName = parameter.table_temp_definition();
        Benchmark.benchmark("Laden weitere Ganglinie f\u00fcr " + parameter.symbol(), () -> {
            try (PreparedStatement stmt = this.connection.prepareStatement("SELECT zeit, " + valueColumnName + " from " + tableName + " v left outer join " + definitionTableName + " d on d.id=v.reihen_nr where zeit between ? and ? and messtellen_nr=? and name=? and geloescht=0 order by zeit asc");){
                stmt.setFetchSize(40000);
                stmt.setTimestamp(1, this.timestamp(interval.getStart()), SQLDatenRepository.calendar());
                stmt.setTimestamp(2, this.timestamp(interval.getEnd()), SQLDatenRepository.calendar());
                stmt.setLong(3, messstellenNummer);
                stmt.setString(4, ganglinienName);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        DateTime timestamp = new DateTime((Object)rs.getTimestamp("zeit", SQLDatenRepository.calendar()), timeZone);
                        double stage = rs.getDouble(valueColumnName);
                        if (!rs.wasNull()) {
                            values.add(transformation.forValue(new TimestampedValue(timestamp, stage)));
                            continue;
                        }
                        values.add(transformation.forValue(new TimestampedValue(timestamp)));
                    }
                }
            }
        });
        return values;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String allgemeineBemerkungDGJ() {
        try (PreparedStatement query = this.connection.prepareStatement("SELECT bemerkung FROM verwaltung_dgj_allgemein");){
            String string;
            block18: {
                ResultSet rs;
                block16: {
                    String string2;
                    block17: {
                        rs = query.executeQuery();
                        try {
                            if (!rs.next()) break block16;
                            string2 = SQLDatenRepository.getNullSafeString(rs, "bemerkung");
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return string2;
                }
                string = "";
                if (rs == null) break block18;
                rs.close();
            }
            return string;
        }
        catch (SQLException e2) {
            throw new RuntimeException("Konnte allgemeine Bemerkung f\u00fcr DGJ nicht aus Datenbank laden", e2);
        }
    }

    @Override
    public List<Bemerkungstext> bemerkungstexte(long messstellenNummer, Parameter parameter, org.joda.time.Interval zeitraum) {
        Timestamp start = this.timestamp(zeitraum.getStart());
        Timestamp end = this.timestamp(zeitraum.getEnd());
        ArrayList<Bemerkungstext> bemerkungen = new ArrayList<Bemerkungstext>();
        try {
            String sql = "SELECT b.*, p.*, t.name typ_name, e.gwd_langname, betr.gwb_langname, u.organisationseinheiten   FROM bemerkung b   LEFT OUTER JOIN " + stammdaten.pegeldatenView() + " p ON p.messtellen_nr=b.messtellen_nr   LEFT OUTER JOIN v_pegeldaten_betreiber betr ON betr.gwb_nr=p.gwb_nr   LEFT OUTER JOIN sl_eigentuemer e ON e.gwd_nr=p.gwd_nr   LEFT OUTER JOIN v_pegeldaten_users u ON u.id=b.autor   LEFT OUTER JOIN sl_bemerkungstyp t ON t.id=b.typ   WHERE b.geloescht=0     AND b.messtellen_nr=?     AND b.parameter=?     AND ((b.von >= ? AND b.von < ?) OR (b.bis >= ? AND b.bis < ?) OR (b.von <= ? AND b.bis >=?))   ORDER BY b.von ASC";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                query.setLong(1, messstellenNummer);
                query.setString(2, parameter.key());
                query.setTimestamp(3, start, SQLDatenRepository.calendar());
                query.setTimestamp(4, end, SQLDatenRepository.calendar());
                query.setTimestamp(5, start, SQLDatenRepository.calendar());
                query.setTimestamp(6, end, SQLDatenRepository.calendar());
                query.setTimestamp(7, start, SQLDatenRepository.calendar());
                query.setTimestamp(8, end, SQLDatenRepository.calendar());
                try (ResultSet rs = query.executeQuery();){
                    while (rs.next()) {
                        bemerkungen.add(new Bemerkungstext(messstellenNummer, SQLDatenRepository.getNullSafeString(rs, "standort"), SQLDatenRepository.getNullSafeString(rs, "gewaesser"), SQLDatenRepository.getNullSafeString(rs, "messnetz"), SQLDatenRepository.getNullSafeString(rs, "gwd_langname"), SQLDatenRepository.getNullSafeString(rs, "gwb_langname"), parameter, new Interval(SqlHelpers.getDateTime(rs, "von"), SqlHelpers.getDateTime(rs, "bis")), SQLDatenRepository.getNullSafeString(rs, "organisationseinheiten"), SQLDatenRepository.getNullSafeString(rs, "typ_name"), rs.getBoolean("abgearbeitet"), SQLDatenRepository.getNullSafeString(rs, "bemerkung")));
                    }
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Bemerkungstexte f\u00fcr Pegel " + messstellenNummer + " nicht aus Datenbank laden", e2);
        }
        return bemerkungen;
    }

    @Override
    public List<Datenpr\u00fcfung> datenpr\u00fcfungen(long messstellenNummer, Datenpr\u00fcfungTyp typ, org.joda.time.Interval zeitraum) {
        Timestamp start = this.timestamp(zeitraum.getStart());
        Timestamp end = this.timestamp(zeitraum.getEnd());
        ArrayList<Datenpr\u00fcfung> datenpr\u00fcfungen = new ArrayList<Datenpr\u00fcfung>();
        try {
            String sql = "SELECT pruefung.*, p.*, e.gwd_langname, betr.gwb_langname, (u.last_name || ', ' || u.first_name) pruefer_name, u.organisationseinheiten  FROM " + typ.tabelle() + " pruefung   LEFT OUTER JOIN " + stammdaten.pegeldatenView() + " p ON p.messtellen_nr=pruefung.messtellen_nr   LEFT OUTER JOIN v_pegeldaten_betreiber betr ON betr.gwb_nr=p.gwb_nr   LEFT OUTER JOIN sl_eigentuemer e ON e.gwd_nr=p.gwd_nr   LEFT OUTER JOIN v_pegeldaten_users u ON u.id=pruefung.pruefer   WHERE pruefung.messtellen_nr=?     AND ((pruefung.von >= ? AND pruefung.von < ?) OR (pruefung.bis >= ? AND pruefung.bis < ?) OR (pruefung.von <= ? AND pruefung.bis >=?))   ORDER BY pruefung.von ASC";
            try (PreparedStatement query = this.connection.prepareStatement(sql);){
                query.setLong(1, messstellenNummer);
                query.setTimestamp(2, start, SQLDatenRepository.calendar());
                query.setTimestamp(3, end, SQLDatenRepository.calendar());
                query.setTimestamp(4, start, SQLDatenRepository.calendar());
                query.setTimestamp(5, end, SQLDatenRepository.calendar());
                query.setTimestamp(6, start, SQLDatenRepository.calendar());
                query.setTimestamp(7, end, SQLDatenRepository.calendar());
                try (ResultSet rs = query.executeQuery();){
                    while (rs.next()) {
                        datenpr\u00fcfungen.add(new Datenpr\u00fcfung(typ, messstellenNummer, SQLDatenRepository.getNullSafeString(rs, "standort"), SQLDatenRepository.getNullSafeString(rs, "gewaesser"), SQLDatenRepository.getNullSafeString(rs, "messnetz"), SQLDatenRepository.getNullSafeString(rs, "gwd_langname"), SQLDatenRepository.getNullSafeString(rs, "gwb_langname"), new Interval(SqlHelpers.getDateTime(rs, "von"), SqlHelpers.getDateTime(rs, "bis")), SQLDatenRepository.getNullSafeString(rs, "bemerkung"), SQLDatenRepository.getNullSafeString(rs, "pruefer_name"), SqlHelpers.getDateTime(rs, "zeit"), SQLDatenRepository.getNullSafeString(rs, "organisationseinheiten")));
                    }
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Datenpr\u00fcfungen f\u00fcr Pegel " + messstellenNummer + " nicht aus Datenbank laden", e2);
        }
        return datenpr\u00fcfungen;
    }

    @Override
    public AnzahlAbflussmessungen abflussmessungenStatistik(List<Long> messstellenNummern, int jahr) {
        AnzahlAbflussmessungen statistik = new AnzahlAbflussmessungen();
        if (messstellenNummern.isEmpty()) {
            return statistik;
        }
        String messstellenNummernKommasepariert = messstellenNummern.stream().map(String::valueOf).collect(Collectors.joining(", "));
        String datumVon = String.format("%d-11-01", jahr - 1);
        String datumBis = String.format("%d-11-01", jahr);
        String sql = "WITH statistik AS     (SELECT       am.messtellen_nr,       COUNT(am.id) messungen     FROM am_abflussmessung am     WHERE       messtellen_namensraum_id=0 AND       am.messtellen_nr IN (" + messstellenNummernKommasepariert + ") AND       datum>=DATE'" + datumVon + "' AND datum<DATE'" + datumBis + "'     GROUP BY       am.messtellen_nr     ORDER BY       messtellen_nr DESC)   SELECT s.*, pd.standort, pd.gewaesser, pd.messnetz, pde.gwd_langname eigentuemer, pdb.gwb_langname betreiber, pd.pegeltyp from statistik s     LEFT OUTER JOIN " + stammdaten.pegeldatenView() + " pd ON pd.messtellen_nr=s.messtellen_nr     LEFT OUTER JOIN sl_eigentuemer pde ON pde.gwd_nr=pd.gwd_nr     LEFT OUTER JOIN v_pegeldaten_betreiber pdb ON pdb.gwb_nr=pd.gwb_nr";
        try (PreparedStatement query = this.connection.prepareStatement(sql);
             ResultSet rs = query.executeQuery();){
            while (rs.next()) {
                statistik.add(new AnzahlAbflussmessungen.Eintrag(rs.getLong("messtellen_nr"), SQLDatenRepository.getNullSafeString(rs, "standort"), SQLDatenRepository.getNullSafeString(rs, "gewaesser"), SQLDatenRepository.getNullSafeString(rs, "messnetz"), SQLDatenRepository.getNullSafeString(rs, "eigentuemer"), SQLDatenRepository.getNullSafeString(rs, "betreiber"), SQLDatenRepository.getNullSafeString(rs, "pegeltyp"), rs.getLong("messungen")));
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Konnte Abflussmessungen-Statistiken f\u00fcr das Jahr " + jahr + " nicht aus der Datenbank laden", e2);
        }
        return statistik;
    }

    @Override
    public \u00dcbersichtsRepository \u00fcbersicht() {
        return new SQL\u00dcbersichtsRepository(this.connection);
    }

    private static boolean isExerciseStation(long messstellenNummer) {
        return messstellenNummer >= 9800000L && messstellenNummer <= 9899999L;
    }

    private static String getNullSafeString(ResultSet rs, String columnLabel) throws SQLException {
        String result = rs.getString(columnLabel);
        if (null == result) {
            return "";
        }
        return result;
    }

    private static Optional<Double> getNullableDouble(ResultSet rs, String columnLabel) throws SQLException {
        double value = rs.getDouble(columnLabel);
        if (rs.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    private static Optional<DateTime> getNullableDateTime(ResultSet resultSet, String columnLabel) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(columnLabel, SQLDatenRepository.calendar());
        if (resultSet.wasNull()) {
            return Optional.empty();
        }
        return Optional.of(new DateTime((Object)timestamp, timeZone));
    }
}

