/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.Abflusskurve;
import luwa.marlin.ship_library.model.Abflussmessung;
import luwa.marlin.ship_library.model.Abflussnullpunkt;
import luwa.marlin.ship_library.model.AnzahlAbflussmessungen;
import luwa.marlin.ship_library.model.Aufl\u00f6sungsZeitbereich;
import luwa.marlin.ship_library.model.BearbeiteterZeitbereich;
import luwa.marlin.ship_library.model.Bemerkungstext;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Datenpr\u00fcfung;
import luwa.marlin.ship_library.model.Datenpr\u00fcfungTyp;
import luwa.marlin.ship_library.model.Formel;
import luwa.marlin.ship_library.model.HandUndSystemWerte;
import luwa.marlin.ship_library.model.Kurveng\u00fcltigkeit;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.Monatsh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Monatsmittelwerte;
import luwa.marlin.ship_library.model.Notizen;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Stundenmittelwerte;
import luwa.marlin.ship_library.model.Tagesh\u00f6chstwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.Verkettung;
import luwa.marlin.ship_library.model.ZeitbereicheMitErg\u00e4nztenWerten;
import luwa.marlin.ship_library.model.datenpr\u00fcfung.Gepr\u00fcfteZeitbereiche;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.Stundenmittelwert;
import luwa.marlin.ship_library.model.value.Tagesh\u00f6chstwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.value.WQPaar;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.J\u00e4hrlichkeiten;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.\u00dcbersichtsRepository;
import luwa.marlin.ship_library.view.text.helpers.Listenprodukt;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DatenRepositoryMitVerkettung
implements DatenRepository {
    private final DatenRepository source;

    public DatenRepositoryMitVerkettung(DatenRepository source) {
        this.source = source;
    }

    @Override
    public Messstelle messstelle(long messstellenNummer) throws Exception {
        return this.source.messstelle(messstellenNummer);
    }

    @Override
    public Ausfalljahre ausfalljahre(long messstellenNummer, Parameter parameter, Interval zeitbereich) throws Exception {
        List<Verkettung> verkettungen;
        if (parameter == Parameter.q && !(verkettungen = this.source.verkettungen(messstellenNummer)).isEmpty()) {
            Ausfalljahre jahre = new Ausfalljahre();
            for (Verkettung verkettung : this.verkettungenIn(verkettungen, zeitbereich)) {
                jahre.add(this.ausfalljahre(this.source, verkettung, verkettung.interval()));
            }
            return jahre;
        }
        return this.source.ausfalljahre(messstellenNummer, parameter, zeitbereich);
    }

    @Override
    public List<TimestampedValue> l\u00fccken(long messstellenNummer, Parameter parameter) throws Exception {
        return this.source.l\u00fccken(messstellenNummer, parameter);
    }

    @Override
    public List<Aufl\u00f6sungsZeitbereich> aufl\u00f6sungen(long messstellenNummer) throws Exception {
        return this.source.aufl\u00f6sungen(messstellenNummer);
    }

    @Override
    public Notizen notizen(long messstellenNummer, Interval interval) {
        return new Notizen();
    }

    @Override
    public List<TimestampedValue> weitereGanglinie(long messstellenNummer, Parameter parameter, String ganglinienName, Interval interval, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.source.weitereGanglinie(messstellenNummer, parameter, ganglinienName, interval, transformation);
    }

    @Override
    public String allgemeineBemerkungDGJ() {
        return this.source.allgemeineBemerkungDGJ();
    }

    @Override
    public List<Bemerkungstext> bemerkungstexte(long messstellenNummer, Parameter parameter, Interval zeitraum) {
        return this.source.bemerkungstexte(messstellenNummer, parameter, zeitraum);
    }

    @Override
    public List<Datenpr\u00fcfung> datenpr\u00fcfungen(long messstellenNummer, Datenpr\u00fcfungTyp typ, Interval zeitraum) {
        return this.source.datenpr\u00fcfungen(messstellenNummer, typ, zeitraum);
    }

    @Override
    public AnzahlAbflussmessungen abflussmessungenStatistik(List<Long> messstellenNummern, int jahr) {
        return this.source.abflussmessungenStatistik(messstellenNummern, jahr);
    }

    @Override
    public \u00dcbersichtsRepository \u00fcbersicht() {
        return this.source.\u00fcbersicht();
    }

    @Override
    public Interval datenbestand(long messstellenNummer, Parameter parameter) throws Exception {
        return this.source.datenbestand(messstellenNummer, parameter);
    }

    public Ausfalljahre ausfalljahre(DatenRepository datenRepository, Verkettung verkettung, Interval zeitbereich) throws Exception {
        Formel formel = Formel.parse(verkettung.formeltext());
        Ausfalljahre jahre = new Ausfalljahre();
        for (long messstellenNummer : formel.messstellenNummern()) {
            jahre.add(datenRepository.ausfalljahre(messstellenNummer, Parameter.q, zeitbereich));
        }
        return jahre;
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues maybeNHNTransform, Comparator<Tagesmittelwert> comparator) throws Exception {
        return this.convertToDayMeanValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.tagesmittel, interval, ausfalljahre, maybeNHNTransform), factor);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor) throws Exception {
        return this.convertToDayMeanValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.tagesmittel, interval, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), factor);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Ausfalljahre ausfalljahre) throws Exception {
        return this.convertToDayMeanValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.tagesmittel, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), 1.0);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor, Comparator<Tagesmittelwert> comparator) throws Exception {
        return this.convertToDayMeanValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.tagesmittel, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), factor, comparator);
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte(long messstellenNummer, Parameter parameter, Ausfalljahre ausfalljahre, Comparator<Tagesmittelwert> comparator) throws Exception {
        return this.convertToDayMeanValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.tagesmittel, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), 1.0, comparator);
    }

    @Override
    public List<TimestampedValue> stunden15MinutenMittelwerte(long messstellenNummer, Parameter parameter, Interval interval, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.stunden15MinutenMittel, interval, new Ausfalljahre(), transformation);
    }

    @Override
    public Stundenmittelwerte stundenmittelwerte(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        return this.convertToHourMeanValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.stundenmittel, interval, ausfalljahre, nhnTransformation), factor);
    }

    @Override
    public Tagesh\u00f6chstwerte tagesh\u00f6chstwerte(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        return this.convertToDayMaxValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.tagesmaxima, interval, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), 1.0);
    }

    @Override
    public Scheitelwerte scheitelwerte(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues nhnTransformation) throws Exception {
        return this.convertToPeakValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.scheitelwerte, interval, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), 1.0);
    }

    @Override
    public Scheitelwerte scheitelwerte(long messstellenNummer, Parameter parameter, Ausfalljahre ausfalljahre) throws Exception {
        return this.convertToPeakValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.scheitelwerte, ausfalljahre, NHNTransformationOfTimestampedValues.doNothing()), 1.0);
    }

    @Override
    public Scheitelwerte scheitelwertL\u00fccken(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.convertToPeakValues(this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.fehlendeScheitelwerte, ausfalljahre, transformation), 1.0);
    }

    @Override
    public List<TimestampedValue> stunden15MinutenMittelwerte_redundanz(long messstellenNummer, Parameter parameter, Interval interval, NHNTransformationOfTimestampedValues transformation) {
        return null;
    }

    @Override
    public Tagesmittelwerte tagesmittelwerte_redundanz(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) {
        return null;
    }

    @Override
    public Tagesh\u00f6chstwerte tagesh\u00f6chstwerte_redundanz(long messstellenNummer, Parameter parameter, Interval interval, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) {
        return null;
    }

    @Override
    public List<TimestampedValue> werteUnbearbeitetHauptsystem(long messstellenNummer, Parameter parameter, Interval interval, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.unbearbeitetHauptsystem, interval, new Ausfalljahre(), transformation);
    }

    @Override
    public List<TimestampedValue> werteUnbearbeitetRedundanzsystem(long messstellenNummer, Parameter parameter, Interval interval, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        return this.concatenatedValues(messstellenNummer, parameter, true, Listenprodukt.unbearbeitetRedundanzsystem, interval, new Ausfalljahre(), transformation);
    }

    @Override
    public List<TimestampedValue> werteFehlendeAbfl\u00fcsse(long messstellenNummer, Interval interval) {
        return this.source.werteFehlendeAbfl\u00fcsse(messstellenNummer, interval);
    }

    @Override
    public HandUndSystemWerte handUndSystemWerte(long messstellenNummer, Parameter parameter, Interval interval) {
        return new HandUndSystemWerte();
    }

    @Override
    public HandUndSystemWerte handUndSystemWerte_redundanz(long messstellenNummer, Parameter parameter, Interval interval) {
        return new HandUndSystemWerte();
    }

    @Override
    public Gepr\u00fcfteZeitbereiche gepr\u00fcfteZeitbereiche(long messstellenNummer, Parameter parameter, Interval interval) {
        return null;
    }

    @Override
    public List<Pegelnullpunkt> pegelnullpunkte(long messstellenNummer) throws Exception {
        List<Verkettung> verkettungen = this.source.verkettungen(messstellenNummer);
        if (!verkettungen.isEmpty()) {
            ArrayList<Pegelnullpunkt> result = new ArrayList<Pegelnullpunkt>();
            for (Verkettung c2 : verkettungen) {
                Formel formel = Formel.parse(c2.formeltext());
                for (long station : formel.messstellenNummern()) {
                    result.addAll(this.source.pegelnullpunkte(station));
                }
            }
            return result;
        }
        return this.source.pegelnullpunkte(messstellenNummer);
    }

    @Override
    public List<Abflussnullpunkt> abflussnullpunkte(long messstellenNummer) throws Exception {
        return this.source.abflussnullpunkte(messstellenNummer);
    }

    @Override
    public ZeitbereicheMitErg\u00e4nztenWerten bearbeiteteZeitbereiche(long messstellenNummer, Parameter parameter, Interval interval) throws Exception {
        List<Verkettung> verkettungen;
        if (parameter == Parameter.q && !(verkettungen = this.source.verkettungen(messstellenNummer)).isEmpty()) {
            ArrayList<BearbeiteterZeitbereich> ranges = new ArrayList<BearbeiteterZeitbereich>();
            for (Verkettung c2 : this.verkettungenIn(verkettungen, interval)) {
                Formel formel = Formel.parse(c2.formeltext());
                for (long station : formel.messstellenNummern()) {
                    ranges.addAll(this.source.bearbeiteteZeitbereiche(station, parameter, c2.interval()).ranges());
                }
            }
            return new ZeitbereicheMitErg\u00e4nztenWerten(ranges);
        }
        return this.source.bearbeiteteZeitbereiche(messstellenNummer, parameter, interval);
    }

    @Override
    public List<Verkettung> verkettungen(long messstellenNummer) throws Exception {
        return this.source.verkettungen(messstellenNummer);
    }

    @Override
    public Abflusskurve abflusskurve(long abflusskurvenId) throws Exception {
        return this.source.abflusskurve(abflusskurvenId);
    }

    @Override
    public List<Kurveng\u00fcltigkeit> kurveng\u00fcltigkeitenF\u00fcrMessstelle(long messstellenNummer) {
        return null;
    }

    @Override
    public Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeitVon(long abflusskurvenId) {
        return Optional.empty();
    }

    private Tagesmittelwerte convertToDayMeanValues(List<? extends TimestampedValue> values, double factor) {
        return this.convertToDayMeanValues(values, factor, TimestampedValue::compareTo);
    }

    private Tagesmittelwerte convertToDayMeanValues(List<? extends TimestampedValue> values, double factor, Comparator<Tagesmittelwert> comparator) {
        Tagesmittelwerte result = new Tagesmittelwerte(comparator);
        for (TimestampedValue timestampedValue : values) {
            result.add(new Tagesmittelwert(timestampedValue.timestamp, timestampedValue.value));
        }
        return result;
    }

    private Stundenmittelwerte convertToHourMeanValues(List<? extends TimestampedValue> values, double factor) {
        Stundenmittelwerte result = new Stundenmittelwerte();
        for (TimestampedValue timestampedValue : values) {
            result.add((Stundenmittelwert)timestampedValue);
        }
        return result;
    }

    private Tagesh\u00f6chstwerte convertToDayMaxValues(List<? extends TimestampedValue> values, double factor) {
        Tagesh\u00f6chstwerte result = new Tagesh\u00f6chstwerte();
        for (TimestampedValue timestampedValue : values) {
            result.add((Tagesh\u00f6chstwert)timestampedValue);
        }
        return result;
    }

    private Scheitelwerte convertToPeakValues(List<? extends TimestampedValue> values, double factor) {
        Scheitelwerte result = new Scheitelwerte();
        for (TimestampedValue timestampedValue : values) {
            result.add((Scheitelwert)timestampedValue);
        }
        return result;
    }

    private boolean istEinzelneMessstelle(String formeltext) {
        return formeltext.matches("-?\\d+");
    }

    private int stationIn(String f2) {
        return Integer.parseInt(f2);
    }

    List<? extends TimestampedValue> concatenatedValues(long messstellenNummer, Parameter parameter, boolean withPre, Listenprodukt product, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) throws Exception {
        List<Verkettung> verkettungen;
        if (parameter == Parameter.q && withPre && !(verkettungen = this.source.verkettungen(messstellenNummer)).isEmpty()) {
            ArrayList<? extends TimestampedValue> result = new ArrayList<TimestampedValue>();
            for (Verkettung c2 : verkettungen) {
                result.addAll(this.calculateValues(this.source, c2, parameter, product, ausfalljahre, transformation));
            }
            return result;
        }
        return this.valuesFor(this.source, messstellenNummer, parameter, product, 1.0);
    }

    public List<? extends TimestampedValue> concatenatedValues(long messstellenNummer, Parameter parameter, boolean withPre, Listenprodukt product, Interval interval, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) throws Exception {
        List<Verkettung> verkettungen;
        if (parameter == Parameter.q && withPre && !(verkettungen = this.source.verkettungen(messstellenNummer)).isEmpty()) {
            ArrayList<? extends TimestampedValue> result = new ArrayList<TimestampedValue>();
            for (Verkettung c2 : this.verkettungenIn(verkettungen, interval)) {
                result.addAll(this.calculateValues(this.source, c2, parameter, product, ausfalljahre, transformation));
            }
            return result;
        }
        return this.valuesFor(this.source, messstellenNummer, interval, ausfalljahre, parameter, product, 1.0, transformation);
    }

    private List<? extends TimestampedValue> calculateValues(DatenRepository datenRepository, Verkettung verkettung, Parameter parameter, Listenprodukt produkt, Ausfalljahre ausfalljahre, NHNTransformationOfTimestampedValues transformation) throws Exception {
        String formeltext = verkettung.formeltext();
        if (this.istEinzelneMessstelle(formeltext)) {
            return this.valuesFor(datenRepository, this.stationIn(formeltext), verkettung.interval(), ausfalljahre, parameter, produkt, verkettung.faktor(), transformation);
        }
        if (Listenprodukt.scheitelwerte == produkt || Listenprodukt.fehlendeScheitelwerte == produkt) {
            return this.valuesFor(datenRepository, verkettung.messstellenNummerF\u00fcrScheitelwerte(), verkettung.interval(), ausfalljahre, parameter, produkt, 1.0, transformation);
        }
        if (!Arrays.asList(Listenprodukt.stunden15MinutenMittel, Listenprodukt.stundenmittel, Listenprodukt.tagesmittel, Listenprodukt.monatsmittel, Listenprodukt.unbearbeitetHauptsystem, Listenprodukt.unbearbeitetRedundanzsystem).contains((Object)produkt)) {
            return new ArrayList();
        }
        Formel formel = Formel.parse(formeltext);
        HashMap<Long, List<? extends TimestampedValue>> werteGesamt = new HashMap<Long, List<? extends TimestampedValue>>();
        for (Long messtellenNummer : formel.messstellenNummern()) {
            List<? extends TimestampedValue> werte = this.valuesFor(datenRepository, messtellenNummer, verkettung.interval(), ausfalljahre, parameter, produkt, 1.0, transformation);
            werteGesamt.put(messtellenNummer, werte);
        }
        return formel.calculate(werteGesamt, verkettung.faktor());
    }

    private Duration bestimmeZeitschritt(List<? extends TimestampedValue> werte) {
        if (werte.size() < 2) {
            return Duration.standardMinutes(15L);
        }
        return new Interval((ReadableInstant)werte.get(0).timestamp(), (ReadableInstant)werte.get(1).timestamp()).toDuration();
    }

    private List<? extends TimestampedValue> l\u00fccken(Interval zeitraum, Duration zeitschritt) {
        ArrayList<TimestampedValue> l\u00fccken = new ArrayList<TimestampedValue>();
        DateTime zeit = zeitraum.getStart().plus(zeitschritt);
        while (zeit.isBefore(zeitraum.getEnd())) {
            l\u00fccken.add(new TimestampedValue(zeit));
            zeit = zeit.plus(zeitschritt);
        }
        return l\u00fccken;
    }

    private Optional<DateTime> ersterZeitstempelVon(List<? extends TimestampedValue> werte) {
        return werte.isEmpty() ? Optional.empty() : Optional.of(werte.get(0).timestamp());
    }

    private Optional<DateTime> letzterZeitstempelVon(List<? extends TimestampedValue> werte) {
        return werte.isEmpty() ? Optional.empty() : Optional.of(werte.get(werte.size() - 1).timestamp());
    }

    private List<Verkettung> verkettungenIn(List<Verkettung> verkettungen, Interval interval) {
        ArrayList<Verkettung> result = new ArrayList<Verkettung>();
        for (Verkettung verkettung : verkettungen) {
            DateTime start = interval.getStart();
            DateTime end = interval.getEnd();
            if (verkettung.bis().isBefore(start)) {
                if (verkettung.von() == null || verkettung.von().isAfter(start) && verkettung.von().isAfter(end)) {
                    result.add(verkettung.withInterval(start, end));
                    continue;
                }
                if (verkettung.von().isBefore(start) || verkettung.von().isAfter(end)) continue;
                result.add(verkettung.withInterval(start, verkettung.von()));
                continue;
            }
            if (verkettung.bis().isAfter(end)) continue;
            if (verkettung.von() == null || !verkettung.von().isBefore(start) && verkettung.von().isAfter(end)) {
                result.add(verkettung.withInterval(verkettung.bis(), end));
                continue;
            }
            if (verkettung.von().isBefore(start) || verkettung.von().isAfter(end)) continue;
            result.add(verkettung.withInterval(verkettung.bis(), verkettung.von()));
        }
        return result;
    }

    private List<? extends TimestampedValue> valuesFor(DatenRepository datenRepository, long messstellenNummer, Parameter parameter, Listenprodukt product, double factor) throws Exception {
        if (product == Listenprodukt.tagesmittel) {
            return datenRepository.tagesmittelwerte(messstellenNummer, parameter, new Ausfalljahre()).values();
        }
        if (product == Listenprodukt.scheitelwerte) {
            return datenRepository.scheitelwerte(messstellenNummer, parameter, new Ausfalljahre()).values();
        }
        throw new IllegalArgumentException(String.format("Product '%s' not supported", product.description()));
    }

    private List<? extends TimestampedValue> valuesFor(DatenRepository datenRepository, long messstellenNummer, Interval interval, Ausfalljahre ausfalljahre, Parameter parameter, Listenprodukt product, double factor, NHNTransformationOfTimestampedValues transformation) throws Exception {
        interval = new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)interval.getEnd().withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59));
        if (product == Listenprodukt.stunden15MinutenMittel) {
            return datenRepository.stunden15MinutenMittelwerte(messstellenNummer, parameter, interval, factor, transformation);
        }
        if (product == Listenprodukt.stundenmittel) {
            return datenRepository.stundenmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation).values();
        }
        if (product == Listenprodukt.tagesmittel) {
            return datenRepository.tagesmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation, TimestampedValue::compareTo).values();
        }
        if (product == Listenprodukt.tagesmaxima) {
            return datenRepository.tagesh\u00f6chstwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation).values();
        }
        if (product == Listenprodukt.scheitelwerte) {
            return datenRepository.scheitelwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation).values();
        }
        if (product == Listenprodukt.fehlendeScheitelwerte) {
            return datenRepository.scheitelwertL\u00fccken(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation).values();
        }
        if (product == Listenprodukt.stunden15MinutenMittelRedundanz) {
            return datenRepository.stunden15MinutenMittelwerte_redundanz(messstellenNummer, parameter, interval, transformation);
        }
        if (product == Listenprodukt.tagesmittelRedundanz) {
            return datenRepository.tagesmittelwerte_redundanz(messstellenNummer, parameter, interval, ausfalljahre, transformation).values();
        }
        if (product == Listenprodukt.tagesmaximaRedundanz) {
            return datenRepository.tagesh\u00f6chstwerte_redundanz(messstellenNummer, parameter, interval, ausfalljahre, transformation).values();
        }
        if (product == Listenprodukt.monatsmaxima) {
            return new Monatsh\u00f6chstwerte(datenRepository.tagesh\u00f6chstwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation), interval).werte();
        }
        if (product == Listenprodukt.monatsmittel) {
            return new Monatsmittelwerte(datenRepository.tagesmittelwerte(messstellenNummer, parameter, interval, ausfalljahre, factor, transformation, TimestampedValue::compareTo), interval).values();
        }
        if (product == Listenprodukt.unbearbeitetHauptsystem) {
            return datenRepository.werteUnbearbeitetHauptsystem(messstellenNummer, parameter, interval, factor, transformation);
        }
        if (product == Listenprodukt.unbearbeitetRedundanzsystem) {
            return datenRepository.werteUnbearbeitetRedundanzsystem(messstellenNummer, parameter, interval, factor, transformation);
        }
        if (product == Listenprodukt.fehlendeAbfl\u00fcsse) {
            return datenRepository.werteFehlendeAbfl\u00fcsse(messstellenNummer, interval);
        }
        throw new IllegalArgumentException(String.format("Product '%s' not supported", product.description()));
    }

    public Tagesmittelwerte tagesmittelwerte(DatenRepository datenRepository, Verkettung c2, Interval interval, Ausfalljahre years, NHNTransformationOfTimestampedValues transformation) throws Exception {
        String formula = c2.formeltext();
        if (this.istEinzelneMessstelle(formula)) {
            return datenRepository.tagesmittelwerte(this.stationIn(formula), Parameter.q, interval, years, c2.faktor(), transformation, TimestampedValue::compareTo);
        }
        Formel f2 = Formel.parse(formula);
        HashMap<Long, Tagesmittelwerte> values = new HashMap<Long, Tagesmittelwerte>();
        for (long station : f2.messstellenNummern()) {
            values.put(station, datenRepository.tagesmittelwerte(station, Parameter.q, interval, years, 1.0, transformation, TimestampedValue::compareTo));
        }
        return f2.calculateDayMeans(interval, values, c2.faktor());
    }

    @Override
    public DateTime anfangDerAufzeichnungen(long messstellenNummer, Parameter parameter) throws Exception {
        List<Verkettung> verkettungen;
        if (parameter == Parameter.q && !(verkettungen = this.verkettungen(messstellenNummer)).isEmpty()) {
            return verkettungen.get(0).bis();
        }
        return this.source.anfangDerAufzeichnungen(messstellenNummer, parameter);
    }

    @Override
    public Benutzer benutzer(long userId) throws Exception {
        return this.source.benutzer(userId);
    }

    @Override
    public boolean abflussspendeRechnen(long messstellenNummer) throws Exception {
        return this.source.abflussspendeRechnen(messstellenNummer);
    }

    @Override
    public List<Abflussmessung> abflussmessungen(long messstellenNummer) throws Exception {
        return this.source.abflussmessungen(messstellenNummer);
    }

    @Override
    public J\u00e4hrlichkeiten j\u00e4hrlichkeiten(long messstellenNummer) throws Exception {
        return this.source.j\u00e4hrlichkeiten(messstellenNummer);
    }

    @Override
    public Optional<Long> aktuelleAbflusskurveId(long messstellenNummer) throws Exception {
        return this.source.aktuelleAbflusskurveId(messstellenNummer);
    }

    @Override
    public WQPaar HW_HQ(long messstellenNummer, Interval interval) throws Exception {
        return this.source.HW_HQ(messstellenNummer, interval);
    }
}

