/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class YearsRange<YEAR extends Year>
implements Iterable<YEAR> {
    private final YEAR startYear;
    private final YEAR endYear;

    public YearsRange(YEAR startYear, YEAR endYear) {
        this.startYear = startYear;
        this.endYear = endYear;
    }

    public int numberOfYears() {
        return ((Year)this.endYear()).year() - ((Year)this.startYear()).year() + 1;
    }

    public YEAR startYear() {
        return this.startYear;
    }

    public YEAR endYear() {
        return this.endYear;
    }

    public Interval interval() {
        return new Interval((ReadableInstant)((Year)this.startYear()).interval().getStart(), (ReadableInstant)((Year)this.endYear()).interval().getEnd());
    }

    public String representation() {
        return String.format("%d / %d", ((Year)this.startYear()).year(), ((Year)this.endYear()).year());
    }

    public abstract Iterable<YearMonth> months(int var1);

    public Stream<YearMonth> monate(int month) {
        return StreamSupport.stream(this.months(month).spliterator(), false);
    }

    public Iterable<YearMonth> allMonths() {
        YearsRange yearsRange = this;
        return () -> new AllMonthsIterator(yearsRange);
    }

    private static class AllMonthsIterator<YEAR extends Year>
    implements Iterator<YearMonth> {
        private YearMonth currentMonth;
        private final YearsRange<YEAR> years;

        private AllMonthsIterator(YearsRange<YEAR> years) {
            this.currentMonth = ((Year)years.startYear()).anfangsmonat();
            this.years = years;
        }

        @Override
        public boolean hasNext() {
            return !this.currentMonth.isAfter(((Year)this.years.endYear()).endmonat());
        }

        @Override
        public YearMonth next() {
            this.currentMonth = this.currentMonth.next();
            return this.currentMonth;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

