/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.util.Format;
import org.joda.time.DateTime;

public abstract class Years
implements Iterable<Year> {
    private final Set<Year> years = new HashSet<Year>();

    public void add(Year year) {
        this.years.add(year);
    }

    public void add(Years years) {
        this.years.addAll(years.years);
    }

    public boolean contain(Year year) {
        return this.years.contains(year);
    }

    public boolean exist() {
        return !this.years.isEmpty();
    }

    public boolean contain(TimestampedValue value) {
        return this.contain(value.timestamp());
    }

    public boolean contain(DateTime timestamp) {
        return this.years.stream().anyMatch(outageYear -> outageYear.contains(timestamp));
    }

    public int count() {
        return this.years.size();
    }

    @Override
    public Iterator<Year> iterator() {
        return this.years.iterator();
    }

    public String representation() {
        TreeSet<Integer> years = new TreeSet<Integer>();
        for (Year year : this) {
            years.add(year.year());
        }
        List<Range> groupedYears = this.groupYears(new ArrayList<Integer>(years));
        List groupStrings = groupedYears.stream().map(Range::representation).collect(Collectors.toList());
        return Format.join(groupStrings, ", ");
    }

    private List<Range> groupYears(List<Integer> sortedYears) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int start = 0;
        for (int i2 = 1; i2 < sortedYears.size(); ++i2) {
            if (sortedYears.get(i2 - 1) + 1 == sortedYears.get(i2)) continue;
            ranges.add(new Range(sortedYears.get(start), sortedYears.get(i2 - 1)));
            start = i2;
        }
        ranges.add(new Range(sortedYears.get(start), sortedYears.get(sortedYears.size() - 1)));
        return ranges;
    }

    private static class Range {
        private final int startYear;
        private final int endYear;

        public Range(int startYear, int endYear) {
            this.startYear = startYear;
            this.endYear = endYear;
        }

        public String representation() {
            if (this.startYear == this.endYear) {
                return String.valueOf(this.startYear);
            }
            return String.format("%d-%d", this.startYear, this.endYear);
        }
    }
}

