/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import luwa.marlin.ship_library.model.J\u00e4hrlichkeit;
import luwa.marlin.ship_library.model.value.TimestampedValue;

public class J\u00e4hrlichkeiten {
    private final long messstellenNummer;
    private final double HQ2;
    private final double HQ5;
    private final double HQ10;
    private final double HQ20;
    private final double HQ50;
    private final double HQ100;
    private final double HQ200ber;

    public J\u00e4hrlichkeiten(long messstellenNummer, double HQ2, double HQ5, double HQ10, double HQ20, double HQ50, double HQ100, double HQ200ber) {
        this.messstellenNummer = messstellenNummer;
        this.HQ2 = HQ2;
        this.HQ5 = HQ5;
        this.HQ10 = HQ10;
        this.HQ20 = HQ20;
        this.HQ50 = HQ50;
        this.HQ100 = HQ100;
        this.HQ200ber = HQ200ber;
    }

    public long messstellenNummer() {
        return this.messstellenNummer;
    }

    public J\u00e4hrlichkeit j\u00e4hrlichkeitF\u00fcr(TimestampedValue HQ) {
        if (null == HQ || HQ.istL\u00fccke()) {
            return null;
        }
        double Q = HQ.wert();
        if (Q >= this.HQ200ber) {
            return new J\u00e4hrlichkeit(200.0);
        }
        if (Q >= this.HQ100) {
            return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(100.0, 200.0, this.HQ100, this.HQ200ber, Q));
        }
        if (Q >= this.HQ50) {
            return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(50.0, 100.0, this.HQ50, this.HQ100, Q));
        }
        if (Q >= this.HQ20) {
            return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(20.0, 50.0, this.HQ20, this.HQ50, Q));
        }
        if (Q >= this.HQ10) {
            return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(10.0, 20.0, this.HQ10, this.HQ20, Q));
        }
        if (Q >= this.HQ5) {
            return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(5.0, 10.0, this.HQ5, this.HQ10, Q));
        }
        if (Q >= this.HQ2) {
            return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(2.0, 5.0, this.HQ2, this.HQ5, Q));
        }
        return new J\u00e4hrlichkeit(J\u00e4hrlichkeiten.lineareInterpolation(0.0, 2.0, 0.0, this.HQ2, Q));
    }

    private static double lineareInterpolation(double a0, double a1, double q0, double q1, double q2) {
        return J\u00e4hrlichkeiten.lerp(a0, a1, (q2 - q0) / (q1 - q0));
    }

    private static double lerp(double v0, double v1, double t2) {
        return (1.0 - t2) * v0 + t2 * v1;
    }
}

