/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.Years;

public class Ausfalljahre
extends Years {
    public static final Ausfalljahre keine = Ausfalljahre.keine();

    public String comment() {
        if (!this.exist()) {
            return "Keine Ausfalljahre in der Jahresreihe.";
        }
        String label = "Ausfalljahre";
        if (this.count() == 1) {
            label = "Ausfalljahr";
        }
        return label + " : " + this.representation();
    }

    public String commentAnalog() {
        if (!this.exist()) {
            return "Die ungepr\u00fcften Rohdaten haben keine Ausfalljahre in der Jahresreihe.";
        }
        String label = "Ausfalljahre in den ungepr\u00fcften Rohdaten";
        if (this.count() == 1) {
            label = "Ausfalljahr in den ungepr\u00fcften Rohdaten";
        }
        return label + " : " + this.representation();
    }

    public boolean intersects(Year year) {
        return super.contain(year.interval().getStart()) || super.contain(year.interval().getEnd());
    }

    private static Ausfalljahre keine() {
        return new Ausfalljahre();
    }
}

