/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.year;

import java.util.Iterator;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearsRange;

public class Abflussjahresreihe
extends YearsRange<Abflussjahr> {
    public Abflussjahresreihe(int startYear, int endYear) {
        this(new Abflussjahr(startYear), new Abflussjahr(endYear));
    }

    public Abflussjahresreihe(Abflussjahr startYear, Abflussjahr endYear) {
        super(startYear, endYear);
    }

    @Override
    public Iterator<Abflussjahr> iterator() {
        return new HydrologicalYearIterator(this);
    }

    @Override
    public Iterable<YearMonth> months(int month) {
        Abflussjahresreihe yearsRange = this;
        return () -> new MonthsIterator(yearsRange, month);
    }

    private static class HydrologicalYearIterator
    implements Iterator<Abflussjahr> {
        private final YearsRange<Abflussjahr> years;
        private int currentYear;

        public HydrologicalYearIterator(YearsRange<Abflussjahr> years) {
            this.years = years;
            this.currentYear = years.startYear().year();
        }

        @Override
        public boolean hasNext() {
            return this.currentYear <= this.years.endYear().year();
        }

        @Override
        public Abflussjahr next() {
            Abflussjahr next = new Abflussjahr(this.currentYear);
            ++this.currentYear;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MonthsIterator
    implements Iterator<YearMonth> {
        private final int endYear;
        private final int month;
        private int currentYear;

        public MonthsIterator(YearsRange<Abflussjahr> years, int month) {
            int startYear = MonthsIterator.startYear(years, month);
            this.endYear = MonthsIterator.endYear(years, month);
            this.month = month;
            this.currentYear = startYear;
        }

        private static int startYear(YearsRange<Abflussjahr> years, int month) {
            if (month == 11 || month == 12) {
                return years.startYear().year() - 1;
            }
            return years.startYear().year();
        }

        private static int endYear(YearsRange<Abflussjahr> years, int month) {
            if (month == 11 || month == 12) {
                return years.endYear().year() - 1;
            }
            return years.endYear().year();
        }

        @Override
        public boolean hasNext() {
            return this.currentYear <= this.endYear;
        }

        @Override
        public YearMonth next() {
            YearMonth next = new YearMonth(this.currentYear, this.month);
            ++this.currentYear;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

