/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.uebersicht;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ProjektHWGKAbgleichModel {
    private static final DateTimeFormatter datumsformat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private final List<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte;

    public ProjektHWGKAbgleichModel(List<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte) {
        this.eigent\u00fcmerAbschnitte = eigent\u00fcmerAbschnitte;
    }

    public static ProjektHWGKAbgleichModel ausZeilen(ArrayList<Zeile> zeilen) {
        Map<String, List<Zeile>> nachEigent\u00fcmer = zeilen.stream().collect(Collectors.groupingBy(Zeile::eigent\u00fcmer));
        ArrayList<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte = new ArrayList<Eigent\u00fcmerAbschnitt>();
        for (String eigent\u00fcmer : nachEigent\u00fcmer.keySet().stream().sorted().toList()) {
            List<Zeile> zeilenF\u00fcrEigent\u00fcmer = nachEigent\u00fcmer.get(eigent\u00fcmer);
            Map<String, List<Zeile>> nachBetreiber = zeilenF\u00fcrEigent\u00fcmer.stream().collect(Collectors.groupingBy(Zeile::betreiber));
            ArrayList<BetreiberAbschnitt> betreiberAbschnitte = new ArrayList<BetreiberAbschnitt>();
            for (String betreiber : nachBetreiber.keySet().stream().sorted().toList()) {
                List<Zeile> zeilenF\u00fcrBetreiber = nachBetreiber.get(betreiber);
                BetreiberAbschnitt betreiberAbschnitt = new BetreiberAbschnitt(betreiber, zeilenF\u00fcrBetreiber);
                betreiberAbschnitte.add(betreiberAbschnitt);
            }
            Eigent\u00fcmerAbschnitt eigent\u00fcmerAbschnitt = new Eigent\u00fcmerAbschnitt(eigent\u00fcmer, betreiberAbschnitte);
            eigent\u00fcmerAbschnitte.add(eigent\u00fcmerAbschnitt);
        }
        return new ProjektHWGKAbgleichModel(eigent\u00fcmerAbschnitte);
    }

    public String \u00fcberschrift() {
        return "\u00dcbersicht \u00fcber alle Pegel im Projekt HWGK-Abgleich";
    }

    public List<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte() {
        return this.eigent\u00fcmerAbschnitte;
    }

    public String darstellung() {
        return "# " + this.\u00fcberschrift() + "\n\n" + this.eigent\u00fcmerAbschnitte().stream().map(Eigent\u00fcmerAbschnitt::darstellung).collect(Collectors.joining("\n"));
    }

    public String toString() {
        return this.darstellung();
    }

    public static final class BetreiberAbschnitt {
        private final String betreiber;
        private final List<Zeile> zeilen;

        public BetreiberAbschnitt(String betreiber, List<Zeile> zeilen) {
            this.betreiber = betreiber;
            this.zeilen = zeilen;
        }

        public String betreiber() {
            return this.betreiber;
        }

        public List<Zeile> zeilen() {
            return this.zeilen;
        }

        public String darstellung() {
            return "### " + this.betreiber() + "\n\n" + this.zeilen().stream().map(Zeile::darstellung).collect(Collectors.joining("\n"));
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Eigent\u00fcmerAbschnitt {
        private final String eigent\u00fcmer;
        private final List<BetreiberAbschnitt> betreiberAbschnitte;

        public Eigent\u00fcmerAbschnitt(String eigent\u00fcmer, List<BetreiberAbschnitt> betreiberAbschnitte) {
            this.eigent\u00fcmer = eigent\u00fcmer;
            this.betreiberAbschnitte = betreiberAbschnitte;
        }

        public String eigent\u00fcmer() {
            return this.eigent\u00fcmer;
        }

        public List<BetreiberAbschnitt> betreiberAbschnitte() {
            return this.betreiberAbschnitte;
        }

        public String darstellung() {
            return "## " + this.eigent\u00fcmer() + "\n\n" + this.betreiberAbschnitte().stream().map(BetreiberAbschnitt::darstellung).collect(Collectors.joining("\n"));
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static enum BemerkungFarbe {
        rot("alert alert-danger"),
        gelb("alert alert-warning"),
        gr\u00fcn("alert alert-success"),
        grau("alert alert-none");

        private final String cssClass;

        private BemerkungFarbe(String cssClass) {
            this.cssClass = cssClass;
        }

        public String cssClass() {
            return this.cssClass;
        }
    }

    public static final class Bemerkung {
        private final String text;
        private final Optional<BemerkungFarbe> farbe;
        public static final Bemerkung fachlichAbgestimmtUndAbgeschlossen = new Bemerkung("Fachlich abgestimmt und abgeschlossen", Optional.of(BemerkungFarbe.gr\u00fcn));
        public static final Bemerkung keineFachlicheL\u00f6sungImProjektM\u00f6glich = new Bemerkung("Keine Fachliche L\u00f6sung im Projekt m\u00f6glich", Optional.of(BemerkungFarbe.rot));
        public static final Bemerkung keineHWGKSt\u00fctzstellenVorhanden = new Bemerkung("Keine HWGK-St\u00fctzstellen vorhanden", Optional.of(BemerkungFarbe.grau));
        public static final Bemerkung wvImProjekt = new Bemerkung("WV im Projekt", Optional.of(BemerkungFarbe.gelb));

        public Bemerkung(String text, Optional<BemerkungFarbe> farbe) {
            this.text = text;
            this.farbe = farbe;
        }

        public String text() {
            return this.text;
        }

        public Optional<BemerkungFarbe> farbe() {
            return this.farbe;
        }

        public String darstellung() {
            return this.farbe().map(it -> "[" + it.name() + "] ").orElse("") + this.text();
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Abflusskurve {
        private final String name;
        private final Optional<ZonedDateTime> ersteG\u00fcltigkeit;

        public Abflusskurve(String name, Optional<ZonedDateTime> ersteG\u00fcltigkeit) {
            this.name = name;
            this.ersteG\u00fcltigkeit = ersteG\u00fcltigkeit;
        }

        public String name() {
            return this.name;
        }

        public Optional<ZonedDateTime> ersteG\u00fcltigkeit() {
            return this.ersteG\u00fcltigkeit;
        }

        public String darstellung() {
            return String.format("%s\n%s", this.name(), this.darstellungErsteG\u00fcltigkeit());
        }

        private String darstellungErsteG\u00fcltigkeit() {
            return this.ersteG\u00fcltigkeit().map(datum -> "Erste G\u00fcltigkeit: " + datumsformat.format((TemporalAccessor)datum)).orElse("Noch nie g\u00fcltig");
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Messstelle {
        private final long nummer;
        private final String standort;
        private final String gew\u00e4sser;

        public Messstelle(long nummer, String standort, String gew\u00e4sser) {
            this.nummer = nummer;
            this.standort = standort;
            this.gew\u00e4sser = gew\u00e4sser;
        }

        public long nummer() {
            return this.nummer;
        }

        public String darstellung() {
            return String.format("%d %s - %s", this.nummer, this.standort, this.gew\u00e4sser);
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Zeile {
        private final String eigent\u00fcmer;
        private final String betreiber;
        private final Messstelle messstelle;
        private final Optional<ZonedDateTime> datum;
        private final Optional<Abflusskurve> abflusskurve;
        private final List<Bemerkung> bemerkungen;
        private final Optional<Abflusskurve> g\u00fcltigeAbflusskurve;
        private final Optional<String> hvz\u00dcbergabekurve;

        public Zeile(String eigent\u00fcmer, String betreiber, Messstelle messstelle, Optional<ZonedDateTime> datum, Optional<Abflusskurve> abflusskurve, List<Bemerkung> bemerkungen, Optional<Abflusskurve> g\u00fcltigeAbflusskurve, Optional<String> hvz\u00dcbergabekurve) {
            this.eigent\u00fcmer = eigent\u00fcmer;
            this.betreiber = betreiber;
            this.messstelle = messstelle;
            this.datum = datum;
            this.abflusskurve = abflusskurve;
            this.bemerkungen = bemerkungen;
            this.g\u00fcltigeAbflusskurve = g\u00fcltigeAbflusskurve;
            this.hvz\u00dcbergabekurve = hvz\u00dcbergabekurve;
        }

        public String eigent\u00fcmer() {
            return this.eigent\u00fcmer;
        }

        public String betreiber() {
            return this.betreiber;
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        public Optional<ZonedDateTime> datum() {
            return this.datum;
        }

        public String darstellungDatum() {
            return this.datum().map(datumsformat::format).orElse("kein Abgleich");
        }

        public Optional<Abflusskurve> abflusskurve() {
            return this.abflusskurve;
        }

        public String darstellungAbflusskurve() {
            return this.abflusskurve().map(Abflusskurve::darstellung).orElse("");
        }

        public Optional<Abflusskurve> g\u00fcltigeAbflusskurve() {
            return this.g\u00fcltigeAbflusskurve;
        }

        public List<Bemerkung> bemerkungen() {
            return this.bemerkungen;
        }

        public String darstellungG\u00fcltigeAbflusskurve() {
            return this.g\u00fcltigeAbflusskurve().map(Abflusskurve::darstellung).orElse("keine g\u00fcltige Abflusskurve\nNoch nie g\u00fcltig");
        }

        public String darstellungHVZ\u00dcbergabekurve() {
            return this.hvz\u00dcbergabekurve.orElse("keine Abflusskurve");
        }

        public String darstellung() {
            return String.join((CharSequence)" | ", List.of(this.messstelle.darstellung(), this.darstellungDatum(), this.darstellungAbflusskurve(), this.bemerkungen.stream().map(Bemerkung::darstellung).collect(Collectors.joining("\n")), this.darstellungG\u00fcltigeAbflusskurve(), this.darstellungHVZ\u00dcbergabekurve())).replace("\n", "<br>");
        }

        public String toString() {
            return this.darstellung();
        }
    }
}

