/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model.uebersicht;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class PegelMitUng\u00fcltigerWQBeziehungModel {
    private static final DateTimeFormatter datumsformat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private final List<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte;

    public PegelMitUng\u00fcltigerWQBeziehungModel(List<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte) {
        this.eigent\u00fcmerAbschnitte = eigent\u00fcmerAbschnitte;
    }

    public static PegelMitUng\u00fcltigerWQBeziehungModel ausZeilen(ArrayList<Zeile> zeilen) {
        Map<String, List<Zeile>> nachEigent\u00fcmer = zeilen.stream().collect(Collectors.groupingBy(Zeile::eigent\u00fcmer));
        ArrayList<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte = new ArrayList<Eigent\u00fcmerAbschnitt>();
        for (String eigent\u00fcmer : nachEigent\u00fcmer.keySet().stream().sorted().toList()) {
            List<Zeile> zeilenF\u00fcrEigent\u00fcmer = nachEigent\u00fcmer.get(eigent\u00fcmer);
            Map<String, List<Zeile>> nachBetreiber = zeilenF\u00fcrEigent\u00fcmer.stream().collect(Collectors.groupingBy(Zeile::betreiber));
            ArrayList<BetreiberAbschnitt> betreiberAbschnitte = new ArrayList<BetreiberAbschnitt>();
            for (String betreiber : nachBetreiber.keySet().stream().sorted().toList()) {
                List<Zeile> zeilenF\u00fcrBetreiber = nachBetreiber.get(betreiber);
                BetreiberAbschnitt betreiberAbschnitt = new BetreiberAbschnitt(betreiber, zeilenF\u00fcrBetreiber);
                betreiberAbschnitte.add(betreiberAbschnitt);
            }
            Eigent\u00fcmerAbschnitt eigent\u00fcmerAbschnitt = new Eigent\u00fcmerAbschnitt(eigent\u00fcmer, betreiberAbschnitte);
            eigent\u00fcmerAbschnitte.add(eigent\u00fcmerAbschnitt);
        }
        return new PegelMitUng\u00fcltigerWQBeziehungModel(eigent\u00fcmerAbschnitte);
    }

    public String \u00fcberschrift() {
        return "\u00dcbersicht \u00fcber alle Pegel mit ung\u00fcltiger W-Q-Beziehung";
    }

    public List<Eigent\u00fcmerAbschnitt> eigent\u00fcmerAbschnitte() {
        return this.eigent\u00fcmerAbschnitte;
    }

    public String darstellung() {
        return "# " + this.\u00fcberschrift() + "\n\n" + this.eigent\u00fcmerAbschnitte().stream().map(Eigent\u00fcmerAbschnitt::darstellung).collect(Collectors.joining("\n"));
    }

    public String toString() {
        return this.darstellung();
    }

    public static final class BetreiberAbschnitt {
        private final String betreiber;
        private final List<Zeile> zeilen;

        public BetreiberAbschnitt(String betreiber, List<Zeile> zeilen) {
            this.betreiber = betreiber;
            this.zeilen = zeilen;
        }

        public String betreiber() {
            return this.betreiber;
        }

        public List<Zeile> zeilen() {
            return this.zeilen;
        }

        public String darstellung() {
            return "### " + this.betreiber() + "\n\n" + this.zeilen().stream().map(Zeile::darstellung).collect(Collectors.joining("\n"));
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Eigent\u00fcmerAbschnitt {
        private final String eigent\u00fcmer;
        private final List<BetreiberAbschnitt> betreiberAbschnitte;

        public Eigent\u00fcmerAbschnitt(String eigent\u00fcmer, List<BetreiberAbschnitt> betreiberAbschnitte) {
            this.eigent\u00fcmer = eigent\u00fcmer;
            this.betreiberAbschnitte = betreiberAbschnitte;
        }

        public String eigent\u00fcmer() {
            return this.eigent\u00fcmer;
        }

        public List<BetreiberAbschnitt> betreiberAbschnitte() {
            return this.betreiberAbschnitte;
        }

        public String darstellung() {
            return "## " + this.eigent\u00fcmer() + "\n\n" + this.betreiberAbschnitte().stream().map(BetreiberAbschnitt::darstellung).collect(Collectors.joining("\n"));
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class G\u00fcltigeAbflusskurve {
        private final String name;
        private final ZonedDateTime g\u00fcltigSeit;

        public G\u00fcltigeAbflusskurve(String name, ZonedDateTime g\u00fcltigSeit) {
            this.name = name;
            this.g\u00fcltigSeit = g\u00fcltigSeit;
        }

        public String name() {
            return this.name;
        }

        public ZonedDateTime g\u00fcltigSeit() {
            return this.g\u00fcltigSeit;
        }

        public String darstellungG\u00fcltigSeit() {
            return datumsformat.format(this.g\u00fcltigSeit());
        }

        public String darstellung() {
            return this.darstellungG\u00fcltigSeit() + " " + this.name();
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Messstelle {
        private final long nummer;
        private final String standort;
        private final String gew\u00e4sser;

        public Messstelle(long nummer, String standort, String gew\u00e4sser) {
            this.nummer = nummer;
            this.standort = standort;
            this.gew\u00e4sser = gew\u00e4sser;
        }

        public long nummer() {
            return this.nummer;
        }

        public String darstellung() {
            return String.format("%d %s - %s", this.nummer, this.standort, this.gew\u00e4sser);
        }

        public String toString() {
            return this.darstellung();
        }
    }

    public static final class Zeile {
        private final String eigent\u00fcmer;
        private final String betreiber;
        private final Messstelle messstelle;
        private final boolean W_au\u00dferBetrieb;
        private final boolean Q_au\u00dferBetrieb;
        private final Optional<G\u00fcltigeAbflusskurve> g\u00fcltigeAbflusskurve;
        private final boolean hat\u00dcberhauptG\u00fcltigkeiten;
        private static final String symbolAu\u00dferBetrieb = "\u2300";

        public Zeile(String eigent\u00fcmer, String betreiber, Messstelle messstelle, boolean W_au\u00dferBetrieb, boolean Q_au\u00dferBetrieb, Optional<G\u00fcltigeAbflusskurve> g\u00fcltigeAbflusskurve, boolean hat\u00dcberhauptG\u00fcltigkeiten) {
            this.eigent\u00fcmer = eigent\u00fcmer;
            this.betreiber = betreiber;
            this.messstelle = messstelle;
            this.W_au\u00dferBetrieb = W_au\u00dferBetrieb;
            this.Q_au\u00dferBetrieb = Q_au\u00dferBetrieb;
            this.g\u00fcltigeAbflusskurve = g\u00fcltigeAbflusskurve;
            this.hat\u00dcberhauptG\u00fcltigkeiten = hat\u00dcberhauptG\u00fcltigkeiten;
        }

        public String eigent\u00fcmer() {
            return this.eigent\u00fcmer;
        }

        public String betreiber() {
            return this.betreiber;
        }

        public Messstelle messstelle() {
            return this.messstelle;
        }

        public boolean W_au\u00dferBetrieb() {
            return this.W_au\u00dferBetrieb;
        }

        public boolean Q_au\u00dferBetrieb() {
            return this.Q_au\u00dferBetrieb;
        }

        public String darstellungW_au\u00dferBetrieb() {
            return this.W_au\u00dferBetrieb() ? symbolAu\u00dferBetrieb : "";
        }

        public String darstellungQ_au\u00dferBetrieb() {
            return this.Q_au\u00dferBetrieb() ? symbolAu\u00dferBetrieb : "";
        }

        public Optional<G\u00fcltigeAbflusskurve> g\u00fcltigeAbflusskurve() {
            return this.g\u00fcltigeAbflusskurve;
        }

        public boolean hat\u00dcberhauptG\u00fcltigkeiten() {
            return this.hat\u00dcberhauptG\u00fcltigkeiten;
        }

        public String darstellungLetzterEintragInDenG\u00fcltigkeiten() {
            if (!this.hat\u00dcberhauptG\u00fcltigkeiten()) {
                return "Keine Abflusskurve vorhanden";
            }
            return this.g\u00fcltigeAbflusskurve().map(G\u00fcltigeAbflusskurve::darstellung).orElse("Keine g\u00fcltige Abflusskurve");
        }

        public String darstellung() {
            return String.join((CharSequence)" | ", List.of(this.messstelle.darstellung(), "W: " + this.darstellungW_au\u00dferBetrieb(), "Q: " + this.darstellungQ_au\u00dferBetrieb(), this.darstellungLetzterEintragInDenG\u00fcltigkeiten())).replace("\n", "<br>");
        }

        public String toString() {
            return this.darstellung();
        }
    }
}

