/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import luwa.marlin.ship_library.model.BearbeiteterZeitbereich;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInterval;

public class ZeitbereicheMitErg\u00e4nztenWerten {
    private final List<BearbeiteterZeitbereich> sortedRanges;

    public ZeitbereicheMitErg\u00e4nztenWerten(List<BearbeiteterZeitbereich> ranges) {
        this.sortedRanges = new ArrayList<BearbeiteterZeitbereich>(ranges);
        this.sortedRanges.sort(new MostRecentlyEditedFirst());
    }

    public List<BearbeiteterZeitbereich> ranges() {
        return this.sortedRanges;
    }

    public boolean isEdited(Interval day) {
        MergedIntervals moreRecentRedundancyOriginIntervals = new MergedIntervals();
        for (BearbeiteterZeitbereich edit : this.sortedEditRangesFor(day)) {
            if (edit.ist\u00dcbernommenAusRedundanz()) {
                moreRecentRedundancyOriginIntervals.addAndMerge(edit.zeitbereich());
                continue;
            }
            if (edit.isCompletelyCoveredByAnyOf(moreRecentRedundancyOriginIntervals)) continue;
            return true;
        }
        return false;
    }

    public boolean erg\u00e4nzterWertAnTag(DateTime timestamp) {
        return this.isEdited(ZeitbereicheMitErg\u00e4nztenWerten.dayIntervalFor(timestamp));
    }

    private static Interval dayIntervalFor(DateTime timestamp) {
        DateTime dayStart = timestamp.withMillisOfDay(0);
        DateTime dayEnd = new DateTime((Object)dayStart, DateTimeZone.forOffsetHours(1)).withTime(23, 59, 59, 999);
        return new Interval((ReadableInstant)dayStart, (ReadableInstant)dayEnd);
    }

    private Iterable<BearbeiteterZeitbereich> sortedEditRangesFor(Interval day) {
        ArrayList<BearbeiteterZeitbereich> result = new ArrayList<BearbeiteterZeitbereich>();
        for (BearbeiteterZeitbereich range : this.sortedRanges) {
            if (!ZeitbereicheMitErg\u00e4nztenWerten.overlap(day, range)) continue;
            Interval interval = day.overlap(range.zeitbereich());
            result.add(new BearbeiteterZeitbereich(interval, range.bearbeitungsdatum(), range.typ()));
        }
        return result;
    }

    private static boolean overlap(Interval day, BearbeiteterZeitbereich range) {
        Interval editedInterval = range.zeitbereich();
        return editedInterval.overlaps(day) || editedInterval.toDurationMillis() == 0L && editedInterval.abuts(day);
    }

    public ZeitbereicheMitErg\u00e4nztenWerten combinedWith(ZeitbereicheMitErg\u00e4nztenWerten moreEditedRanges) {
        ArrayList<BearbeiteterZeitbereich> combined = new ArrayList<BearbeiteterZeitbereich>();
        combined.addAll(this.ranges());
        combined.addAll(moreEditedRanges.ranges());
        return new ZeitbereicheMitErg\u00e4nztenWerten(combined);
    }

    private static class MostRecentlyEditedFirst
    implements Comparator<BearbeiteterZeitbereich> {
        private MostRecentlyEditedFirst() {
        }

        @Override
        public int compare(BearbeiteterZeitbereich a2, BearbeiteterZeitbereich b2) {
            return b2.bearbeitungsdatum().compareTo(a2.bearbeitungsdatum());
        }
    }

    private static class MergedIntervals
    implements Iterable<Interval> {
        private List<Interval> intervals = new ArrayList<Interval>();

        public void addAndMerge(Interval newInterval) {
            this.intervals.add(newInterval);
            this.intervals = MergedIntervals.merge(this.intervals);
        }

        @Override
        public Iterator<Interval> iterator() {
            return this.intervals.iterator();
        }

        private static List<Interval> merge(List<Interval> intervals) {
            Stack<Interval> stack = new Stack<Interval>();
            if (intervals.isEmpty()) {
                return new ArrayList<Interval>();
            }
            intervals.sort(Comparator.comparing(AbstractInterval::getStart));
            stack.push(intervals.get(0));
            for (int i2 = 1; i2 < intervals.size(); ++i2) {
                Interval top = (Interval)stack.peek();
                Interval current = intervals.get(i2);
                if (top.getEnd().isBefore(current.getStart())) {
                    stack.push(current);
                    continue;
                }
                if (!top.getEnd().isBefore(current.getEnd())) continue;
                top = new Interval((ReadableInstant)top.getStart(), (ReadableInstant)current.getEnd());
                stack.pop();
                stack.push(top);
            }
            return stack;
        }
    }
}

