/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import luwa.marlin.ship_library.model.TimeStampedValueCollection;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Tagesh\u00f6chstwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.util.math.MaxFinder;

public class Tagesh\u00f6chstwerte {
    private final TimeStampedValueCollection<Tagesh\u00f6chstwert> werte;

    public Tagesh\u00f6chstwerte() {
        this(NHNTransformationOfTimestampedValues.doNothing());
    }

    public Tagesh\u00f6chstwerte(NHNTransformationOfTimestampedValues nhnTransformation) {
        this.werte = new TimeStampedValueCollection(nhnTransformation);
    }

    public TimeStampedValueCollection<Tagesh\u00f6chstwert> werte() {
        return this.werte;
    }

    public void add(Tagesh\u00f6chstwert value) {
        this.werte().add(value);
    }

    public List<Tagesh\u00f6chstwert> values() {
        return this.werte().values();
    }

    public Stream<? extends TimestampedValue> werteF\u00fcrMonatFallsVollst\u00e4ndig(YearMonth month) {
        return this.werte().werteF\u00fcrMonatFallsVollst\u00e4ndig(month);
    }

    public Tagesh\u00f6chstwert yearWinterHW(Abflussjahr jahr) {
        return this.monthsHW_single(jahr.winter());
    }

    public Tagesh\u00f6chstwert yearSummerHW(Abflussjahr jahr) {
        return this.monthsHW_single(jahr.summer());
    }

    public List<Tagesh\u00f6chstwert> yearHW(Year year) {
        return this.monthsHW(year);
    }

    private Tagesh\u00f6chstwert monthsHW_single(Iterable<YearMonth> months) {
        List<Tagesh\u00f6chstwert> hws = this.monthsHW(months);
        if (hws.isEmpty()) {
            return null;
        }
        return hws.get(0);
    }

    public List<Tagesh\u00f6chstwert> monthsHW(Iterable<YearMonth> months) {
        MaxFinder<Tagesh\u00f6chstwert> maxFinder = new MaxFinder<Tagesh\u00f6chstwert>();
        for (YearMonth month : months) {
            maxFinder.add(this.werte.maxFinder(month));
        }
        return maxFinder.maxima();
    }

    public static Tagesh\u00f6chstwerte without(Tagesh\u00f6chstwerte tagesh\u00f6chstwerte, Predicate<Tagesh\u00f6chstwert> predicate) {
        Tagesh\u00f6chstwerte result = new Tagesh\u00f6chstwerte();
        tagesh\u00f6chstwerte.values().stream().filter(predicate.negate()).forEach(result::add);
        return result;
    }

    public boolean monatVollst\u00e4ndig(YearMonth monat) {
        return this.werte().monatVollst\u00e4ndig(monat);
    }

    public Optional<Tagesh\u00f6chstwert> desTages(Day tag) {
        return this.werte().desTages(tag);
    }

    public SortedMap<YearMonth, Optional<Tagesh\u00f6chstwert>> monatsh\u00f6chstwerte() {
        return this.werte().monthMax();
    }
}

