/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Stundenmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.util.Buckets;
import luwa.marlin.ship_library.util.math.MaxFinder;
import luwa.marlin.ship_library.util.math.Meaner;
import luwa.marlin.ship_library.util.math.MinFinder;

public class Stundenmittelwerte {
    private final List<Stundenmittelwert> values;
    private final Buckets<Day, Stundenmittelwert> dayBuckets;
    private final Map<YearMonth, MinFinder<Stundenmittelwert>> monthMinFinders;
    private final Map<Day, MaxFinder<Stundenmittelwert>> dayMaxFinders;
    private final Map<YearMonth, Meaner<Stundenmittelwert>> monthMeaners;
    private final NHNTransformationOfTimestampedValues transformOnAdd;

    public Stundenmittelwerte() {
        this(NHNTransformationOfTimestampedValues.doNothing());
    }

    public Stundenmittelwerte(NHNTransformationOfTimestampedValues transformOnAdd) {
        this.transformOnAdd = transformOnAdd;
        this.values = new ArrayList<Stundenmittelwert>();
        this.dayBuckets = new Buckets();
        this.dayMaxFinders = new HashMap<Day, MaxFinder<Stundenmittelwert>>();
        this.monthMinFinders = new HashMap<YearMonth, MinFinder<Stundenmittelwert>>();
        this.monthMeaners = new HashMap<YearMonth, Meaner<Stundenmittelwert>>();
    }

    public void add(Stundenmittelwert value) {
        Stundenmittelwert transformedValue = this.transformOnAdd.forValue(value);
        this.values.add(transformedValue);
        Day day = new Day(transformedValue.timestamp());
        this.dayBuckets.add(day, transformedValue);
        this.minFinder(day.yearMonth()).add(transformedValue);
        this.meaner(day.yearMonth()).add(transformedValue);
        this.maxFinder(day).add(transformedValue);
    }

    public List<Stundenmittelwert> values() {
        return this.values;
    }

    public List<Stundenmittelwert> ofDay(Day day) {
        return this.dayBuckets.get(day);
    }

    public Stundenmittelwert ofHour(Day day, int hour) {
        return this.ofDay(day).stream().filter(wert -> wert.timestamp().getHourOfDay() == hour).findFirst().orElse(null);
    }

    public TimestampedValue monthMW(YearMonth month) {
        return this.meaner(month).mean();
    }

    private MinFinder<Stundenmittelwert> minFinder(YearMonth month) {
        MinFinder<Stundenmittelwert> minFinder = this.monthMinFinders.get(month);
        if (null == minFinder) {
            minFinder = new MinFinder();
            this.monthMinFinders.put(month, minFinder);
        }
        return minFinder;
    }

    private Meaner<Stundenmittelwert> meaner(YearMonth month) {
        Meaner<Stundenmittelwert> meaner = this.monthMeaners.get(month);
        if (null == meaner) {
            meaner = new Meaner();
            this.monthMeaners.put(month, meaner);
        }
        return meaner;
    }

    private MaxFinder<Stundenmittelwert> maxFinder(Day day) {
        MaxFinder<Stundenmittelwert> maxFinder = this.dayMaxFinders.get(day);
        if (null == maxFinder) {
            maxFinder = new MaxFinder();
            this.dayMaxFinders.put(day, maxFinder);
        }
        return maxFinder;
    }
}

