/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import luwa.marlin.ship_library.model.TimeStampedValueCollection;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearMonth;
import luwa.marlin.ship_library.model.year.YearsRange;

public class Scheitelwerte {
    private static final int extremesTopN = 10;
    private final TimeStampedValueCollection<Scheitelwert> werte;

    public Scheitelwerte() {
        this(NHNTransformationOfTimestampedValues.doNothing());
    }

    public Scheitelwerte(NHNTransformationOfTimestampedValues nhnTransformation) {
        this(new ArrayList<Scheitelwert>(), nhnTransformation);
    }

    public Scheitelwerte(List<Scheitelwert> values) {
        this(values, NHNTransformationOfTimestampedValues.doNothing());
    }

    public Scheitelwerte(List<Scheitelwert> values, NHNTransformationOfTimestampedValues nhnTransformation) {
        this.werte = new TimeStampedValueCollection(nhnTransformation);
        values.forEach(this.werte::add);
    }

    private TimeStampedValueCollection<Scheitelwert> werte() {
        return this.werte;
    }

    public void add(Scheitelwert value) {
        this.werte().add(value);
    }

    public List<Scheitelwert> values() {
        return this.werte().values();
    }

    public List<Scheitelwert> globalExtremesHW(int topN) {
        List sorted = this.werte().values().stream().filter(wert -> !wert.istL\u00fccke()).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        int toIndex = Math.min(topN, sorted.size());
        return sorted.subList(0, toIndex);
    }

    public List<Scheitelwert> extremwerteH(YearsRange<? extends Year> range) {
        ArrayList<Scheitelwert> sorted = new ArrayList<Scheitelwert>();
        for (Scheitelwert value : this.werte().values()) {
            if (!range.interval().contains(value.timestamp()) || value.istL\u00fccke()) continue;
            sorted.add(value);
        }
        sorted.sort(Collections.reverseOrder());
        int toIndex = Math.min(10, sorted.size());
        return sorted.subList(0, toIndex);
    }

    public Optional<Scheitelwert> ofDay(Day day) {
        for (Scheitelwert peak : this.werte().values()) {
            if (!day.equals(new Day(peak.timestamp()))) continue;
            return Optional.of(peak);
        }
        return Optional.empty();
    }

    public Scheitelwert nthInMonth(int peakNo, YearMonth month) {
        ArrayList<Scheitelwert> inMonth = new ArrayList<Scheitelwert>();
        for (Scheitelwert peak : this.werte().values()) {
            if (!month.contains(peak.timestamp())) continue;
            inMonth.add(peak);
        }
        ArrayList<Scheitelwert> sortedByTimestamp = new ArrayList<Scheitelwert>(inMonth);
        sortedByTimestamp.sort(Comparator.comparing(TimestampedValue::timestamp));
        if (peakNo >= sortedByTimestamp.size()) {
            return null;
        }
        return (Scheitelwert)sortedByTimestamp.get(peakNo);
    }

    public void addAll(Scheitelwerte scheitelwerte) {
        for (Scheitelwert v2 : scheitelwerte.values()) {
            this.werte().add(v2);
        }
    }
}

