/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.util.Format;
import luwa.marlin.time.Interval;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import org.joda.time.DateTime;

public class Pegelnullpunktwechsel {
    private final List<Pegelnullpunkt> sortiertePegelnullpunkte;
    private final Interval interval;

    public Pegelnullpunktwechsel(List<Pegelnullpunkt> pegelnullpunkte, Interval interval) {
        this.sortiertePegelnullpunkte = Pegelnullpunktwechsel.sortedByValidFrom(pegelnullpunkte);
        this.interval = interval;
    }

    public String comment() {
        if (!this.hasMultipleChanges()) {
            return "";
        }
        ArrayList<String> changeComments = new ArrayList<String>();
        for (int i2 = 1; i2 < this.sortiertePegelnullpunkte.size(); ++i2) {
            Pegelnullpunkt from = this.sortiertePegelnullpunkte.get(i2 - 1);
            Pegelnullpunkt to = this.sortiertePegelnullpunkte.get(i2);
            if (!this.interval.contains(to.g\u00fcltigVon()) || this.nothingChangedBetween(from, to)) continue;
            changeComments.add(this.changeComment(from, to));
        }
        return Format.join(changeComments, "\n");
    }

    public Optional<Pegelnullpunkt> nullpunktAm(DateTime date) {
        return this.nullpunktAm(TimestampedValue.jodaDateTimeToZonedDateTime(date));
    }

    public Optional<Pegelnullpunkt> nullpunktAm(ZonedDateTime date) {
        ArrayList<Pegelnullpunkt> newestFirst = new ArrayList<Pegelnullpunkt>(this.sortiertePegelnullpunkte);
        Collections.reverse(newestFirst);
        return newestFirst.stream().filter(zeroPoint -> zeroPoint.g\u00fcltigVon().isBefore(date)).findFirst();
    }

    private boolean nothingChangedBetween(Pegelnullpunkt from, Pegelnullpunkt to) {
        return from.\u00fcberNN() == to.\u00fcberNN() && from.h\u00f6hensystem().equals(to.h\u00f6hensystem()) && from.einheit().equals(to.einheit());
    }

    public boolean hasMultipleChanges() {
        return this.sortiertePegelnullpunkte.size() > 1;
    }

    private String changeComment(Pegelnullpunkt from, Pegelnullpunkt to) {
        ZonedDateTime date = to.g\u00fcltigVon();
        double diffInCm = (to.\u00fcberNN() - from.\u00fcberNN()) * 100.0;
        return String.format("Am %s erfolgte eine Nullpunkts\u00e4nderung um %s cm von PNP = %s auf PNP = %s.", Format.formatDay(date), Format.formatNumber(diffInCm), from.darstellung(), to.darstellung());
    }

    private static List<Pegelnullpunkt> sortedByValidFrom(List<Pegelnullpunkt> pegelnullpunkte) {
        ArrayList<Pegelnullpunkt> sorted = new ArrayList<Pegelnullpunkt>(pegelnullpunkte);
        sorted.sort(Comparator.comparing(Pegelnullpunkt::g\u00fcltigVon));
        return sorted;
    }
}

