/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.measure.MetricPrefix;
import javax.measure.quantity.Length;
import luwa.marlin.ship_library.model.Scheitelwerte;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.value.Scheitelwert;
import luwa.marlin.ship_library.model.value.Tagesmittelwert;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.model.year.Day;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.ship_library.model.year.YearsRange;
import luwa.marlin.ship_library.view.ExtremwerteRenderModel;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.Units;

public class Extremwerte {
    private final Tagesmittelwerte tagesmittelwerte;
    private final Scheitelwerte scheitelwerte;
    private final Optional<Scheitelwerte> scheitelwerteW;
    private final Optional<Tagesmittelwerte> tagesmittelwerteW;

    public Extremwerte(Tagesmittelwerte tagesmittelwerte, Scheitelwerte scheitelwerte, Optional<Tagesmittelwerte> tagesmittelwerteW, Optional<Scheitelwerte> scheitelwerteW) {
        this.tagesmittelwerte = tagesmittelwerte;
        this.scheitelwerte = scheitelwerte;
        this.tagesmittelwerteW = tagesmittelwerteW;
        this.scheitelwerteW = scheitelwerteW;
    }

    public List<Scheitelwert> globalExtremesHW(int topN) {
        return this.scheitelwerte.globalExtremesHW(topN);
    }

    public List<Tagesmittelwert> extremwerteNnachRichtlinie(YearsRange<? extends Year> range) {
        List<Tagesmittelwert> werte = this.tagesmittelwerte.ascending(range);
        LinkedList<Tagesmittelwert> minimaMitZeitabstand = new LinkedList<Tagesmittelwert>();
        Stream<Tagesmittelwert> nochZuBetrachtendeWerte = werte.stream().filter(wert -> !wert.istL\u00fccke());
        for (int i2 = 1; i2 <= 10; ++i2) {
            Optional<Tagesmittelwert> nextMinimum = nochZuBetrachtendeWerte.findFirst();
            nochZuBetrachtendeWerte = werte.stream().filter(wert -> !wert.istL\u00fccke());
            if (nextMinimum.isPresent()) {
                minimaMitZeitabstand.add(nextMinimum.get());
                for (Tagesmittelwert minimum : minimaMitZeitabstand) {
                    nochZuBetrachtendeWerte = nochZuBetrachtendeWerte.filter(wert -> !this.istImGleichenNiedrigwasserjahr((TimestampedValue)wert, minimum));
                }
                continue;
            }
            nochZuBetrachtendeWerte = Stream.empty();
        }
        return minimaMitZeitabstand;
    }

    private boolean istImGleichenNiedrigwasserjahr(TimestampedValue t1, TimestampedValue t2) {
        DateTime anfangNjahr = new DateTime(t1.timestamp().getMonthOfYear() >= 4 ? t1.timestamp().getYear() : t1.timestamp().getYear() - 1, 4, 1, 0, 0);
        DateTime endeNjahr = new DateTime(anfangNjahr.getYear() + 1, 3, 31, 0, 0);
        return new Interval((ReadableInstant)anfangNjahr, (ReadableInstant)endeNjahr).contains(t2.timestamp());
    }

    public Optional<Tagesmittelwert> extremWasserstandN(DateTime time) {
        return this.tagesmittelwerteW.get().ofDay(new Day(time));
    }

    public Optional<Scheitelwert> extremWasserstandH(DateTime time) {
        return this.scheitelwerteW.get().ofDay(new Day(time));
    }

    public List<Scheitelwert> extremwerteH(YearsRange<? extends Year> range) {
        return this.scheitelwerte.extremwerteH(range);
    }

    Optional<ComparableQuantity<Length>> extremWasserstandInSpalte(DateTime zeitpunkt, ExtremwerteRenderModel.HochOderNiedrigwasser hochOderNiedrigwasser) {
        if (hochOderNiedrigwasser.equals((Object)ExtremwerteRenderModel.HochOderNiedrigwasser.Hochwasser)) {
            Optional<Scheitelwert> wasserstandBeiScheitelwert = this.extremWasserstandH(zeitpunkt);
            return wasserstandBeiScheitelwert.map(scheitelwert -> Quantities.getQuantity(scheitelwert.wert(), MetricPrefix.CENTI(Units.METRE)));
        }
        Optional<Tagesmittelwert> wasserstandBeiScheitelwert = this.extremWasserstandN(zeitpunkt);
        return wasserstandBeiScheitelwert.map(tagesmittelwert -> Quantities.getQuantity(tagesmittelwert.istL\u00fccke() ? Double.NaN : tagesmittelwert.wert(), MetricPrefix.CENTI(Units.METRE)));
    }
}

