/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.measure.MetricPrefix;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import luwa.marlin.ship_library.model.AbflussOderWasserstand;
import luwa.marlin.ship_library.model.Dauerzahlen;
import luwa.marlin.ship_library.model.Erh\u00f6hterWert;
import luwa.marlin.ship_library.model.Tagesmittelwerte;
import luwa.marlin.ship_library.model.units.Abfluss;
import luwa.marlin.ship_library.model.units.Units;
import luwa.marlin.ship_library.model.year.Abflussjahr;
import luwa.marlin.ship_library.model.year.Abflussjahresreihe;
import luwa.marlin.ship_library.model.year.Ausfalljahre;
import luwa.marlin.ship_library.model.year.Year;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import tech.units.indriya.quantity.Quantities;

public class Dauertabelle {
    private final Tagesmittelwerte tagesmittelwerte;
    private final Ausfalljahre ausfalljahre;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final Function<Year, Stream<Integer>> jeweilsDauerzahlenF\u00fcrDGJTabelle;
    private static final Quantity<Abfluss> einLiterProSekunde = Quantities.getQuantity(0.001, Units.CUBIC_METRE_PER_SECOND);
    private static final Quantity<Length> einZentimeter = Quantities.getQuantity(1.0, MetricPrefix.CENTI(tech.units.indriya.unit.Units.METRE));
    public static final Erh\u00f6hterWert<Quantity<Abfluss>> erhoehterQWert = wert -> wert.add(einLiterProSekunde);
    public static final Erh\u00f6hterWert<Quantity<Length>> erhoehterWWert = wert -> wert.add(einZentimeter);
    public static final Erh\u00f6hterWert<Double> erh\u00f6hterQWert_OHNE_EINHEIT = wert -> wert + 0.001;
    public static final Erh\u00f6hterWert<Double> erh\u00f6hterWWert_OHNE_EINHEIT = wert -> wert + 1.0;
    public static final Erh\u00f6hterWert<Double> erh\u00f6hterWWertNHN_OHNE_EINHEIT = wert -> wert + 0.01;
    public static final List<Integer> dauerzahlenGemeinjahrInTagen = Dauertabelle.makeDays();
    public static final List<Integer> dauerzahlenSchaltjahrInTagen = Dauertabelle.makeLeapYearDays();
    static final BinaryOperator<Optional<Double>> takeMax = (x2, y2) -> {
        if (x2.isEmpty() || y2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Double)x2.get() >= (Double)y2.get() ? (Double)x2.get() : (Double)y2.get());
    };
    static final BinaryOperator<Optional<Double>> takeMin = (x2, y2) -> {
        if (x2.isEmpty() || y2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Double)x2.get() <= (Double)y2.get() ? (Double)x2.get() : (Double)y2.get());
    };

    public Dauertabelle(Tagesmittelwerte tagesmittelwerte, Ausfalljahre ausfalljahre, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
        this.tagesmittelwerte = Tagesmittelwerte.without(tagesmittelwerte, ausfalljahre::contain);
        this.ausfalljahre = ausfalljahre;
        this.jeweilsDauerzahlenF\u00fcrDGJTabelle = jahr -> {
            if (!ausfalljahre.contain((Year)jahr)) {
                return Dauertabelle.dauerzahlenInTagen(jahr).stream();
            }
            return Stream.empty();
        };
    }

    public SortedMap<Integer, Optional<Double>> dauertabelleNachRichtlinie(Year year, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
        List<Integer> dauerzahlenInTagen = dauerzahlen.dauerzahlenInTagen(year);
        return this.dauerwerteF\u00fcr(year, QoderW, dauerzahlenInTagen.stream());
    }

    public SortedMap<Integer, Optional<Double>> dauerwerteF\u00fcr(Year jahr, AbflussOderWasserstand QoderW, Stream<Integer> dauerzahlenInTagen) {
        TreeMap<Integer, Optional<Double>> result = new TreeMap<Integer, Optional<Double>>(Collections.reverseOrder());
        Comparator<Double> vergleich = this.tagesmittelwerte.werteVergleich();
        if (this.werteVollst\u00e4ndigF\u00fcr(jahr)) {
            List<Double> values = this.tagesmittelwerte.orderedAsDoubles(jahr);
            dauerzahlenInTagen.forEach(unterschreitungsdauerInTagen -> result.put((Integer)unterschreitungsdauerInTagen, Dauertabelle.berechneDauerwert(unterschreitungsdauerInTagen, values, QoderW, this.wasserstandBezugsh\u00f6he, vergleich)));
            return result;
        }
        return this.leereDauertabelle(jahr.istSchaltjahr());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean werteVollst\u00e4ndigF\u00fcr(Year year) {
        if (this.ausfalljahre.intersects(year)) return false;
        if (!year.monate().get().allMatch(this.tagesmittelwerte::monatVollst\u00e4ndig)) return false;
        return true;
    }

    private SortedMap<Integer, Optional<Double>> evtlAngepassteDauertabelleNachRichtlinie(Year year, AbflussOderWasserstand QoderW, Stream<Integer> dauerzahlenInTagen) {
        TreeMap<Integer, Optional<Double>> result = new TreeMap<Integer, Optional<Double>>(Collections.reverseOrder());
        List<Double> werte = this.tagesmittelwerte.orderedAsDoubles(year);
        dauerzahlenInTagen.forEach(dauerzahlInTagen -> result.put((Integer)dauerzahlInTagen, Dauertabelle.berechneDauerwert(this.angepasstFallsSchaltjahr(year, (Integer)dauerzahlInTagen), werte, QoderW, this.wasserstandBezugsh\u00f6he, Double::compareTo)));
        return result;
    }

    private int angepasstFallsSchaltjahr(Year year, Integer dauerzahlInTagen) {
        if (year.istSchaltjahr() && dauerzahlInTagen > 182) {
            return dauerzahlInTagen + 1;
        }
        return dauerzahlInTagen;
    }

    public static List<Integer> dauerzahlenInTagen(Year year) {
        if (year.istSchaltjahr()) {
            return dauerzahlenSchaltjahrInTagen;
        }
        return dauerzahlenGemeinjahrInTagen;
    }

    public SortedMap<Integer, Optional<Double>> mittlereWerteNachRichtlinie(Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
        if (this.tagesmittelwerte.jahresreiheVollst\u00e4ndig(abflussjahresreihe, this.ausfalljahre)) {
            List<Double> sortierteWerte = this.tagesmittelwerte.sortierteWerteImZeitraum(abflussjahresreihe, this.ausfalljahre);
            switch (dauerzahlen) {
                case NachDGJ: {
                    return Dauertabelle.mehrj\u00e4hrigeDauertabelle(abflussjahresreihe, this.ausfalljahre, sortierteWerte, QoderW, dauerzahlenGemeinjahrInTagen.stream(), this.wasserstandBezugsh\u00f6he);
                }
                case AlleTage: {
                    return Dauertabelle.mehrj\u00e4hrigeDauertabelle(abflussjahresreihe, this.ausfalljahre, sortierteWerte, QoderW, Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr().stream(), this.wasserstandBezugsh\u00f6he);
                }
            }
            throw new IllegalArgumentException(dauerzahlen.toString());
        }
        return this.leereDauertabelle(false);
    }

    public SortedMap<Integer, Optional<Double>> obereH\u00fcllwerteNachRichtlinie(Abflussjahresreihe yearsRange, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
        switch (dauerzahlen) {
            case NachDGJ: {
                return this.h\u00fcllwerte(yearsRange, QoderW, takeMax, this.jeweilsDauerzahlenF\u00fcrDGJTabelle, dauerzahlenGemeinjahrInTagen.stream());
            }
            case AlleTage: {
                return this.h\u00fcllwerte(yearsRange, QoderW, takeMax, jahr -> Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr().stream(), Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr().stream());
            }
        }
        throw new IllegalArgumentException(dauerzahlen.toString());
    }

    private SortedMap<Integer, Optional<Double>> h\u00fcllwerte(Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, BinaryOperator<Optional<Double>> takeMax, Function<Year, Stream<Integer>> dauerzahlenF\u00fcrJahr, Stream<Integer> dauerzahlenF\u00fcrTabelle) {
        if (this.tagesmittelwerte.jahresreiheVollst\u00e4ndig(abflussjahresreihe, this.ausfalljahre)) {
            return this.reduceDauertabellenWith(takeMax, abflussjahresreihe, QoderW, dauerzahlenF\u00fcrJahr, dauerzahlenF\u00fcrTabelle);
        }
        return this.leereDauertabelle(false);
    }

    public SortedMap<Integer, Optional<Double>> untereH\u00fcllwerteNachRichtlinie(Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Dauerzahlen dauerzahlen) {
        switch (dauerzahlen) {
            case NachDGJ: {
                return this.h\u00fcllwerte(abflussjahresreihe, QoderW, takeMin, this.jeweilsDauerzahlenF\u00fcrDGJTabelle, dauerzahlenGemeinjahrInTagen.stream());
            }
            case AlleTage: {
                return this.h\u00fcllwerte(abflussjahresreihe, QoderW, takeMin, jahr -> Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr().stream(), Dauertabelle.alleUnterschreitungsdauernInTagenImGemeinjahr().stream());
            }
        }
        throw new IllegalArgumentException(dauerzahlen.toString());
    }

    private SortedMap<Integer, Optional<Double>> reduceDauertabellenWith(BinaryOperator<Optional<Double>> binaryOperation, Abflussjahresreihe abflussjahresreihe, AbflussOderWasserstand QoderW, Function<Year, Stream<Integer>> dauerzahlenF\u00fcrJahr, Stream<Integer> dauerzahlenF\u00fcrTabelle) {
        TreeMap<Integer, Optional<Double>> result = new TreeMap<Integer, Optional<Double>>();
        List<SortedMap<Integer, Optional<Double>>> dauertabellen = this.angepassteDauertabellenImZeitraum(abflussjahresreihe, QoderW, dauerzahlenF\u00fcrJahr);
        dauerzahlenF\u00fcrTabelle.forEach(dauer -> {
            Optional<Optional> maxDauerwert = dauertabellen.stream().map(dauertabelle -> (Optional)dauertabelle.get(dauer)).reduce(binaryOperation);
            result.put((Integer)dauer, maxDauerwert.orElse(Optional.empty()));
        });
        return result;
    }

    private List<SortedMap<Integer, Optional<Double>>> angepassteDauertabellenImZeitraum(Abflussjahresreihe yearsRange, AbflussOderWasserstand QoderW, Function<Year, Stream<Integer>> dauerzahlenInJahr) {
        ArrayList<SortedMap<Integer, Optional<Double>>> dauertabellen = new ArrayList<SortedMap<Integer, Optional<Double>>>();
        for (Abflussjahr year : yearsRange) {
            if (this.ausfalljahre.contain(year)) continue;
            SortedMap<Integer, Optional<Double>> dauertabelle = this.evtlAngepassteDauertabelleNachRichtlinie(year, QoderW, dauerzahlenInJahr.apply(year));
            dauertabellen.add(dauertabelle);
        }
        return dauertabellen;
    }

    private static SortedMap<Integer, Optional<Double>> mehrj\u00e4hrigeDauertabelle(Abflussjahresreihe yearsRange, Ausfalljahre ausfalljahre, List<Double> sortierteWerte, AbflussOderWasserstand QoderW, Stream<Integer> dauerzahlenInTagen, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) {
        TreeMap<Integer, Optional<Double>> result = new TreeMap<Integer, Optional<Double>>();
        int n2 = Dauertabelle.numberOfValidYears(yearsRange, ausfalljahre);
        dauerzahlenInTagen.forEach(dauer -> {
            int index = dauer * n2;
            result.put((Integer)dauer, Dauertabelle.berechneDauerwert(index, sortierteWerte, QoderW, wasserstandBezugsh\u00f6he, Double::compareTo));
        });
        return result;
    }

    private static Optional<Double> n\u00e4chstH\u00f6hererWert(List<Double> werte, int index, Comparator<Double> vergleich) {
        double wert = werte.get(index);
        for (int k2 = index; k2 < werte.size(); ++k2) {
            double kandidatF\u00fcrH\u00f6herenWert = werte.get(k2);
            if (vergleich.compare(wert, kandidatF\u00fcrH\u00f6herenWert) >= 0) continue;
            return Optional.of(kandidatF\u00fcrH\u00f6herenWert);
        }
        return Optional.empty();
    }

    private static Optional<Double> berechneDauerwert(int index, List<Double> sortierteWerte, AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandsBezugsh\u00f6he, Comparator<Double> vergleich) {
        Double previousWert;
        if (index >= sortierteWerte.size()) {
            return Optional.empty();
        }
        double wert = sortierteWerte.get(index);
        if (index > 0 && vergleich.compare(previousWert = sortierteWerte.get(index - 1), wert) == 0) {
            Optional<Double> x2 = Dauertabelle.n\u00e4chstH\u00f6hererWert(sortierteWerte, index, vergleich);
            return Optional.of(x2.orElse(Dauertabelle.fiktiverHoechsterWert(sortierteWerte, QoderW, wasserstandsBezugsh\u00f6he)));
        }
        return Optional.of(wert);
    }

    private static double fiktiverHoechsterWert(List<Double> sortierteWerte, AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandsBezugsh\u00f6he) {
        Erh\u00f6hterWert<Double> erhoehterWert = Dauertabelle.erhoehterWert_OHNE_EINHEIT(QoderW, wasserstandsBezugsh\u00f6he);
        Double maximum = sortierteWerte.get(sortierteWerte.size() - 1);
        return erhoehterWert.von(maximum);
    }

    private static int numberOfValidYears(Abflussjahresreihe yearsRange, Ausfalljahre ausfalljahre) {
        int count = 0;
        for (Abflussjahr jahr : yearsRange) {
            if (ausfalljahre.contain(jahr)) continue;
            ++count;
        }
        return count;
    }

    public static Erh\u00f6hterWert<Double> erhoehterWert_OHNE_EINHEIT(AbflussOderWasserstand QoderW, WasserstandBezugsh\u00f6he wasserstandsBezugsh\u00f6he) {
        switch (QoderW) {
            case W: {
                switch (wasserstandsBezugsh\u00f6he) {
                    case Centimeter\u00dcberAktuellemPegelnullpunkt: {
                        return erh\u00f6hterWWert_OHNE_EINHEIT;
                    }
                    case Meter\u00dcberNHNnachHS170: {
                        return erh\u00f6hterWWertNHN_OHNE_EINHEIT;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + QoderW);
            }
            case Q: {
                return erh\u00f6hterQWert_OHNE_EINHEIT;
            }
        }
        throw new IllegalStateException("Unexpected value: " + QoderW);
    }

    private static List<Integer> makeLeapYearDays() {
        ArrayList<Integer> tage = new ArrayList<Integer>(Dauertabelle.makeDays());
        tage.add(0, 365);
        return tage;
    }

    private static List<Integer> makeDays() {
        List<Integer> result = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 60, 70, 90, 100, 110, 120, 130, 150, 182, 200, 210, 240, 270, 300, 320, 330, 340, 350, 356, 357, 358, 359, 360, 361, 362, 363, 364);
        result.sort(Collections.reverseOrder());
        return result;
    }

    private SortedMap<Integer, Optional<Double>> leereDauertabelle(boolean schaltjahr) {
        TreeMap<Integer, Optional<Double>> result = new TreeMap<Integer, Optional<Double>>(Collections.reverseOrder());
        List<Integer> tage = schaltjahr ? dauerzahlenSchaltjahrInTagen : dauerzahlenGemeinjahrInTagen;
        for (Integer dayKey : tage) {
            result.put(dayKey, Optional.empty());
        }
        return result;
    }

    public static List<Integer> alleUnterschreitungsdauernInTagenImGemeinjahr() {
        return IntStream.rangeClosed(0, 364).boxed().sorted((x2, y2) -> -Integer.compare(x2, y2)).collect(Collectors.toList());
    }

    public static List<Integer> alleUnterschreitungsdauernInTagenImSchaltjahr() {
        return IntStream.rangeClosed(0, 365).boxed().sorted((x2, y2) -> -Integer.compare(x2, y2)).collect(Collectors.toList());
    }

    public static String stringF\u00fcrTag(Integer tag) {
        if (tag == 365) {
            return "(365)";
        }
        return String.valueOf(tag);
    }
}

