/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.repository.DatenRepositoryMitVerkettung;
import luwa.marlin.ship_library.view.pdf.Zeitgrafik;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ZeitgrafikHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public ZeitgrafikHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "start", "end", "parameter", "color");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        long messstellenNummer = params.mandatoryLong("station");
        DateTime start = dateFormat.parseDateTime(params.mandatoryString("start")).withTime(0, 0, 0, 0);
        DateTime end = dateFormat.parseDateTime(params.mandatoryString("end")).withTime(23, 59, 59, 999);
        Parameter parameter = Parameter.valueOf(params.mandatoryString("parameter"));
        Color color = params.mandatoryColor("color");
        Optional<Integer> wMin = params.optionalInt("w_min");
        Optional<Integer> wMax = params.optionalInt("w_max");
        boolean withPre = params.optionalBoolean("with_pre");
        WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he = WasserstandBezugsh\u00f6he.NHNIfTrue(params.optionalBoolean("nhn"));
        DatenRepository source = parameter == Parameter.q && withPre ? new DatenRepositoryMitVerkettung(datenRepository) : datenRepository;
        return new Zeitgrafik(messstellenNummer, parameter, new Interval((ReadableInstant)start, (ReadableInstant)end), source, color, wMin, wMax, wasserstandBezugsh\u00f6he);
    }
}

