/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.HandUndSystemwerte;
import luwa.marlin.ship_library.view.text.Liste;
import luwa.marlin.ship_library.view.text.WeitereGanglinie;
import luwa.marlin.ship_library.view.text.helpers.Listenprodukt;
import luwa.marlin.ship_library.view.text.helpers.Trennzeichen;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ListeHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public ListeHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("stations", "start", "end", "parameter", "product", "user_id");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        List<Long> messstellenNummern = params.mandatoryLongList("stations");
        DateTime von = dateFormat.parseDateTime(params.mandatoryString("start")).withTime(0, 0, 0, 0);
        DateTime bis = dateFormat.parseDateTime(params.mandatoryString("end")).withTime(23, 59, 59, 999);
        Interval zeitraum = new Interval((ReadableInstant)von, (ReadableInstant)bis);
        long benutzerId = params.mandatoryLong("user_id");
        Parameter parameter = Parameter.valueOf(params.mandatoryString("parameter"));
        WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he = WasserstandBezugsh\u00f6he.NHNIfTrue(params.optionalBoolean("nhn"));
        Listenprodukt listenprodukt = Listenprodukt.fromKey(params.mandatoryString("product"));
        Trennzeichen trennzeichen = this.trennzeichen(params);
        if (listenprodukt == Listenprodukt.handUndSystemwerte) {
            return new HandUndSystemwerte(datenRepository, messstellenNummern, zeitraum, parameter, benutzerId, trennzeichen);
        }
        if (listenprodukt == Listenprodukt.weitereGanglinie) {
            String ganglinienName = params.mandatoryString("temp_series");
            return new WeitereGanglinie(datenRepository, messstellenNummern, zeitraum, parameter, benutzerId, ganglinienName, trennzeichen, wasserstandBezugsh\u00f6he);
        }
        boolean mitVorg\u00e4ngern = params.optionalBoolean("with_pre");
        return new Liste(datenRepository, messstellenNummern, zeitraum, parameter, benutzerId, listenprodukt, mitVorg\u00e4ngern, trennzeichen, wasserstandBezugsh\u00f6he);
    }
}

