/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library.http.handler;

import java.util.Arrays;
import javax.sql.DataSource;
import luwa.marlin.ship_library.http.OutputHandler;
import luwa.marlin.ship_library.model.Parameter;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.view.text.Bemerkungstexte;
import luwa.marlin.web.OutputView;
import luwa.marlin.web.Parameters;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class BemerkungstexteHandler
extends OutputHandler {
    private static final DateTimeFormatter dateFormat = DateTimeFormat.forPattern("yyyy-MM-dd").withZone(DateTimeZone.forOffsetHours(1));

    public BemerkungstexteHandler(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected Iterable<String> mandatoryParams() {
        return Arrays.asList("station", "start", "end", "parameter");
    }

    @Override
    protected OutputView createView(Parameters params, DatenRepository datenRepository) {
        long messstellenNummer = params.mandatoryLong("station");
        Parameter parameter = Parameter.valueOf(params.mandatoryString("parameter"));
        DateTime von = dateFormat.parseDateTime(params.mandatoryString("start")).withTime(0, 0, 0, 0);
        DateTime bis = dateFormat.parseDateTime(params.mandatoryString("end")).withTime(23, 59, 59, 999);
        Interval zeitraum = new Interval((ReadableInstant)von, (ReadableInstant)bis);
        return new Bemerkungstexte(messstellenNummer, parameter, zeitraum, datenRepository, this.trennzeichen(params));
    }
}

