/*
 * Decompiled with CFR 0.152.
 */
package luwa.marlin.ship_library;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import luwa.marlin.ship_library.model.Abflusskurve;
import luwa.marlin.ship_library.model.Benutzer;
import luwa.marlin.ship_library.model.Kurveng\u00fcltigkeit;
import luwa.marlin.ship_library.model.Messstelle;
import luwa.marlin.ship_library.model.value.NHNTransformationOfTimestampedValues;
import luwa.marlin.ship_library.model.value.TimestampedValue;
import luwa.marlin.ship_library.repository.DatenRepository;
import luwa.marlin.ship_library.util.UnzureichendeDatenlage;
import luwa.marlin.ship_library.view.TabellenHeaderRenderModel;
import luwa.marlin.ship_library.view.ViewHelper;
import luwa.marlin.wasserstand.Pegelnullpunkt;
import luwa.marlin.wasserstand.Pegelnullpunkte;
import luwa.marlin.wasserstand.WasserstandBezugsh\u00f6he;

public class AbflusskurventafelModel {
    private final Messstelle messstelle;
    private final Abflusskurve abflusskurve;
    private final Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeit;
    private final Benutzer benutzer;
    private final Optional<Pegelnullpunkt> pegelnullpunkt;
    private final WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he;
    private final NHNTransformationOfTimestampedValues transformation;

    public AbflusskurventafelModel(Messstelle messstelle, Abflusskurve abflusskurve, Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeit, Benutzer benutzer, Optional<Pegelnullpunkt> pegelnullpunkt, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he, NHNTransformationOfTimestampedValues transformation) {
        this.messstelle = messstelle;
        this.abflusskurve = abflusskurve;
        this.letzteG\u00fcltigkeit = letzteG\u00fcltigkeit;
        this.benutzer = benutzer;
        this.pegelnullpunkt = pegelnullpunkt;
        this.wasserstandBezugsh\u00f6he = wasserstandBezugsh\u00f6he;
        this.transformation = transformation;
    }

    public static AbflusskurventafelModel lade(DatenRepository datenRepository, long abflusskurvenId, long benutzerId, WasserstandBezugsh\u00f6he wasserstandBezugsh\u00f6he) throws Exception {
        Abflusskurve abflusskurve = datenRepository.abflusskurve(abflusskurvenId);
        long messstellenNummer = abflusskurve.messstellenNummer();
        Messstelle messstelle = datenRepository.messstelle(messstellenNummer);
        Benutzer benutzer = datenRepository.benutzer(benutzerId);
        Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeit = datenRepository.letzteG\u00fcltigkeitVon(abflusskurvenId);
        if (wasserstandBezugsh\u00f6he == WasserstandBezugsh\u00f6he.Meter\u00dcberNHNnachHS170) {
            if (letzteG\u00fcltigkeit.isEmpty()) {
                throw new UnzureichendeDatenlage("Abflusskurve hat keine G\u00fcltigkeit, es ist aber ein Datum f\u00fcr die NHN-Umrechnung n\u00f6tig.");
            }
            ZonedDateTime datumF\u00fcrUmrechnung = TimestampedValue.jodaDateTimeToZonedDateTime(letzteG\u00fcltigkeit.get().von());
            List<Pegelnullpunkt> pegelnullpunkte = datenRepository.pegelnullpunkte(messstellenNummer);
            Optional<Pegelnullpunkt> pegelnullpunkt = new Pegelnullpunkte(pegelnullpunkte).amZeitpunkt(datumF\u00fcrUmrechnung);
            ArrayList<Pegelnullpunkt> alsListe = new ArrayList<Pegelnullpunkt>();
            pegelnullpunkt.map(alsListe::add);
            NHNTransformationOfTimestampedValues transformation = new NHNTransformationOfTimestampedValues(alsListe, wasserstandBezugsh\u00f6he);
            return new AbflusskurventafelModel(messstelle, abflusskurve, letzteG\u00fcltigkeit, benutzer, pegelnullpunkt, wasserstandBezugsh\u00f6he, transformation);
        }
        Optional<Pegelnullpunkt> pegelnullpunkt = ViewHelper.pegelnullpunkt(datenRepository, messstellenNummer);
        return new AbflusskurventafelModel(messstelle, abflusskurve, letzteG\u00fcltigkeit, benutzer, pegelnullpunkt, wasserstandBezugsh\u00f6he, NHNTransformationOfTimestampedValues.doNothing());
    }

    public NHNTransformationOfTimestampedValues nhnTransformation() {
        return this.transformation;
    }

    public Messstelle messstelle() {
        return this.messstelle;
    }

    public Abflusskurve abflusskurve() {
        return this.abflusskurve;
    }

    public Optional<Kurveng\u00fcltigkeit> letzteG\u00fcltigkeit() {
        return this.letzteG\u00fcltigkeit;
    }

    public Benutzer benutzer() {
        return this.benutzer;
    }

    public TabellenHeaderRenderModel header() {
        return new TabellenHeaderRenderModel(this.messstelle, this.pegelnullpunkt, this.benutzer, this.wasserstandBezugsh\u00f6he);
    }
}

